/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.stream;

import android.content.Context;
import android.util.Log;
import com.ez.downloader.EZDownloader;
import com.ez.player.EZMediaPlayer;
import com.ez.stream.EZStreamClientManager;
import com.ez.stream.InitParam;
import com.videogo.errorlayer.ErrorInfo;
import com.videogo.errorlayer.ErrorLayer;
import com.videogo.exception.BaseException;
import com.videogo.openapi.EZOpenSDKListener;
import com.videogo.openapi.PlayAPI;
import com.videogo.openapi.bean.EZDeviceRecordFile;
import com.videogo.stream.EZStreamParamHelp;
import com.videogo.util.LogUtil;
import com.videogo.util.VideoTransUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EZDeviceStreamDownload {
    private static final String TAG = EZDeviceStreamDownload.class.getSimpleName();
    private EZDownloader downloadClient;
    private EZOpenSDKListener.EZStreamDownloadCallback streamDownloadCallback;
    public ExecutorService executorService = Executors.newSingleThreadExecutor();
    private String mDownloadPathTemp;
    private String mDownloadPath;
    private String mSecretKey;
    private String mStartTime = null;
    private String mStopTime = null;
    private boolean isTransPsToMp4 = false;

    public EZDeviceStreamDownload(String downloadPath, String deviceSerial, int cameraNumber, EZDeviceRecordFile recordFile) {
        if (downloadPath == null || recordFile == null || deviceSerial == null || cameraNumber < 0) {
            LogUtil.e(TAG, "EZDeviceStreamDownload: invalid params!!!");
            return;
        }
        this.mDownloadPath = downloadPath;
        this.mDownloadPathTemp = this.mDownloadPath + "_temp";
        EZStreamClientManager clientManager = EZStreamClientManager.create((Context)PlayAPI.mApplication.getApplicationContext());
        EZStreamParamHelp streamParamHelp = new EZStreamParamHelp(deviceSerial, cameraNumber);
        InitParam initParam = null;
        try {
            streamParamHelp.readyParamInfo();
            initParam = streamParamHelp.getInitParam(5);
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        if (clientManager != null && initParam != null && this.mDownloadPathTemp != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HHmmss");
            this.mStartTime = format.format(recordFile.getStartTime().getTime());
            this.mStartTime = this.mStartTime.replace(" ", "T");
            this.mStartTime = this.mStartTime + "Z";
            this.mStopTime = format.format(recordFile.getStopTime().getTime());
            this.mStopTime = this.mStopTime.replace(" ", "T");
            this.mStopTime = this.mStopTime + "Z";
            initParam.szStartTime = this.mStartTime;
            initParam.szStopTime = this.mStopTime;
            this.downloadClient = new EZDownloader(clientManager, initParam, this.mDownloadPathTemp);
        } else {
            Log.e((String)TAG, (String)"EZDeviceStreamDownload: failed! please check your params.");
        }
    }

    public void setSecretKey(String mSecretKey) {
        this.mSecretKey = mSecretKey;
    }

    public void setStreamDownloadCallback(EZOpenSDKListener.EZStreamDownloadCallback streamDownloadCallback) {
        this.streamDownloadCallback = streamDownloadCallback;
    }

    public synchronized void start() {
        File targetFile = new File(this.mDownloadPath);
        File targetFileFolder = targetFile.getParentFile();
        boolean isTargetFileFolderExist = true;
        if (!targetFileFolder.exists()) {
            isTargetFileFolderExist = targetFileFolder.mkdirs();
            LogUtil.d(TAG, "try to create targetFile folder: " + isTargetFileFolderExist);
        }
        if (this.downloadClient == null || this.mStartTime == null || this.mStopTime == null || !isTargetFileFolderExist) {
            LogUtil.e(TAG, "start:failed!, please check your params!");
            if (this.streamDownloadCallback != null) {
                this.streamDownloadCallback.onError(EZOpenSDKListener.EZStreamDownloadError.ERROR_EZSTREAM_DOWNLOAD_START);
            }
            this.stop();
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                EZDeviceStreamDownload.this.downloadClient.setMsgCallback(new EZDownloader.OnMsgCallBack(){

                    public void onError(EZMediaPlayer.MediaError mediaError, int errorCode) {
                        LogUtil.i(TAG, "from EZMediaPlayer, onError: " + mediaError.name() + ", " + errorCode);
                        ErrorInfo errorInfo = ErrorLayer.getErrorLayer(31, errorCode);
                        if (errorInfo != null) {
                            LogUtil.e(TAG, "onError: " + errorInfo.description + ", " + errorInfo.errorCode);
                        }
                        EZDeviceStreamDownload.this.tryToDeleteTempFile();
                        if (EZDeviceStreamDownload.this.streamDownloadCallback != null && errorInfo != null) {
                            if (EZDeviceStreamDownload.this.streamDownloadCallback instanceof EZOpenSDKListener.EZStreamDownloadCallbackEx) {
                                EZOpenSDKListener.EZStreamDownloadCallbackEx callbackEx = (EZOpenSDKListener.EZStreamDownloadCallbackEx)EZDeviceStreamDownload.this.streamDownloadCallback;
                                callbackEx.onErrorCode(errorInfo.errorCode);
                            }
                            switch (errorInfo.errorCode) {
                                case 380045: 
                                case 395416: {
                                    EZDeviceStreamDownload.this.streamDownloadCallback.onError(EZOpenSDKListener.EZStreamDownloadError.ERROR_EZSTREAM_DOWNLOAD_MAX_CONNECTIONS);
                                    break;
                                }
                                default: {
                                    EZDeviceStreamDownload.this.streamDownloadCallback.onError(EZOpenSDKListener.EZStreamDownloadError.ERROR_EZSTREAM_DOWNLOAD);
                                }
                            }
                        }
                    }

                    public void onInfo(EZMediaPlayer.MediaInfo mediaInfo) {
                        LogUtil.d(TAG, "onInfo: " + mediaInfo.name());
                        if (EZMediaPlayer.MediaInfo.MEDIA_INFO_PLAYING_FINISH == mediaInfo && !EZDeviceStreamDownload.this.isTransPsToMp4) {
                            EZDeviceStreamDownload.this.isTransPsToMp4 = true;
                            this.tryToTransPsToMp4();
                        }
                    }
                });
                LogUtil.d(TAG, "try to download video to " + EZDeviceStreamDownload.this.mDownloadPath);
                int ret = EZDeviceStreamDownload.this.downloadClient.startDownload();
                if (ret != 0) {
                    if (EZDeviceStreamDownload.this.streamDownloadCallback != null) {
                        EZDeviceStreamDownload.this.streamDownloadCallback.onError(EZOpenSDKListener.EZStreamDownloadError.ERROR_EZSTREAM_DOWNLOAD_START);
                    }
                    EZDeviceStreamDownload.this.stop();
                    LogUtil.e(TAG, "downloadClient.startDownload: failed!");
                }
            }

            private void tryToTransPsToMp4() {
                VideoTransUtil.TransPsToMp4(EZDeviceStreamDownload.this.mDownloadPathTemp, EZDeviceStreamDownload.this.mSecretKey, EZDeviceStreamDownload.this.mDownloadPath, new EZOpenSDKListener.EZStreamDownloadCallback(){

                    @Override
                    public void onSuccess(String filepath) {
                        LogUtil.d(TAG, "tryToTransPsToMp4-onSuccess: " + filepath);
                        EZDeviceStreamDownload.this.tryToDeleteTempFile();
                        if (EZDeviceStreamDownload.this.streamDownloadCallback != null) {
                            EZDeviceStreamDownload.this.streamDownloadCallback.onSuccess(filepath);
                        }
                    }

                    @Override
                    public void onError(EZOpenSDKListener.EZStreamDownloadError code) {
                        Log.d((String)TAG, (String)("tryToTransPsToMp4-onError: " + code.name()));
                        EZDeviceStreamDownload.this.tryToDeleteTempFile();
                        EZDeviceStreamDownload.this.tryToDeleteTargetFile();
                        if (EZDeviceStreamDownload.this.streamDownloadCallback != null) {
                            EZDeviceStreamDownload.this.streamDownloadCallback.onError(code);
                        }
                    }
                });
            }
        });
    }

    private void tryToDeleteTempFile() {
        LogUtil.d(TAG, "tempFile path is: " + this.mDownloadPathTemp);
        File tmpFile = new File(this.mDownloadPathTemp);
        if (tmpFile.exists()) {
            LogUtil.d(TAG, "try to delete tempFile " + tmpFile.delete());
        }
    }

    private void tryToDeleteTargetFile() {
        LogUtil.d(TAG, "targetFile path is: " + this.mDownloadPath);
        File targetFile = new File(this.mDownloadPath);
        if (targetFile.exists()) {
            LogUtil.d(TAG, "try to delete targetFile " + targetFile.delete());
        }
    }

    public synchronized void stop() {
        LogUtil.d(TAG, "downloadClient stop: ");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                EZDeviceStreamDownload.this.mStartTime = null;
                EZDeviceStreamDownload.this.mStopTime = null;
                if (EZDeviceStreamDownload.this.downloadClient != null) {
                    EZDeviceStreamDownload.this.downloadClient.stopDownload();
                    EZDeviceStreamDownload.this.downloadClient.destroy();
                    EZDeviceStreamDownload.this.downloadClient = null;
                }
                EZDeviceStreamDownload.this.streamDownloadCallback = null;
                File temp2 = new File(EZDeviceStreamDownload.this.mDownloadPathTemp);
                if (temp2.exists()) {
                    temp2.delete();
                }
            }
        });
    }
}

