/*
 * Decompiled with CFR 0.152.
 */
package com.videogo.stream;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ez.player.EZVoiceTalk;
import com.ez.stream.EZStreamClientManager;
import com.videogo.device.DeviceInfoEx;
import com.videogo.device.DeviceManager;
import com.videogo.errorlayer.ErrorInfo;
import com.videogo.errorlayer.ErrorLayer;
import com.videogo.exception.BaseException;
import com.videogo.openapi.PlayAPI;
import com.videogo.stream.EZStreamParamHelp;
import com.videogo.util.LogUtil;
import java.util.List;

public class EZTalkback {
    private static final String TAG = "EZTalkback";
    EZVoiceTalk mEZVoiceTalk;
    private Handler mHandler;
    private TalkBackSuccessCallback talkBackSuccessCallback;
    private EZStreamParamHelp mEZStreamParamHelp;

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public void setTalkBackSuccessCallback(TalkBackSuccessCallback talkBackSuccessCallback) {
        this.talkBackSuccessCallback = talkBackSuccessCallback;
    }

    public EZTalkback(EZStreamParamHelp streamParamHelp) {
        this.mEZStreamParamHelp = streamParamHelp;
        try {
            this.mEZVoiceTalk = new EZVoiceTalk(EZStreamClientManager.create((Context)PlayAPI.mApplication.getApplicationContext()), streamParamHelp.getInitParam(6));
            this.mEZVoiceTalk.setQosRspTimeout(streamParamHelp.getiQosRspTimeout());
            this.mEZVoiceTalk.setOnVoiceTalkListener(new EZVoiceTalk.OnVoiceTalkListener(){

                public boolean onError(EZVoiceTalk ezVoiceTalk, int i) {
                    if (i == 0) {
                        LogUtil.d(EZTalkback.TAG, "streamsdk. start talkback succeeded");
                        if (EZTalkback.this.talkBackSuccessCallback != null) {
                            EZTalkback.this.talkBackSuccessCallback.talkBackSuccess();
                        }
                        EZTalkback.this.handlePlaySuccess();
                    } else {
                        EZTalkback.this.handlePlayerFailed(i);
                    }
                    return false;
                }

                public void onNeedToken(EZVoiceTalk ezVoiceTalk) {
                    LogUtil.d(EZTalkback.TAG, "streamsdk. start talkback. onNeedToken");
                    try {
                        if (EZTalkback.this.resetTokens()) {
                            EZTalkback.this.start();
                        }
                    }
                    catch (BaseException e) {
                        ErrorInfo errorInfo1 = e.getErrorInfo();
                        EZTalkback.this.sendMessage(114, e.getErrorCode(), errorInfo1);
                        LogUtil.printErrStackTrace(EZTalkback.TAG, e.fillInStackTrace());
                    }
                }

                public void onNetStatus(String s) {
                    LogUtil.d(EZTalkback.TAG, "onNetStatus: " + s);
                }
            });
        }
        catch (BaseException e) {
            LogUtil.printErrStackTrace(TAG, e.fillInStackTrace());
        }
    }

    public void release() {
        if (this.mEZVoiceTalk != null) {
            this.mEZVoiceTalk.release();
        }
    }

    public boolean start() {
        boolean isDeviceTalkBack = this.mEZStreamParamHelp.isDeviceTalkBack();
        DeviceInfoEx deviceInfoEx = this.mEZStreamParamHelp.getDeviceInfo();
        int supportChannelTalk = deviceInfoEx != null ? deviceInfoEx.getSupportChannelTalk() : 0;
        Log.d((String)"aaaa", (String)(supportChannelTalk + "bbbbbbbbbbbbb"));
        if (!isDeviceTalkBack && supportChannelTalk == 0) {
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.errorCode = 510000;
            Message message = Message.obtain();
            message.what = 114;
            message.arg1 = errorInfo.errorCode;
            message.obj = errorInfo;
            this.mHandler.sendMessage(message);
            return false;
        }
        boolean bFullDuplex = true;
        if (isDeviceTalkBack) {
            int nSupport = this.mEZStreamParamHelp.supportTalkType();
            if (nSupport == 3) {
                bFullDuplex = false;
            } else if (nSupport != 1) {
                this.handlePlayerFailed(400025);
                return false;
            }
        }
        AudioManager audiomanage = (AudioManager)PlayAPI.mApplication.getSystemService("audio");
        EZVoiceTalk.EZAudioParam audioParam = new EZVoiceTalk.EZAudioParam();
        audioParam.systemAEC = this.mEZStreamParamHelp.useSystemAEC;
        audioParam.captureOnly = this.mEZStreamParamHelp.deviceInfo.getDevProtoEnum() == 6;
        this.mEZVoiceTalk.startVoiceTalk(audiomanage, bFullDuplex, audioParam);
        LogUtil.i(TAG, "streamsdk. start talkback. " + (bFullDuplex ? "FullDuplex" : "HalfDuplex"));
        return true;
    }

    public void stop() {
        if (this.mEZVoiceTalk == null) {
            return;
        }
        this.mEZVoiceTalk.stopVoiceTalk();
        this.handleStopSuccess();
    }

    public void openVoiceTalkMicrophone() {
        this.mEZVoiceTalk.openVoiceTalkMicrophone();
    }

    public void closeVoiceTalkMicrophone() {
        this.mEZVoiceTalk.closeVoiceTalkMicrophone();
    }

    protected void sendMessage(int msg, int arg1, Object obj) {
        if (this.mHandler != null) {
            Message message = Message.obtain();
            message.what = msg;
            message.arg1 = arg1;
            message.obj = obj;
            this.mHandler.sendMessage(message);
        }
    }

    public void setTalkbackStatus(boolean bPressed) {
        if (this.mEZVoiceTalk == null) {
            return;
        }
        LogUtil.d(TAG, "Half duplex. Pressed? " + bPressed);
        this.mEZVoiceTalk.updateVoiceTalkButtonPressStatus(bPressed);
    }

    public void setSpeakerphoneOn(boolean on) {
        if (this.mEZVoiceTalk != null) {
            this.mEZVoiceTalk.setSpeakerphoneOn(on);
        }
    }

    public boolean isSpeakerphoneOn() {
        boolean isSpeakerphoneOn = true;
        if (this.mEZVoiceTalk != null) {
            isSpeakerphoneOn = this.mEZVoiceTalk.isSpeakerphoneOn();
        }
        return isSpeakerphoneOn;
    }

    protected void handlePlayerFailed(int errorcode) {
        LogUtil.d(TAG, "streamsdk. start talkback. handlePlayerFailed errorcode =" + errorcode);
        ErrorInfo errorInfo = null;
        switch (errorcode) {
            case 7: 
            case 8: {
                EZStreamClientManager.create((Context)PlayAPI.mApplication).clearTokens();
                try {
                    this.resetTokens();
                    this.start();
                    return;
                }
                catch (BaseException e) {
                    ErrorInfo errorInfo1 = e.getErrorInfo();
                    this.sendMessage(114, e.getErrorCode(), errorInfo1);
                    LogUtil.printErrStackTrace(TAG, e.fillInStackTrace());
                }
            }
            case 400025: {
                errorInfo = ErrorLayer.getErrorLayer(2, errorcode);
                this.sendMessage(114, errorInfo.errorCode, errorInfo);
                break;
            }
            default: {
                errorInfo = ErrorLayer.getErrorLayer(31, errorcode);
                this.sendMessage(114, errorInfo.errorCode, errorInfo);
            }
        }
    }

    protected void handlePlaySuccess() {
        LogUtil.d(TAG, "streamsdk. start talkback. handlePlaySuccess");
        this.sendMessage(113, 0, null);
    }

    protected void handlePlayFinished() {
        LogUtil.d(TAG, "streamsdk. start talkback. handlePlayFinished");
        this.sendMessage(133, 0, null);
    }

    protected void handleStopSuccess() {
        LogUtil.d(TAG, "streamsdk. start talkback. handleStopSuccess");
        this.sendMessage(115, 0, null);
    }

    private boolean resetTokens() throws BaseException {
        List<String> tokenList = DeviceManager.getInstance().getStreamToken(true);
        if (tokenList != null && tokenList.size() > 0) {
            EZStreamClientManager.create((Context)PlayAPI.mApplication.getApplicationContext()).setTokens(tokenList.toArray(new String[tokenList.size()]));
            return true;
        }
        return false;
    }

    public static interface TalkBackSuccessCallback {
        public void talkBackSuccess();
    }
}

