/*
 * Decompiled with CFR 0.152.
 */
package com.mediaplayer.audio;

import com.mediaplayer.audio.AudioCodecParam;
import com.mediaplayer.audio.AudioEngineParam;

class AudioCodec {
    public static final int G711_ENC_SIZE = 160;
    public static final int G711_DEC_SIZE = 320;
    public static final int G722_ENC_SIZE = 80;
    public static final int G722_DEC_SIZE = 1280;
    public static final int G723_ENC_SIZE = 40;
    public static final int G723_DEC_SIZE = 480;
    public static final int G726_ENC_SIZE = 80;
    public static final int G726_DEC_SIZE = 640;
    public static final int G729_ENC_SIZE = 10;
    public static final int G729_DEC_SIZE = 160;
    public static final int AAC_ENC_SIZE = 640;
    public static final int AAC_DEC_SIZE = 320;
    public static final int MPEG2_ENC_SIZE = 144;
    public static final int MPEG2_DEC_SIZE = 4608;
    public static final int OPUS_ENC_SIZE = 2048;
    public static final int OPUS_DEC_SIZE = 2048;
    public static final int AACLD_ENC_SIZE = 2048;
    public static final int AACLD_DEC_SIZE = 2048;
    private int mPort = this.GetPort();
    private static final String TAG = "AudioCodec";

    public int release() {
        return this.FreePort(this.mPort);
    }

    public int openAudioDecoder(int nType) {
        return this.OpenAudioDecoder(this.mPort, nType);
    }

    public int decodeAudioData(byte[] decInBuffer, int nDecInBufferSize, byte[] decOutBuffer) {
        return this.DecodeAudioData(this.mPort, decInBuffer, nDecInBufferSize, decOutBuffer);
    }

    public int openAudioEncoder(int nType) {
        return this.OpenAudioEncoder(this.mPort, nType);
    }

    public int encodeAudioData(byte[] encOutBuffer) {
        return this.EncodeAudioData(this.mPort, encOutBuffer);
    }

    public int setAudioParam(AudioCodecParam param) {
        return this.SetAudioParam(this.mPort, param);
    }

    public int setVolume(int nVolume) {
        return this.SetVolume(this.mPort, nVolume);
    }

    public int openAGC(int nMode, int nLevel) {
        return this.OpenAGC(this.mPort, nMode, nLevel);
    }

    public int setFastDenoiseMode(boolean bIsFastDenoise) {
        return this.FastDenoiseMode(this.mPort, bIsFastDenoise);
    }

    public int setWriteFile(boolean bIsWrite) {
        return this.SetWriteFile(this.mPort, bIsWrite);
    }

    public int getEncUsedPCMLen() {
        return this.GetEncUsedPCMLen(this.mPort);
    }

    public int openPitchShifer(boolean bPitchShiferEnable, int nPitchShiferLevel, int nCAEMode) {
        return this.OpenPitchShifer(this.mPort, bPitchShiferEnable, nPitchShiferLevel, nCAEMode);
    }

    public int setAECType(int nAECType) {
        return this.SetAECType(this.mPort, nAECType);
    }

    public int preAudioData(byte[] audioBuffer, int readBytes) {
        return this.PreAudioData(this.mPort, audioBuffer, readBytes);
    }

    public int setAecParam(AudioEngineParam audioEngineParam) {
        return this.SetAecParam(this.mPort, audioEngineParam);
    }

    public AudioEngineParam getAecParam() {
        return this.GetAecParam(this.mPort);
    }

    public int setAecConfig(int nAECSwitch, int nAECLevel, int nANRSwitch, int nANRLevel, int nRefLen) {
        return this.SetAecConfig(this.mPort, nAECSwitch, nAECLevel, nANRSwitch, nANRLevel, nRefLen);
    }

    public int getAecConfig(int nType) {
        return this.GetAecConfig(this.mPort, nType);
    }

    public int setWriteFileEx(boolean bIsWrite, String sAddr) {
        return this.SetWriteFileEx(this.mPort, bIsWrite, sAddr);
    }

    private native int GetPort();

    private native int FreePort(int var1);

    private native int OpenAudioDecoder(int var1, int var2);

    private native int DecodeAudioData(int var1, byte[] var2, int var3, byte[] var4);

    private native int OpenAudioEncoder(int var1, int var2);

    private native int EncodeAudioData(int var1, byte[] var2);

    private native int SetAudioParam(int var1, AudioCodecParam var2);

    private native int SetVolume(int var1, int var2);

    private native int OpenAGC(int var1, int var2, int var3);

    private native int FastDenoiseMode(int var1, boolean var2);

    private native int SetWriteFile(int var1, boolean var2);

    private native int GetEncUsedPCMLen(int var1);

    private native int OpenPitchShifer(int var1, boolean var2, int var3, int var4);

    private native int SetAECType(int var1, int var2);

    private native int PreAudioData(int var1, byte[] var2, int var3);

    private native int SetAecParam(int var1, AudioEngineParam var2);

    private native AudioEngineParam GetAecParam(int var1);

    private native int SetAecConfig(int var1, int var2, int var3, int var4, int var5, int var6);

    private native int GetAecConfig(int var1, int var2);

    private native int SetWriteFileEx(int var1, boolean var2, String var3);

    static {
        System.loadLibrary("EZAudioSDK");
    }

    public static class AudioParamDown {
        public int nCodecType;
        public int nBitWidth;
        public int nSampleRate;
        public int nChannel;
        public int nBitRate;
        public int nVolume;
    }
}

