/*
 * Decompiled with CFR 0.152.
 */
package com.mediaplayer.audio;

import android.util.Log;
import com.mediaplayer.audio.AudioBaseCallBack;
import com.mediaplayer.audio.AudioCodec;
import com.mediaplayer.audio.AudioCodecParam;
import com.mediaplayer.audio.AudioEngineCallBack;
import com.mediaplayer.audio.AudioEngineParam;
import com.mediaplayer.audio.AudioPlayer;
import com.mediaplayer.audio.AudioRecoder;

public class AudioEngine {
    public static final int CAE_PLAY = 1;
    public static final int CAE_RECORDE = 2;
    public static final int CAE_INTERCOM = 3;
    public static final int PARAM_MODE_RECORDE = 1;
    public static final int PARAM_MODE_PLAY = 2;
    public static final int PLAY_DATA_CALLBACK = 1;
    public static final int RECORDE_DATA_CALLBACK = 2;
    public static final int CAPTURE_DATA_CALLBACK = 3;
    public static final int ERROR_INFO_CALLBACK = 4;
    public static final int AECTYPE_SYSTEM = 1;
    public static final int AECTYPE_HIK = 2;
    private boolean isOpened = false;
    private boolean isParamSet = false;
    private boolean isParamCorrect = false;
    private int mMode = 0;
    private int mPlayCodecType = 1;
    private int mPlayBitWidth = 2;
    private int mPlaySampleRate = 8000;
    private int mPlayBitRate = 64000;
    private int mPlayChannel = 1;
    private float mPlayVolume = 0.5f;
    private int mRecordCodecType = 1;
    private int mRecordBitWidth = 2;
    private int mRecordSampleRate = 8000;
    private int mRecordBitRate = 64000;
    private int mRecordChannel = 1;
    private AudioRecoder mAudioRecoder = null;
    private AudioPlayer mAudioPlayer = null;
    private AudioCodec mAudioCodec = null;
    private String TAG = "AudioEngine";

    public AudioEngine(int nMode) {
        if (nMode != 1 && nMode != 2 && nMode != 3) {
            return;
        }
        this.mMode = nMode;
    }

    public int open() {
        if (this.mMode != 1 && this.mMode != 2 && this.mMode != 3) {
            return -2147483645;
        }
        if (this.isOpened) {
            return -2147483644;
        }
        this.mAudioCodec = new AudioCodec();
        switch (this.mMode) {
            case 1: {
                this.mAudioPlayer = new AudioPlayer(this.mAudioCodec);
                break;
            }
            case 2: {
                this.mAudioRecoder = new AudioRecoder(this.mAudioCodec);
                break;
            }
            case 3: {
                this.mAudioPlayer = new AudioPlayer(this.mAudioCodec);
                this.mAudioRecoder = new AudioRecoder(this.mAudioCodec);
                break;
            }
            default: {
                if (this.mAudioCodec != null) {
                    this.mAudioCodec.release();
                    this.mAudioCodec = null;
                }
                return -2147483642;
            }
        }
        this.isOpened = true;
        return 0;
    }

    public int close() {
        if (!this.isOpened) {
            return -2147483644;
        }
        int nRet = 0;
        if (this.mAudioPlayer != null) {
            nRet = this.mAudioPlayer.closePlay();
            this.mAudioPlayer = null;
        }
        if (this.mAudioRecoder != null) {
            nRet = this.mAudioRecoder.closeRecord();
            this.mAudioRecoder = null;
        }
        if (this.mAudioCodec != null) {
            nRet = this.mAudioCodec.release();
            this.mAudioCodec = null;
        }
        this.isParamCorrect = false;
        this.isParamSet = false;
        this.isOpened = false;
        return nRet;
    }

    public int startPlay() {
        if (!this.isOpened || null == this.mAudioPlayer || !this.isParamCorrect) {
            return -2147483644;
        }
        if (this.mMode != 1 && this.mMode != 3) {
            return -2147483647;
        }
        return this.mAudioPlayer.startPlay(this.mPlayCodecType);
    }

    public int stopPlay() {
        if (!this.isOpened || null == this.mAudioPlayer) {
            return -2147483644;
        }
        if (this.mMode != 1 && this.mMode != 3) {
            return -2147483647;
        }
        return this.mAudioPlayer.stopPlay();
    }

    public int inputData(byte[] audioData, int len) {
        if (!this.isOpened || null == this.mAudioPlayer) {
            return -2147483644;
        }
        if (this.mMode != 1 && this.mMode != 3) {
            return -2147483647;
        }
        return this.mAudioPlayer.inputData(audioData, len);
    }

    public int startRecord() {
        if (!this.isOpened || null == this.mAudioRecoder || !this.isParamCorrect) {
            return -2147483644;
        }
        if (this.mMode != 2 && this.mMode != 3) {
            return -2147483647;
        }
        if (!this.isParamCorrect) {
            return -2147483646;
        }
        return this.mAudioRecoder.startRecord(this.mRecordCodecType);
    }

    public int stopRecord() {
        if (!this.isOpened || null == this.mAudioRecoder) {
            return -2147483644;
        }
        if (this.mMode != 2 && this.mMode != 3) {
            return -2147483647;
        }
        return this.mAudioRecoder.stopRecord();
    }

    private boolean checkParam(AudioCodecParam audioCodecParam) {
        block95: {
            block112: {
                block109: {
                    block111: {
                        block110: {
                            block106: {
                                block108: {
                                    block107: {
                                        block101: {
                                            block105: {
                                                block104: {
                                                    block103: {
                                                        block102: {
                                                            block100: {
                                                                block99: {
                                                                    block98: {
                                                                        block97: {
                                                                            block96: {
                                                                                block94: {
                                                                                    if (audioCodecParam == null) {
                                                                                        return false;
                                                                                    }
                                                                                    if (audioCodecParam.nCodecType < 0 || audioCodecParam.nCodecType > 10) {
                                                                                        return false;
                                                                                    }
                                                                                    if (audioCodecParam.nVolume < 0 || audioCodecParam.nVolume > 100) {
                                                                                        return false;
                                                                                    }
                                                                                    if (audioCodecParam.nChannel != 1) {
                                                                                        return false;
                                                                                    }
                                                                                    if (audioCodecParam.nBitWidth != 2 && audioCodecParam.nBitWidth != 3) {
                                                                                        return false;
                                                                                    }
                                                                                    if (audioCodecParam.nSampleRate < 4000 || audioCodecParam.nSampleRate > 48000) {
                                                                                        return false;
                                                                                    }
                                                                                    if (audioCodecParam.nCodecType != 0) break block94;
                                                                                    if (audioCodecParam.nSampleRate != 8000 && audioCodecParam.nSampleRate != 16000 && audioCodecParam.nSampleRate != 32000 && audioCodecParam.nSampleRate != 48000) {
                                                                                        return false;
                                                                                    }
                                                                                    break block95;
                                                                                }
                                                                                if (audioCodecParam.nCodecType != 1 && audioCodecParam.nCodecType != 2) break block96;
                                                                                if (audioCodecParam.nSampleRate != 8000) {
                                                                                    return false;
                                                                                }
                                                                                if (audioCodecParam.nBitRate != 16000 && audioCodecParam.nBitRate != 64000) {
                                                                                    return false;
                                                                                }
                                                                                break block95;
                                                                            }
                                                                            if (audioCodecParam.nCodecType != 3) break block97;
                                                                            if (audioCodecParam.nSampleRate != 16000) {
                                                                                return false;
                                                                            }
                                                                            if (audioCodecParam.nBitRate != 16000) {
                                                                                return false;
                                                                            }
                                                                            break block95;
                                                                        }
                                                                        if (audioCodecParam.nCodecType != 7) break block98;
                                                                        if (audioCodecParam.nSampleRate != 8000) {
                                                                            return false;
                                                                        }
                                                                        if (audioCodecParam.nBitRate != 5300 && audioCodecParam.nBitRate != 6300) {
                                                                            return false;
                                                                        }
                                                                        break block95;
                                                                    }
                                                                    if (audioCodecParam.nCodecType != 4) break block99;
                                                                    if (audioCodecParam.nSampleRate != 8000) {
                                                                        return false;
                                                                    }
                                                                    if (audioCodecParam.nBitRate != 16000) {
                                                                        return false;
                                                                    }
                                                                    break block95;
                                                                }
                                                                if (audioCodecParam.nCodecType != 8) break block100;
                                                                if (audioCodecParam.nSampleRate != 8000) {
                                                                    return false;
                                                                }
                                                                if (audioCodecParam.nBitRate != 8000) {
                                                                    return false;
                                                                }
                                                                break block95;
                                                            }
                                                            if (audioCodecParam.nCodecType != 6) break block101;
                                                            if (audioCodecParam.nSampleRate != 8000) break block102;
                                                            switch (audioCodecParam.nBitRate) {
                                                                case 8000: {
                                                                    break block95;
                                                                }
                                                                case 16000: {
                                                                    break block95;
                                                                }
                                                                case 32000: {
                                                                    break block95;
                                                                }
                                                                default: {
                                                                    return false;
                                                                }
                                                            }
                                                        }
                                                        if (audioCodecParam.nSampleRate != 16000) break block103;
                                                        switch (audioCodecParam.nBitRate) {
                                                            case 8000: {
                                                                break block95;
                                                            }
                                                            case 16000: {
                                                                break block95;
                                                            }
                                                            case 32000: {
                                                                break block95;
                                                            }
                                                            case 64000: {
                                                                break block95;
                                                            }
                                                            default: {
                                                                return false;
                                                            }
                                                        }
                                                    }
                                                    if (audioCodecParam.nSampleRate != 32000) break block104;
                                                    switch (audioCodecParam.nBitRate) {
                                                        case 8000: {
                                                            break block95;
                                                        }
                                                        case 16000: {
                                                            break block95;
                                                        }
                                                        case 32000: {
                                                            break block95;
                                                        }
                                                        case 64000: {
                                                            break block95;
                                                        }
                                                        case 128000: {
                                                            break block95;
                                                        }
                                                        default: {
                                                            return false;
                                                        }
                                                    }
                                                }
                                                if (audioCodecParam.nSampleRate != 48000 && audioCodecParam.nSampleRate != 44100) break block105;
                                                switch (audioCodecParam.nBitRate) {
                                                    case 16000: {
                                                        break block95;
                                                    }
                                                    case 32000: {
                                                        break block95;
                                                    }
                                                    case 64000: {
                                                        break block95;
                                                    }
                                                    case 128000: {
                                                        break block95;
                                                    }
                                                    default: {
                                                        return false;
                                                    }
                                                }
                                            }
                                            return false;
                                        }
                                        if (audioCodecParam.nCodecType != 5) break block106;
                                        if (audioCodecParam.nSampleRate != 16000) break block107;
                                        switch (audioCodecParam.nBitRate) {
                                            case 8000: {
                                                break block95;
                                            }
                                            case 16000: {
                                                break block95;
                                            }
                                            case 24000: {
                                                break block95;
                                            }
                                            case 32000: {
                                                break block95;
                                            }
                                            case 40000: {
                                                break block95;
                                            }
                                            case 48000: {
                                                break block95;
                                            }
                                            case 56000: {
                                                break block95;
                                            }
                                            case 64000: {
                                                break block95;
                                            }
                                            case 80000: {
                                                break block95;
                                            }
                                            case 96000: {
                                                break block95;
                                            }
                                            case 112000: {
                                                break block95;
                                            }
                                            case 128000: {
                                                break block95;
                                            }
                                            case 144000: {
                                                break block95;
                                            }
                                            case 160000: {
                                                break block95;
                                            }
                                            default: {
                                                return false;
                                            }
                                        }
                                    }
                                    if (audioCodecParam.nSampleRate != 32000 && audioCodecParam.nSampleRate != 44100 && audioCodecParam.nSampleRate != 48000) break block108;
                                    switch (audioCodecParam.nBitRate) {
                                        case 32000: {
                                            break block95;
                                        }
                                        case 48000: {
                                            break block95;
                                        }
                                        case 56000: {
                                            break block95;
                                        }
                                        case 64000: {
                                            break block95;
                                        }
                                        case 80000: {
                                            break block95;
                                        }
                                        case 96000: {
                                            break block95;
                                        }
                                        case 112000: {
                                            break block95;
                                        }
                                        case 128000: {
                                            break block95;
                                        }
                                        case 160000: {
                                            break block95;
                                        }
                                        case 192000: {
                                            break block95;
                                        }
                                        default: {
                                            return false;
                                        }
                                    }
                                }
                                return false;
                            }
                            if (audioCodecParam.nCodecType != 9) break block109;
                            if (audioCodecParam.nSampleRate != 8000 && audioCodecParam.nSampleRate != 16000) break block110;
                            switch (audioCodecParam.nBitRate) {
                                case 6000: {
                                    break block95;
                                }
                                case 8000: {
                                    break block95;
                                }
                                case 16000: {
                                    break block95;
                                }
                                case 32000: {
                                    break block95;
                                }
                                case 64000: {
                                    break block95;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        if (audioCodecParam.nSampleRate != 48000) break block111;
                        switch (audioCodecParam.nBitRate) {
                            case 16000: {
                                break block95;
                            }
                            case 32000: {
                                break block95;
                            }
                            case 64000: {
                                break block95;
                            }
                            case 128000: {
                                break block95;
                            }
                            case 160000: {
                                break block95;
                            }
                            case 192000: {
                                break block95;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    return false;
                }
                if (audioCodecParam.nCodecType != 10) break block95;
                if (audioCodecParam.nSampleRate != 8000 && audioCodecParam.nSampleRate != 16000 && audioCodecParam.nSampleRate != 32000 && audioCodecParam.nSampleRate != 44100 && audioCodecParam.nSampleRate != 48000) break block112;
                switch (audioCodecParam.nBitRate) {
                    case 16000: {
                        break block95;
                    }
                    case 32000: {
                        break block95;
                    }
                    case 48000: {
                        break block95;
                    }
                    case 64000: {
                        break block95;
                    }
                    case 128000: {
                        break block95;
                    }
                    case 160000: {
                        break block95;
                    }
                    case 192000: {
                        break block95;
                    }
                    case 256000: {
                        break block95;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public int setAudioParam(AudioCodecParam audioCodecParam, int nType) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (nType == 2 && this.mMode == 2) {
            return -2147483644;
        }
        if (nType == 1 && this.mMode == 1) {
            return -2147483644;
        }
        if (!this.checkParam(audioCodecParam)) {
            Log.e((String)"AudioEngine", (String)"audio param error");
            return -2147483645;
        }
        this.isParamCorrect = true;
        if (nType == 2) {
            this.mPlayCodecType = audioCodecParam.nCodecType;
            if (audioCodecParam.nSampleRate != 0) {
                this.mPlaySampleRate = audioCodecParam.nSampleRate;
            }
            if (audioCodecParam.nBitRate != 0) {
                this.mPlayBitRate = audioCodecParam.nBitRate;
            }
            if (audioCodecParam.nChannel != 0) {
                this.mPlayChannel = audioCodecParam.nChannel;
            }
            if (audioCodecParam.nBitWidth != 0) {
                this.mPlayBitWidth = audioCodecParam.nBitWidth;
            }
            if (audioCodecParam.nVolume != 0) {
                this.mPlayVolume = 1.0f * (float)audioCodecParam.nVolume / 100.0f;
            }
        } else if (nType == 1) {
            this.mRecordCodecType = audioCodecParam.nCodecType;
            if (audioCodecParam.nSampleRate != 0) {
                this.mRecordSampleRate = audioCodecParam.nSampleRate;
            }
            if (audioCodecParam.nBitRate != 0) {
                this.mRecordBitRate = audioCodecParam.nBitRate;
            }
            if (audioCodecParam.nChannel != 0) {
                this.mRecordChannel = audioCodecParam.nChannel;
            }
            if (audioCodecParam.nBitWidth != 0) {
                this.mRecordBitWidth = audioCodecParam.nBitWidth;
            }
        } else {
            return -2147483645;
        }
        if (!this.isParamSet) {
            if (this.mAudioRecoder != null) {
                this.mAudioRecoder.setAudioPlayParam(audioCodecParam);
            }
            if (this.mAudioPlayer != null) {
                this.mAudioPlayer.setAudioPlayParam(audioCodecParam);
            }
            this.mAudioCodec.setAudioParam(audioCodecParam);
            this.isParamSet = true;
        }
        return 0;
    }

    public int getAudioParam(AudioCodecParam audioCodecParam, int nType) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (audioCodecParam == null) {
            return -2147483645;
        }
        if (nType == 2 && this.mMode == 2) {
            return -2147483644;
        }
        if (nType == 1 && this.mMode == 1) {
            return -2147483644;
        }
        if (nType == 2) {
            audioCodecParam.nCodecType = this.mPlayCodecType;
            audioCodecParam.nBitRate = this.mPlayBitRate;
            audioCodecParam.nBitWidth = this.mPlayBitWidth;
            audioCodecParam.nChannel = this.mPlayChannel;
            audioCodecParam.nSampleRate = this.mPlaySampleRate;
            audioCodecParam.nVolume = (int)(100.0f * this.mPlayVolume);
        } else if (nType == 1) {
            audioCodecParam.nCodecType = this.mRecordCodecType;
            audioCodecParam.nBitRate = this.mRecordBitRate;
            audioCodecParam.nBitWidth = this.mRecordBitWidth;
            audioCodecParam.nChannel = this.mRecordChannel;
            audioCodecParam.nSampleRate = this.mRecordSampleRate;
        } else {
            return -2147483645;
        }
        return 0;
    }

    public int setAudioCallBack(AudioBaseCallBack dataCbf, int nType) {
        if (!this.isOpened) {
            return -2147483646;
        }
        if (nType == 1 && this.mMode == 2) {
            return -2147483644;
        }
        if (this.mMode == 1 && (nType == 2 || nType == 3)) {
            return -2147483644;
        }
        switch (nType) {
            case 2: {
                this.mAudioRecoder.setAudioDataCallBack((AudioEngineCallBack.RecordDataCallBack)dataCbf);
                break;
            }
            case 3: {
                this.mAudioRecoder.setAudioDataCallBack((AudioEngineCallBack.CaptureDataCallBack)dataCbf);
                break;
            }
            case 1: {
                this.mAudioPlayer.setAudioDataCallBack((AudioEngineCallBack.PlayDataCallBack)dataCbf);
                break;
            }
            case 4: {
                if (this.mAudioPlayer != null) {
                    this.mAudioPlayer.setErrorInfoCallBack((AudioEngineCallBack.ErrorInfoCallBack)dataCbf);
                }
                if (this.mAudioRecoder == null) break;
                break;
            }
            default: {
                return -2147483645;
            }
        }
        return 0;
    }

    public int setVolume(int nVolume) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.setVolume(nVolume);
    }

    public int openAGC(int nMode, int nLevel) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.openAGC(nMode, nLevel);
    }

    public int setFastDenoiseMode(boolean bIsFastDenoise) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.setFastDenoiseMode(bIsFastDenoise);
    }

    public int openPitchShifer(boolean bPitchShiferEnable, int nPitchShiferLevel, int nCAEMode) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.openPitchShifer(bPitchShiferEnable, nPitchShiferLevel, nCAEMode);
    }

    public int setPlayBuffSize(int nPlayBuffType, int nBuffSize) {
        if (!this.isOpened) {
            return -2147483644;
        }
        return this.mAudioPlayer.setPlayBuffSize(nPlayBuffType, nBuffSize);
    }

    public int setWriteFile(boolean bIsWrite) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        int nRet = this.mAudioCodec.setWriteFile(bIsWrite);
        if (this.mAudioRecoder != null) {
            this.mAudioRecoder.setWriteFile(bIsWrite);
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.setWriteFile(bIsWrite);
        }
        return nRet;
    }

    public int setIntercomType() {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        switch (this.mMode) {
            case 1: {
                this.mAudioPlayer.setPlayIntercomType(false);
                break;
            }
            case 2: {
                this.mAudioRecoder.setRecordIntercomType(false);
                break;
            }
            case 3: {
                this.mAudioPlayer.setPlayIntercomType(false);
                this.mAudioRecoder.setRecordIntercomType(false);
                break;
            }
            default: {
                return -2147483642;
            }
        }
        return 0;
    }

    public int getEncUsedPCMLen() {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.getEncUsedPCMLen();
    }

    public int setAECType(int nAECType) {
        if (nAECType != 1 && nAECType != 2) {
            return -2147483645;
        }
        if (!this.isOpened) {
            return -2147483644;
        }
        int nRet = 0;
        if (this.mAudioPlayer != null && (nRet = this.mAudioPlayer.setAECType(nAECType)) != 0) {
            return nRet;
        }
        if (this.mAudioRecoder != null && (nRet = this.mAudioRecoder.setAECType(nAECType)) != 0) {
            return nRet;
        }
        if (this.mAudioCodec != null) {
            this.mAudioCodec.setAECType(nAECType);
            if (nRet != 0) {
                return nRet;
            }
        }
        return 0;
    }

    public int setAecParam(AudioEngineParam audioEngineParam) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.setAecParam(audioEngineParam);
    }

    public int getAecParam(AudioEngineParam audioEngineParam) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        AudioEngineParam param = this.mAudioCodec.getAecParam();
        audioEngineParam.D_LFREQ = param.D_LFREQ;
        audioEngineParam.D_HFREQ = param.D_HFREQ;
        audioEngineParam.P_LFREQ = param.P_LFREQ;
        audioEngineParam.P_HFREQ = param.P_HFREQ;
        audioEngineParam.S_LFREQ = param.S_LFREQ;
        audioEngineParam.S_HFREQ = param.S_HFREQ;
        return 0;
    }

    public int setAecConfig(int nAECSwitch, int nAECLevel, int nANRSwitch, int nANRLevel, int nRefLen) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.setAecConfig(nAECSwitch, nAECLevel, nANRSwitch, nANRLevel, nRefLen);
    }

    public int getAecConfig(int nType) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        return this.mAudioCodec.getAecConfig(nType);
    }

    public int getAECSessionID() {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioRecoder != null) {
            AudioEngine audioEngine = this;
            return audioEngine.mAudioRecoder.getSessionID();
        }
        return -2147483644;
    }

    public int setWriteFileEx(boolean bIsWrite, String sAddr) {
        if (!this.isOpened) {
            return -2147483644;
        }
        if (this.mAudioCodec == null) {
            return -2147483644;
        }
        if (null == sAddr) {
            return -2147483645;
        }
        if (this.mAudioRecoder != null) {
            this.mAudioRecoder.setWriteFileEx(bIsWrite, sAddr);
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.setWriteFileEx(bIsWrite, sAddr);
        }
        return this.mAudioCodec.setWriteFileEx(bIsWrite, sAddr);
    }

    public int inputRecordData(byte[] recordData, int nDataLen) {
        if (!this.isOpened || null == this.mAudioRecoder) {
            return -2147483644;
        }
        if (this.mMode != 2 && this.mMode != 3) {
            return -2147483647;
        }
        if (!this.isParamCorrect) {
            return -2147483644;
        }
        return this.mAudioRecoder.inputRecordData(recordData, nDataLen);
    }

    public int getVersion() {
        return 50398213;
    }
}

