/*
 * Decompiled with CFR 0.152.
 */
package com.hik.streamclient;

import android.text.TextUtils;
import com.hik.streamclient.CLN_STREAM_INFO_S;
import com.hik.streamclient.StreamClientCallback;

public class StreamClient {
    public static final int STREAM_CLN_INVALID_HANDLE = 0;
    public static final int CLIENT_STREAM_SVR_ADDR_LEN = 127;
    public static final int CLIENT_STREAM_SVR_INFO_LEN = 36;
    public static final int CLIENT_STREAM_EXTENSION_LEN = 128;
    private static StreamClient mStreamClient = null;
    private static String mLoadLibraryAbsPath = null;

    public static void setLoadLibraryAbsPath(String absPath) {
        mLoadLibraryAbsPath = absPath;
    }

    private StreamClient() {
        if (TextUtils.isEmpty((CharSequence)mLoadLibraryAbsPath)) {
            try {
                System.loadLibrary("gnustl_shared");
                System.loadLibrary("hpr");
                System.loadLibrary("protobuf-lite");
                System.loadLibrary("StreamClientSDK");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        } else {
            try {
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libgnustl_shared.so");
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libhpr.so");
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libprotobuf-lite.so");
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libStreamClientSDK.so");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static StreamClient getInstance() {
        if (mStreamClient == null) {
            mStreamClient = new StreamClient();
        }
        return mStreamClient;
    }

    public native boolean initCrashReport();

    public native boolean setLogPrint(boolean var1);

    public native long creatStreamClient(StreamClientCallback var1);

    public native void deleteStreamClient(long var1);

    public native int startStreamProces(long var1, CLN_STREAM_INFO_S var3);

    public native int stopStreamProcess(long var1, int var3);

    public native String queryRealStreamSrvInfo(long var1, int var3, int var4);

    public native int queryStreamClnCountTime(long var1, int var3, long[] var4);
}

