/*
 * Decompiled with CFR 0.152.
 */
package com.ez.downloader;

import android.os.Handler;
import com.ez.player.EZMediaCallback;
import com.ez.player.EZMediaPlayer;
import com.ez.stream.EZStreamClientManager;
import com.ez.stream.EZTaskMgr;
import com.ez.stream.InitParam;
import com.ez.stream.LogUtil;
import com.ez.stream.NativeApi;

public class EZDownloader
implements EZMediaCallback {
    private static final String TAG = "EZDownloader";
    private Handler mHandler;
    private InitParam mInitParam;
    private String dstFilePath;
    private OnMsgCallBack onMsgCallBack;
    private long mhMedia;
    private Runnable timeOutRunnable;

    public EZDownloader(EZStreamClientManager ezStreamClientManager, InitParam initParam, String dstFilePath) {
        EZTaskMgr mEZTaskMgr = ezStreamClientManager.getTaskMgr();
        this.mHandler = new Handler(mEZTaskMgr.getLooper());
        this.mInitParam = initParam;
        this.dstFilePath = dstFilePath;
        this.initParams();
    }

    private void initParams() {
        if (this.mhMedia != 0L) {
            NativeApi.destroyDownloader(this.mhMedia);
            this.mhMedia = 0L;
        }
        this.mhMedia = NativeApi.createDownloadClient(this.mInitParam, this.dstFilePath);
    }

    public int startDownload() {
        if (this.mhMedia != 0L) {
            int ret = NativeApi.startDownload(this.mhMedia);
            if (ret == 0) {
                this.startTimer();
            }
            return ret;
        }
        return -1;
    }

    public void stopDownload() {
        if (this.mhMedia != 0L) {
            this.stopTimer();
            this.timeOutRunnable = null;
            NativeApi.stopDownload(this.mhMedia);
        }
    }

    public void destroy() {
        if (this.mhMedia != 0L) {
            NativeApi.destroyDownloader(this.mhMedia);
            this.mhMedia = 0L;
        }
    }

    public void setMsgCallback(OnMsgCallBack callback) {
        if (this.mhMedia != 0L) {
            this.onMsgCallBack = callback;
            NativeApi.setDownloadCallback(this.mhMedia, this);
        }
    }

    @Override
    public void onErrorListener(final int errorType, final int errorCode) {
        LogUtil.d(TAG, "onError " + errorType + ", errorCode " + errorCode);
        this.stopTimer();
        if (this.onMsgCallBack != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    EZDownloader.this.onMsgCallBack.onError(EZMediaPlayer.MediaError.values()[errorType], errorCode);
                }
            });
        }
    }

    @Override
    public void onInfoListener(final int infoType) {
        LogUtil.d(TAG, "onInfo " + infoType);
        if (EZMediaPlayer.MediaInfo.values()[infoType] == EZMediaPlayer.MediaInfo.MEDIA_INFO_PLAYING_FINISH) {
            this.stopTimer();
        }
        if (this.onMsgCallBack != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    EZDownloader.this.onMsgCallBack.onInfo(EZMediaPlayer.MediaInfo.values()[infoType]);
                }
            });
        }
    }

    @Override
    public void onDelayListener(int delayTime) {
    }

    @Override
    public void onDataRefresh(int size) {
        this.stopTimer();
        this.startTimer();
    }

    private void startTimer() {
        if (this.timeOutRunnable == null) {
            this.timeOutRunnable = new Runnable(){

                @Override
                public void run() {
                    if (EZDownloader.this.onMsgCallBack != null) {
                        EZDownloader.this.onMsgCallBack.onError(EZMediaPlayer.MediaError.MEDIA_ERROR_TIMEOUT, 24);
                        LogUtil.d(EZDownloader.TAG, "startTimer onError 24");
                    }
                }
            };
        }
        this.mHandler.postDelayed(this.timeOutRunnable, 10000L);
    }

    private void stopTimer() {
        if (this.timeOutRunnable != null) {
            this.mHandler.removeCallbacks(this.timeOutRunnable);
        }
    }

    public static interface OnMsgCallBack {
        public void onError(EZMediaPlayer.MediaError var1, int var2);

        public void onInfo(EZMediaPlayer.MediaInfo var1);
    }
}

