/*
 * Decompiled with CFR 0.152.
 */
package com.ez.hcnetsdk;

import com.ez.player.BuildConfig;
import com.neutral.netsdk.HCNetSDK;
import com.neutral.netsdk.NET_DVR_DEVICEINFO_V30;

public class EZHCNetSDK {
    static EZHCNetSDK sEZHCNetSDK = null;
    HCNetSDK mHCNetSDK;
    static Object sLock = new Object();

    private EZHCNetSDK(HCNetSDK netSDK) {
        this.mHCNetSDK = netSDK;
    }

    int getResult(int ret) {
        if (ret == 0) {
            return 0;
        }
        return ret + 50000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EZHCNetSDK getInstance() {
        if (!BuildConfig.hcnetsdk.booleanValue()) {
            throw new RuntimeException("don't support HCNetSDK");
        }
        Object object = sLock;
        synchronized (object) {
            if (sEZHCNetSDK == null) {
                try {
                    HCNetSDK netSDK = HCNetSDK.getInstance();
                    if (netSDK == null) {
                        return null;
                    }
                    sEZHCNetSDK = new EZHCNetSDK(netSDK);
                }
                catch (UnsatisfiedLinkError e) {
                    e.printStackTrace();
                }
            }
        }
        return sEZHCNetSDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = sLock;
        synchronized (object) {
            this.mHCNetSDK = null;
        }
    }

    public int lonIn(String devIp, int port, String userName, String passwd, DevInfo info) {
        int userId = -1;
        if (this.mHCNetSDK == null || devIp == null || port < 1 || info == null) {
            return userId;
        }
        int errorCode = 0;
        NET_DVR_DEVICEINFO_V30 devInfo = new NET_DVR_DEVICEINFO_V30();
        userId = this.mHCNetSDK.NET_DVR_Login_V30(devIp, port, userName, passwd, devInfo);
        if (userId == -1) {
            errorCode = this.mHCNetSDK.NET_DVR_GetLastError();
        }
        info.result = this.getResult(errorCode);
        if (errorCode == 0) {
            info.iAlarmInPortNum = devInfo.byAlarmInPortNum;
            info.iAlarmOutPortNum = devInfo.byAlarmOutPortNum;
            info.iDiskNum = devInfo.byDiskNum;
            info.iDVRType = devInfo.byDVRType;
            info.iChanNum = devInfo.byChanNum;
            info.iStartChan = devInfo.byStartChan;
            info.iAudioChanNum = devInfo.byAudioChanNum;
            info.iIPChanNum = devInfo.byIPChanNum;
            info.iZeroChanNum = devInfo.byZeroChanNum;
            info.ievType = devInfo.byDVRType;
            info.iStartDChan = devInfo.byStartDChan;
            info.iStartDTalkChan = devInfo.byStartDTalkChan;
            info.iHighDChanNum = devInfo.byHighDChanNum;
        }
        return userId;
    }

    public boolean logout(int userId) {
        boolean ret = false;
        if (this.mHCNetSDK != null && userId != -1) {
            ret = this.mHCNetSDK.NET_DVR_Logout_V30(userId);
        }
        return ret;
    }

    public HCNetSDK getHCNetSDK() {
        return this.mHCNetSDK;
    }

    public static class DevInfo {
        public int result = 0;
        public int iAlarmInPortNum;
        public int iAlarmOutPortNum;
        public int iDiskNum;
        public int iDVRType;
        public int iChanNum;
        public int iStartChan;
        public int iAudioChanNum;
        public int iIPChanNum;
        public int iZeroChanNum;
        public int ievType;
        public int iStartDChan;
        public int iStartDTalkChan;
        public int iHighDChanNum;
    }
}

