/*
 * Decompiled with CFR 0.152.
 */
package com.ez.p2ptrans;

import android.text.TextUtils;
import com.ez.jna.EZStreamSDKJNA;
import com.ez.p2ptrans.RecordCoverCallback;
import com.ez.stream.LogUtil;
import com.sun.jna.Pointer;

public class RecordCoverFetcher {
    private long mClient;
    private RecordCoverCallback mCallback;
    private EZStreamSDKJNA.RecordCoverErrorCallback mErrorCallback = new EZStreamSDKJNA.RecordCoverErrorCallback(){

        @Override
        public void onError(int errorCode, Pointer pointer) {
            LogUtil.d("RecordCoverFetcher", "onError = " + errorCode);
            if (RecordCoverFetcher.this.mCallback != null) {
                RecordCoverFetcher.this.mCallback.onError(errorCode);
            }
        }
    };
    private EZStreamSDKJNA.RecordCoverRespCallback mRespCallback = new EZStreamSDKJNA.RecordCoverRespCallback(){

        @Override
        public void onResp(EZStreamSDKJNA.EZRecordResp.ByReference rsp, Pointer picData, int picLength) {
            LogUtil.d("RecordCoverFetcher", "onData len = " + picLength);
            if (RecordCoverFetcher.this.mCallback != null) {
                byte[] data = new byte[picLength];
                picData.read(0L, data, 0, picLength);
                RecordCoverFetcher.this.mCallback.onRespData(rsp, data);
            }
        }
    };

    public RecordCoverFetcher(EZStreamSDKJNA.EZP2PTransParamForAndroid.ByReference transParam) {
        if (transParam == null || TextUtils.isEmpty((CharSequence)transParam.relayAddr_) || TextUtils.isEmpty((CharSequence)transParam.serial_) || TextUtils.isEmpty((CharSequence)transParam.token_)) {
            return;
        }
        this.mClient = EZStreamSDKJNA.sEZStreamSDKJNA.createThumbnailFetcher(transParam);
    }

    public void setCallback(RecordCoverCallback callback) {
        this.mCallback = callback;
        if (this.mClient != 0L) {
            EZStreamSDKJNA.sEZStreamSDKJNA.setRecordCoverCallback(this.mClient, this.mErrorCallback, this.mRespCallback);
        }
    }

    public void start() {
        if (this.mClient != 0L) {
            EZStreamSDKJNA.sEZStreamSDKJNA.startRecordCoverTask(this.mClient);
        }
    }

    public void stop() {
        if (this.mClient != 0L) {
            EZStreamSDKJNA.sEZStreamSDKJNA.stopRecordCoverTask(this.mClient);
        }
    }

    public int requestRecordCover(EZStreamSDKJNA.EZRecordReq.ByValue req) {
        if (this.mClient != 0L) {
            return EZStreamSDKJNA.sEZStreamSDKJNA.sendFetcherRequest(this.mClient, req);
        }
        return -1;
    }
}

