/*
 * Decompiled with CFR 0.152.
 */
package com.ez.transcode;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import com.ez.transcode.CallbackHandler;
import com.ez.transcode.ConvertParam;
import com.ez.transcode.MediaContainer;

class VideoDecoder
extends MediaContainer {
    private static final String TAG = "VideoDecoder";
    private HandlerThread mVideoDecoderHandlerThread;
    private CallbackHandler mVideoDecoderHandler;

    VideoDecoder(ConvertParam convertParam, String mimeType) {
        this.mConvertParam = convertParam;
        this.mediaCodec = this.createVideoDecoder(mimeType);
    }

    boolean start(MediaFormat inputFormat, Surface surface) {
        this.mediaCodec.configure(inputFormat, surface, null, 0);
        this.mediaCodec.start();
        return true;
    }

    @Override
    void release() {
        super.release();
        if (this.mVideoDecoderHandlerThread != null) {
            this.mVideoDecoderHandlerThread.quitSafely();
            this.mVideoDecoderHandlerThread = null;
            this.mVideoDecoderHandler = null;
        }
    }

    private MediaCodec createVideoDecoder(String mime) {
        this.mVideoDecoderHandlerThread = new HandlerThread("DecoderThread");
        this.mVideoDecoderHandlerThread.start();
        this.mVideoDecoderHandler = new CallbackHandler(this.mVideoDecoderHandlerThread.getLooper());
        MediaCodec.Callback callback = new MediaCodec.Callback(){

            public void onError(MediaCodec codec, MediaCodec.CodecException exception) {
                if (VideoDecoder.this.convertCallback != null) {
                    VideoDecoder.this.convertCallback.onError(exception.getMessage());
                }
            }

            public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
                MediaFormat decoderOutputVideoFormat = codec.getOutputFormat();
                Log.d((String)VideoDecoder.TAG, (String)("video decoder: onOutputFormatChanged(): " + decoderOutputVideoFormat));
            }

            public void onInputBufferAvailable(MediaCodec codec, int index) {
                if (VideoDecoder.this.isCancel) {
                    return;
                }
                if (VideoDecoder.this.convertCallback != null) {
                    VideoDecoder.this.convertCallback.onInputBufferAvailable(codec, index);
                }
            }

            public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
                if (VideoDecoder.this.isCancel) {
                    return;
                }
                if (VideoDecoder.this.convertCallback != null) {
                    VideoDecoder.this.convertCallback.onOutputBufferAvailable(codec, index, info);
                }
            }
        };
        this.mVideoDecoderHandler.create(false, mime, callback);
        return this.mVideoDecoderHandler.getCodec();
    }
}

