/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.wifi.configuration;

import android.annotation.SuppressLint;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.hikvision.wifi.configuration.DeviceInfo;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;

@SuppressLint(value={"NewApi"})
public abstract class BonjorBase {
    private static final String TAG = "BonjorBase";

    abstract boolean start();

    abstract boolean stop();

    protected DeviceInfo parseServiceEvent(NsdServiceInfo service) {
        String[] array;
        Log.d((String)TAG, (String)("parseServiceEvent NsdServiceInfo:" + service.toString()));
        if (TextUtils.isEmpty((CharSequence)service.getServiceName())) {
            return null;
        }
        DeviceInfo devInfo = new DeviceInfo();
        devInfo.setName(service.getServiceName());
        devInfo.setPort(service.getPort());
        InetAddress addresses = service.getHost();
        if (addresses != null) {
            devInfo.setIp(addresses.getHostAddress());
            Log.d((String)TAG, (String)("parseServiceEvent setIp:" + addresses.getHostAddress()));
        }
        if ((array = service.getServiceName().split("&")).length >= 2) {
            devInfo.setType(array[1]);
        }
        if (array.length >= 3) {
            devInfo.setSerialNo(array[2]);
        }
        if (array.length >= 4) {
            devInfo.setState(this.getState(array[3]));
        }
        return devInfo;
    }

    protected DeviceInfo parseServiceEvent(ServiceEvent ev) {
        ServiceInfo serviceInfo = ev.getInfo();
        Log.i((String)TAG, (String)("bonjour find" + ev.getName() + "\n" + serviceInfo.getApplication() + "\n" + serviceInfo.getDomain() + "\n" + serviceInfo.getNiceTextString() + "\n" + serviceInfo.getPort() + "\n" + serviceInfo.getPriority() + "\n" + serviceInfo.getProtocol() + "\n" + serviceInfo.getQualifiedName() + "\n" + new String(serviceInfo.getTextBytes()) + "\n"));
        DeviceInfo devInfo = new DeviceInfo();
        devInfo.setName(ev.getName());
        this.parseServiceInfo(serviceInfo, devInfo);
        String[] array = ev.getName().split("&");
        if (array.length >= 2) {
            devInfo.setType(array[1]);
        }
        if (array.length >= 3) {
            devInfo.setSerialNo(array[2]);
        }
        if (array.length >= 4) {
            devInfo.setState(this.getState(array[3]));
        }
        return devInfo;
    }

    protected void parseServiceInfo(ServiceInfo serviceInfo, DeviceInfo devInfo) {
        if (serviceInfo == null || devInfo == null) {
            return;
        }
        devInfo.setPort(serviceInfo.getPort());
        InetAddress address = serviceInfo.getAddress();
        InetAddress inetAddress = serviceInfo.getInetAddress();
        InetAddress[] inetAddresses = serviceInfo.getInetAddresses();
        Inet4Address[] inet4Address = serviceInfo.getInet4Addresses();
        Inet6Address[] inet6Address = serviceInfo.getInet6Addresses();
        if (inet4Address != null && inet4Address.length > 0) {
            devInfo.setIp(inet4Address[0].getHostAddress());
            Log.i((String)TAG, (String)("inet4Address:" + inet4Address[0].getHostAddress()));
        } else if (inet6Address != null && inet6Address.length > 0) {
            devInfo.setIp(inet6Address[0].getHostAddress());
            Log.i((String)TAG, (String)("inet6Address:" + inet6Address[0].getHostAddress()));
        } else if (inetAddresses != null && inetAddresses.length > 0) {
            devInfo.setIp(inetAddresses[0].getHostAddress());
            Log.i((String)TAG, (String)("inetAddresses:" + inetAddresses[0].getHostAddress()));
        } else if (inetAddress != null) {
            devInfo.setIp(inetAddress.getHostAddress());
            Log.i((String)TAG, (String)("inetAddress:" + inetAddress.getHostAddress()));
        } else if (address != null) {
            devInfo.setIp(address.getHostAddress());
            Log.i((String)TAG, (String)("address:" + address.getHostAddress()));
        }
    }

    private DeviceInfo.DevceState getState(String string) {
        DeviceInfo.DevceState state = DeviceInfo.DevceState.NOTH;
        if (string.equalsIgnoreCase("NOTH")) {
            state = DeviceInfo.DevceState.NOTH;
        } else if (string.equalsIgnoreCase("WIFI")) {
            state = DeviceInfo.DevceState.WIFI;
        } else if (string.equalsIgnoreCase("PLAT")) {
            state = DeviceInfo.DevceState.PLAT;
        } else if (string.equalsIgnoreCase("ALARMREPORT")) {
            state = DeviceInfo.DevceState.REPORT;
        }
        return state;
    }

    protected boolean isSupportNSD() {
        return Build.VERSION.SDK_INT >= 16;
    }
}

