/*
 * Decompiled with CFR 0.152.
 */
package org.MediaPlayer.PlayM4;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import java.nio.ByteBuffer;
import org.MediaPlayer.PlayM4.TimeStruct;

public class MediaCodecHwDecImpl {
    private String TAG = "PlayerSDK";
    private MediaCodec mediaCodec = null;
    private MediaFormat mediaFormat = null;
    private ByteBuffer[] inputBuffers = null;
    private ByteBuffer[] outputBuffers = null;
    private MediaCodec.BufferInfo bufferInfo = null;
    private int outputBufferIndex = -1;
    private int inputBufferIndex = -1;
    private boolean bInit = false;
    private boolean bStart = false;

    public int Init(int type, int width, int height) {
        if (type < 0 || width <= 0 || height <= 0) {
            return 32771;
        }
        String mime = "";
        switch (type) {
            case 0: {
                mime = "video/avc";
                Log.i((String)this.TAG, (String)"Create H264 MediaCodec and MediaFormat");
                break;
            }
            case 1: {
                mime = "video/hevc";
                Log.i((String)this.TAG, (String)"Create H265 MediaCodec and MediaFormat");
                break;
            }
            case 2: {
                mime = "video/mp4v-es";
                Log.i((String)this.TAG, (String)"Create MPEG4 MediaCodec and MediaFormat");
                break;
            }
            case 3: {
                mime = "video/mjpeg";
                Log.i((String)this.TAG, (String)"Create MJPEG MediaCodec and MediaFormat");
                break;
            }
            default: {
                Log.i((String)this.TAG, (String)"other type is not support set mime null");
            }
        }
        if (mime.isEmpty()) {
            return 33025;
        }
        if (this.bInit) {
            return 32770;
        }
        try {
            this.mediaFormat = MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("MEDIACODEC_TRY_CATCH_ERR createVideoFormat mime=" + mime + "width*height=" + width + "*" + height));
            e.printStackTrace();
            return 32772;
        }
        if (this.mediaFormat == null) {
            return 33027;
        }
        try {
            MediaCodecInfo.VideoCapabilities videoCapabilities;
            MediaCodecInfo decoderInfo = this.chooseCodec(mime);
            if (null == decoderInfo) {
                return 33027;
            }
            boolean isGetInfo = false;
            MediaCodecInfo.CodecCapabilities capabilities = decoderInfo.getCapabilitiesForType(mime);
            if (capabilities != null && (videoCapabilities = capabilities.getVideoCapabilities()) != null) {
                Range supportedHeights = videoCapabilities.getSupportedHeights();
                Range supportedWidths = videoCapabilities.getSupportedWidths();
                if (supportedHeights != null && supportedWidths != null) {
                    isGetInfo = true;
                    if (height > (Integer)supportedHeights.getUpper() || height < (Integer)supportedHeights.getLower() || width > (Integer)supportedWidths.getUpper() || width < (Integer)supportedWidths.getLower()) {
                        return 33028;
                    }
                }
            }
            if (!(isGetInfo || height >= 200 && width >= 200)) {
                return 33028;
            }
            Log.e((String)this.TAG, (String)("Codec name: " + decoderInfo.getName()));
            if (decoderInfo.getName().indexOf("OMX.SEC") != -1) {
                Log.e((String)this.TAG, (String)("MEDIACODEC_TRY_CATCH_ERR Codec name:" + decoderInfo.getName() + "is invalid!"));
                return 32772;
            }
            this.mediaCodec = MediaCodec.createByCodecName((String)decoderInfo.getName());
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("MEDIACODEC_TRY_CATCH_ERR createDecoderByType mime: " + mime));
            e.printStackTrace();
            return 32772;
        }
        if (this.mediaCodec == null) {
            return 33026;
        }
        this.bInit = true;
        return 0;
    }

    private MediaCodecInfo chooseCodec(String mimeType) {
        int codecNum = MediaCodecList.getCodecCount();
        for (int i = 0; i < codecNum; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (codecInfo.isEncoder()) continue;
            String[] type = codecInfo.getSupportedTypes();
            for (int j = 0; j < type.length; ++j) {
                if (!type[j].equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return null;
    }

    public int Start(Surface surface) {
        if (!this.bInit) {
            return 32770;
        }
        if (this.bStart) {
            return 32770;
        }
        if (this.mediaFormat == null || this.mediaCodec == null) {
            return 32769;
        }
        try {
            this.mediaCodec.configure(this.mediaFormat, surface, null, 0);
            this.mediaCodec.start();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR start");
            e.printStackTrace();
            return 32772;
        }
        if (this.inputBuffers == null || this.outputBuffers == null) {
            return 33283;
        }
        this.bStart = true;
        return 0;
    }

    public int PushDataIntoCodecEx(ByteBuffer data, long timeStampUs, int timeOut) {
        if (!this.bStart) {
            return 32770;
        }
        if (data == null || data.capacity() == 0) {
            return 32771;
        }
        try {
            this.inputBufferIndex = this.mediaCodec.dequeueInputBuffer((long)timeOut);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR dequeueInputBuffer_ex");
            e.printStackTrace();
            return 32772;
        }
        if (this.inputBufferIndex < 0) {
            return 33538;
        }
        ByteBuffer srcInputBuf = this.inputBuffers[this.inputBufferIndex];
        srcInputBuf.clear();
        data.position(0);
        data.limit(data.capacity());
        srcInputBuf.put(data);
        try {
            this.mediaCodec.queueInputBuffer(this.inputBufferIndex, 0, data.capacity(), timeStampUs, 0);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR queueInputBuffer_ex");
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }

    public int PushDataIntoCodec(byte[] data, int dataLen, int timeStampUs, int timeOut) {
        if (!this.bStart) {
            return 32770;
        }
        if (data == null || dataLen == 0) {
            return 32771;
        }
        try {
            this.inputBufferIndex = this.mediaCodec.dequeueInputBuffer((long)timeOut);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR dequeueInputBuffer");
            e.printStackTrace();
            return 32772;
        }
        if (this.inputBufferIndex < 0) {
            return 33538;
        }
        ByteBuffer srcInputBuf = this.inputBuffers[this.inputBufferIndex];
        srcInputBuf.clear();
        srcInputBuf.put(data, 0, dataLen);
        try {
            this.mediaCodec.queueInputBuffer(this.inputBufferIndex, 0, dataLen, (long)timeStampUs, 0);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR queueInputBuffer");
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }

    public int OutputDataFromCodec(TimeStruct stTime) {
        if (!this.bStart) {
            return 32770;
        }
        this.bufferInfo = new MediaCodec.BufferInfo();
        if (this.bufferInfo == null) {
            return 32769;
        }
        try {
            this.outputBufferIndex = this.mediaCodec.dequeueOutputBuffer(this.bufferInfo, 0L);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR dequeueOutputBuffer");
            e.printStackTrace();
            return 32772;
        }
        if (this.outputBufferIndex >= 0) {
            stTime.endflag = (this.bufferInfo.flags & 4) != 0 ? 1 : 0;
            stTime.value = this.bufferInfo.presentationTimeUs;
            stTime.size = this.bufferInfo.size;
            stTime.index = this.outputBufferIndex;
            stTime.width = this.mediaFormat.getInteger("width");
            stTime.height = this.mediaFormat.getInteger("height");
            return 0;
        }
        if (-3 == this.outputBufferIndex) {
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            return 33795;
        }
        if (-2 == this.outputBufferIndex) {
            this.mediaFormat = this.mediaCodec.getOutputFormat();
            Log.e((String)this.TAG, (String)("Output format changed: " + this.mediaFormat));
            return 33794;
        }
        if (-1 == this.outputBufferIndex) {
            return 33793;
        }
        return 33796;
    }

    public int OutputDataRender(int nOutputBufferIndex, boolean bIsRender) {
        if (!this.bStart) {
            return 32770;
        }
        if (nOutputBufferIndex < 0) {
            return 33796;
        }
        try {
            this.mediaCodec.releaseOutputBuffer(nOutputBufferIndex, bIsRender);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR releaseOutputBuffer");
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }

    public int Stop() {
        if (!this.bStart) {
            return 32770;
        }
        try {
            this.mediaCodec.stop();
            this.mediaCodec.release();
            this.mediaCodec = null;
            this.bInit = false;
            this.bStart = false;
            Log.i((String)this.TAG, (String)"stop");
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"MEDIACODEC_TRY_CATCH_ERR stop");
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }

    public int SetEndStream() {
        if (!this.bStart) {
            return 32770;
        }
        this.inputBufferIndex = this.mediaCodec.dequeueInputBuffer(0L);
        if (this.inputBufferIndex < 0) {
            return 34049;
        }
        try {
            this.mediaCodec.queueInputBuffer(this.inputBufferIndex, 0, 0, 0L, 4);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"try catch mediacodec err with set-end-of-stream queue-input-buffer");
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }

    public int SetFlush() {
        if (!this.bStart) {
            return 32770;
        }
        try {
            this.mediaCodec.flush();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"try catch mediacodec err with set flush");
            e.printStackTrace();
            return 32772;
        }
        return 0;
    }
}

