/*
 * Decompiled with CFR 0.152.
 */
package org.MediaPlayer.PlayM4;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import org.MediaPlayer.PlayM4.PlayerCallBack;

public class Player {
    private static Player mPlayer = null;
    private static final String TAG = "PlayerSDK";
    private static final int CPU_NEON = 3;
    private static final int CPU_ARMv7 = 2;
    private static final int CPU_NOT_ARMv7 = 1;
    private static final int CPU_NOT_ARM = 0;
    public static final int STREAM_REALTIME = 0;
    public static final int STREAM_FILE = 1;
    public static final int VOLUME_MAX = 65535;
    public static final int VOLUME_DEFAULT = Short.MAX_VALUE;
    public static final int VOLUME_MUTE = 0;
    public static final int MAX_PORT = 16;
    public static final int MAX_REGION_NUM = 4;
    public static final int PLAYM4_OK = 1;
    public static final int PLAYM4_FAIL = 0;
    public static final int BUF_VIDEO_SRC = 1;
    public static final int BUF_AUDIO_SRC = 2;
    public static final int BUF_VIDEO_RENDER = 3;
    public static final int BUF_AUDIO_RENDER = 4;
    public static final int BUF_VIDEO_DECODED = 5;
    public static final int BUF_AUDIO_DECODED = 6;

    private Player() {
        System.loadLibrary("PlayCtrl");
        this.SetAndroidSDKVersion(Build.VERSION.SDK_INT);
    }

    public static Player getInstance() {
        if (Build.VERSION.SDK_INT < 9) {
            Log.e((String)TAG, (String)"Android Level Lower than 2.3!");
            return null;
        }
        if (null == mPlayer) {
            try {
                mPlayer = new Player();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mPlayer;
    }

    public int getPort() {
        return this.GetPort();
    }

    public boolean freePort(int nPort) {
        return 0 != this.FreePort(nPort);
    }

    public boolean openFile(int nPort, String filePath) {
        byte[] newPath = null;
        if (null != filePath) {
            byte[] path = filePath.getBytes();
            if (null == path) {
                return false;
            }
            try {
                newPath = new byte[path.length + 1];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < path.length; ++i) {
                newPath[i] = path[i];
            }
            newPath[newPath.length - 1] = 0;
        }
        return 0 != this.OpenFile(nPort, newPath);
    }

    public boolean closeFile(int nPort) {
        return 0 != this.CloseFile(nPort);
    }

    public boolean setHardDecode(int nPort, int bFlag) {
        if (Build.VERSION.SDK_INT < 16) {
            Log.e((String)TAG, (String)"API Level Lower than 4.1!");
            return false;
        }
        if (0 != bFlag && 1 != bFlag) {
            return false;
        }
        return 0 != this.SetHDPriority(nPort, bFlag);
    }

    public boolean playSurface(int nPort, Surface surface) {
        if (0 == this.Play(nPort, surface)) {
            Log.e((String)TAG, (String)"Play false!");
            return false;
        }
        Log.e((String)TAG, (String)"Play ->surface(surfacetextute) succ!");
        return true;
    }

    public boolean play(int nPort, SurfaceHolder holder) {
        Surface surface = null;
        if (null != holder) {
            surface = holder.getSurface();
            if (null == surface) {
                return false;
            }
            if (!surface.isValid()) {
                Log.e((String)TAG, (String)"Surface Invalid!");
                return false;
            }
        }
        if (0 == this.Play(nPort, surface)) {
            Log.e((String)TAG, (String)"Play false!");
            return false;
        }
        return true;
    }

    public boolean playEx(int nPort, SurfaceTexture texture) {
        Surface surface = null;
        if (null != texture && !(surface = new Surface(texture)).isValid()) {
            Log.e((String)TAG, (String)"PlayEx Surface Invalid!");
            return false;
        }
        if (0 == this.Play(nPort, surface)) {
            Log.e((String)TAG, (String)"PlayEx false!");
            return false;
        }
        return true;
    }

    public boolean stop(int nPort) {
        return 0 != this.Stop(nPort);
    }

    public boolean pause(int nPort, int nPause) {
        return 0 != this.Pause(nPort, nPause);
    }

    public int getSdkVersion() {
        return this.GetSdkVersion();
    }

    public int getLastError(int nPort) {
        return this.GetLastError(nPort);
    }

    public boolean openStream(int nPort, byte[] pFileHeadBuf, int nSize, int nBufPoolSize) {
        return 0 != this.OpenStream(nPort, pFileHeadBuf, nSize, nBufPoolSize);
    }

    public boolean closeStream(int nPort) {
        return 0 != this.CloseStream(nPort);
    }

    public boolean setSecretKey(int nPort, int nKeyType, byte[] pSecretKey, int nKeyLen) {
        byte[] newSecretKey = null;
        if (pSecretKey == null) {
            return false;
        }
        try {
            newSecretKey = new byte[pSecretKey.length + 1];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newSecretKey == null) {
            return false;
        }
        for (int i = 0; i < pSecretKey.length; ++i) {
            newSecretKey[i] = pSecretKey[i];
        }
        newSecretKey[newSecretKey.length - 1] = 0;
        return 0 != this.SetSecretKey(nPort, nKeyType, newSecretKey, nKeyLen);
    }

    public boolean setVideoWindow(int nPort, int nRegionNum, SurfaceHolder holder) {
        Surface surface = null;
        if (null != holder) {
            surface = holder.getSurface();
            if (null == surface) {
                return false;
            }
            if (!surface.isValid()) {
                Log.e((String)TAG, (String)"Surface Invalid!");
                return false;
            }
        }
        return 0 != this.SetVideoWindow(nPort, nRegionNum, surface);
    }

    public boolean setVideoWindowEx(int nPort, int nRegionNum, SurfaceTexture texture) {
        Surface surface = null;
        if (null != texture && !(surface = new Surface(texture)).isValid()) {
            Log.e((String)TAG, (String)"setVideoWindowEx Surface Invalid!");
            return false;
        }
        return 0 != this.SetVideoWindow(nPort, nRegionNum, surface);
    }

    public boolean inputData(int nPort, byte[] pBuf, int nSize) {
        return 0 != this.InputData(nPort, pBuf, nSize);
    }

    public boolean playSound(int nPort) {
        return 0 != this.PlaySound(nPort);
    }

    public boolean stopSound() {
        return 0 != this.StopSound();
    }

    public boolean setStreamOpenMode(int nPort, int nMode) {
        return 0 != this.SetStreamOpenMode(nPort, nMode);
    }

    public int getCurrentFrameRate(int nPort) {
        return this.GetCurrentFrameRate(nPort);
    }

    public boolean getBMP(int nPort, byte[] pBitmap, int nBufSize, MPInteger stSize) {
        return 0 != this.GetBMP(nPort, pBitmap, nBufSize, stSize);
    }

    public boolean getJPEG(int nPort, byte[] pJpeg, int nBufSize, MPInteger stSize) {
        return 0 != this.GetJPEG(nPort, pJpeg, nBufSize, stSize);
    }

    public boolean getPictureSize(int nPort, MPInteger stWidth, MPInteger stHeight) {
        return 0 != this.GetPictureSize(nPort, stWidth, stHeight);
    }

    public boolean fast(int nPort) {
        return 0 != this.Fast(nPort);
    }

    public boolean slow(int nPort) {
        return 0 != this.Slow(nPort);
    }

    public long getFileTime(int nPort) {
        return this.GetFileTime(nPort);
    }

    public int getFileTotalFrames(int nPort) {
        return this.GetFileTotalFrames(nPort);
    }

    public float getPlayPos(int nPort) {
        return this.GetPlayPos(nPort);
    }

    public boolean setPlayPos(int nPort, float fRelativePos) {
        return 0 != this.SetPlayPos(nPort, fRelativePos);
    }

    public int getPlayedTime(int nPort) {
        return this.GetPlayedTime(nPort);
    }

    public int getPlayedTimeEx(int nPort) {
        return this.GetPlayedTimeEx(nPort);
    }

    public boolean setPlayedTimeEx(int nPort, int nTime) {
        if (nTime < 0) {
            Log.e((String)TAG, (String)"nTime less than 0!");
            return false;
        }
        return 0 != this.SetPlayedTimeEx(nPort, nTime);
    }

    public int getPlayedFrames(int nPort) {
        return this.GetPlayedFrames(nPort);
    }

    public int getCurrentFrameNum(int nPort) {
        return this.GetCurrentFrameNum(nPort);
    }

    public boolean setCurrentFrameNum(int nPort, int nFrameNum) {
        return 0 != this.SetCurrentFrameNum(nPort, nFrameNum);
    }

    public int getSourceBufferRemain(int nPort) {
        return this.GetSourceBufferRemain(nPort);
    }

    public boolean resetSourceBuffer(int nPort) {
        return 0 != this.ResetSourceBuffer(nPort);
    }

    public int getDisplayBuf(int nPort) {
        return this.GetDisplayBuf(nPort);
    }

    public boolean setDisplayBuf(int nPort, int nNum) {
        return 0 != this.SetDisplayBuf(nPort, nNum);
    }

    public boolean setDisplayRegion(int nPort, int nRegionNum, MPRect stSrcRect, SurfaceHolder holder, int bEnable) {
        Surface surface = null;
        if (holder != null) {
            surface = holder.getSurface();
            if (null == surface) {
                return false;
            }
            if (!surface.isValid()) {
                Log.e((String)TAG, (String)"Surface Invalid!");
                return false;
            }
        }
        return 0 != this.SetDisplayRegion(nPort, nRegionNum, stSrcRect, surface, bEnable);
    }

    public boolean setDisplayRegionEx(int nPort, int nRegionNum, MPRect stSrcRect, SurfaceTexture texture, int bEnable) {
        Surface surface = null;
        if (null != texture && !(surface = new Surface(texture)).isValid()) {
            Log.e((String)TAG, (String)"setDisplayRegionEx Surface Invalid!");
            return false;
        }
        return 0 != this.SetDisplayRegion(nPort, nRegionNum, stSrcRect, surface, bEnable);
    }

    public boolean setFECDisplayEffect(int nPort, int nRegionNum, int nEffect) {
        return 0 != this.SetDisEffect(nPort, nRegionNum, nEffect);
    }

    public boolean setFECDisplayParam(int nPort, int nRegionNum, MPVR_FISH_PARAM stParam) {
        return 0 != this.SetDisParam(nPort, nRegionNum, stParam);
    }

    public boolean getFECDisplayParam(int nPort, int nRegionNum, MPVR_FISH_PARAM stParam) {
        return 0 != this.GetDisParam(nPort, nRegionNum, stParam);
    }

    public boolean resetBuffer(int nPort, int nBufType) {
        return 0 != this.ResetBuffer(nPort, nBufType);
    }

    public int getBufferValue(int nPort, int nBufType) {
        return this.GetBufferValue(nPort, nBufType);
    }

    public boolean setDecodeFrameType(int nPort, int nFrameType) {
        return 0 != this.SetDecodeFrameType(nPort, nFrameType);
    }

    public boolean getSystemTime(int nPort, MPSystemTime stSystemTime) {
        return 0 != this.GetSystemTime(nPort, stSystemTime);
    }

    public boolean setFileEndCB(int nPort, PlayerCallBack.PlayerPlayEndCB playEndCB) {
        return 0 != this.SetFileEndCallback(nPort, playEndCB);
    }

    public boolean setDisplayCB(int nPort, PlayerCallBack.PlayerDisplayCB displayCB) {
        return 0 != this.SetDisplayCallback(nPort, displayCB);
    }

    public boolean setDisplayCBEx(int nPort, PlayerCallBack.PlayerDisplayCBEx displayCBEx) {
        return 0 != this.SetDisplayCallbackEx(nPort, displayCBEx);
    }

    public boolean setDecodeCB(int nPort, PlayerCallBack.PlayerDecodeCB decodeCB) {
        return 0 != this.SetDecodeCallback(nPort, decodeCB);
    }

    public boolean setDecodeCBEx(int nPort, PlayerCallBack.PlayerDecodeCBEx decodeCBEx) {
        return 0 != this.SetDecodeCallbackEx(nPort, decodeCBEx);
    }

    public boolean setHSDetectCB(int nPort, PlayerCallBack.PlayerHSDetectCB detectCB) {
        return 0 != this.SetHSDetectCallback(nPort, detectCB);
    }

    public boolean setFileRefCB(int nPort, PlayerCallBack.PlayerFileRefCB fileRefCB) {
        return 0 != this.SetFileRefCallBack(nPort, fileRefCB);
    }

    public boolean verticalFlip(int nPort, int nFlag) {
        return 0 != this.VerticalFlip(nPort, nFlag);
    }

    public boolean setImageCorrection(int nPort, int bEnable) {
        return 0 != this.SetImageCorrection(nPort, bEnable);
    }

    public boolean setPreRecordFlag(int nPort, boolean bFlag) {
        return !(bFlag ? 0 == this.SetPreRecordFlag(nPort, 1) : 0 == this.SetPreRecordFlag(nPort, 0));
    }

    public boolean setPreRecordCallBack(int nPort, PlayerCallBack.PlayerPreRecordCB PreRecordCB) {
        return 0 != this.SetPreRecordCallBack(nPort, PreRecordCB);
    }

    public boolean setPreRecordCallBackEx(int nPort, PlayerCallBack.PlayerPreRecordCBEx PreRecordCBEx) {
        return 0 != this.SetPreRecordCallBackEx(nPort, PreRecordCBEx);
    }

    public boolean setMaxHardDecodePort(int nCount) {
        return 0 != this.SetMaxHDPort(nCount);
    }

    public int getDecoderType(int nPort) {
        return this.GetDecoderType(nPort);
    }

    public boolean setFECDisplayPTZ(int nPort, int nSubPort, MPVR_FISH_PTZ stOriPtz, MPVR_FISH_PTZ stWndPtz, MPVR_FISH_PTZ stWnd, MPFloat stX, MPFloat stY) {
        return 0 != this.SetPTZParam(nPort, nSubPort, stOriPtz, stWndPtz, stWnd, stX, stY);
    }

    public boolean reversePlay(int nPort) {
        return 0 != this.ReversePlay(nPort);
    }

    public boolean setSycGroup(int nPort, int nGroupIndex) {
        return 0 != this.SetSycGroup(nPort, nGroupIndex);
    }

    public boolean openStreamAdvanced(int nPort, int nProtocolType, SESSION_INFO stInfo, byte[] sessionData, int nBufSize) {
        return 0 != this.OpenStreamAdvanced(nPort, nProtocolType, stInfo, sessionData, nBufSize);
    }

    public boolean setEcnTypeChgCB(int nPort, PlayerCallBack.PlayerEncTypeChgCB typeChgCB) {
        return 0 != this.SetEcnTypeChgCB(nPort, typeChgCB);
    }

    public boolean setWindowTransparency(int nPort, float fTrans) {
        return 0 != this.SetWindowTransparency(nPort, fTrans);
    }

    public boolean setAdditionalCallback(int nPort, int nSyncType, PlayerCallBack.PlayerAdditionalCB additionCB) {
        return 0 != this.SetAdditionalCallBack(nPort, nSyncType, additionCB);
    }

    public boolean syncToAudio(int nPort, int nSyncToAudio) {
        return 0 != this.SyncToAudio(nPort, nSyncToAudio);
    }

    public boolean setIVSDrawFunCallback(int nPort, PlayerCallBack.PlayerIVSDrawFunCB drawFunCB) {
        return 0 != this.SetIVSDrawFunCallback(nPort, drawFunCB);
    }

    public boolean renderPrivateData(int nPort, int nIntelType, int bTrue) {
        return 0 != this.RenderPrivateData(nPort, nIntelType, bTrue);
    }

    public boolean renderPrivateDataEx(int nPort, int nIntelType, int nSubType, int bTrue) {
        return 0 != this.RenderPrivateDataEx(nPort, nIntelType, nSubType, bTrue);
    }

    public boolean setOverlayPriInfoFlag(int nPort, int nIntelType, int bTrue, String filePath) {
        byte[] newPath = null;
        if (null != filePath) {
            byte[] path = filePath.getBytes();
            if (null == path) {
                return false;
            }
            try {
                newPath = new byte[path.length + 1];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < path.length; ++i) {
                newPath[i] = path[i];
            }
            newPath[newPath.length - 1] = 0;
        }
        return 0 != this.SetOverlayPriInfoFlag(nPort, nIntelType, bTrue, newPath);
    }

    public boolean enableFEC(int nPort) {
        return 0 != this.EnableFEC(nPort);
    }

    public boolean disableFEC(int nPort) {
        return 0 != this.DisableFEC(nPort);
    }

    public int getPortFEC(int nPort, int nPlaceType, int nCorrectType) {
        return this.GetPortFEC(nPort, nPlaceType, nCorrectType);
    }

    public boolean delPortFEC(int nPort, int nSubPort) {
        return 0 != this.DelPortFEC(nPort, nSubPort);
    }

    public boolean setParamFEC(int nPort, int nSubPort, FISHEYE_PARAM stParam) {
        return 0 != this.SetParamFEC(nPort, nSubPort, stParam);
    }

    public boolean getParamFEC(int nPort, int nSubPort, FISHEYE_PARAM stParam) {
        return 0 != this.GetParamFEC(nPort, nSubPort, stParam);
    }

    public boolean setWnd(int nPort, int nSubPort, SurfaceHolder holder) {
        Surface surface = null;
        if (null != holder) {
            surface = holder.getSurface();
            if (null == surface) {
                return false;
            }
            if (!surface.isValid()) {
                Log.e((String)TAG, (String)"setWnd Surface Invalid!");
                return false;
            }
        }
        return 0 != this.SetWnd(nPort, nSubPort, surface);
    }

    public boolean setWndEx(int nPort, int nSubPort, SurfaceTexture texture) {
        Surface surface = null;
        if (null != texture && !(surface = new Surface(texture)).isValid()) {
            Log.e((String)TAG, (String)"setWndEx Surface Invalid!");
            return false;
        }
        return 0 != this.SetWnd(nPort, nSubPort, surface);
    }

    public int getCurrentPTZPort(int nPort, int nPanorama, float fPositionX, float fPositionY) {
        return this.GetCurrentPTZPort(nPort, nPanorama, fPositionX, fPositionY);
    }

    public boolean setCurrentPTZPort(int nPort, int nSubPort) {
        return 0 != this.SetCurrentPTZPort(nPort, nSubPort);
    }

    public boolean setPTZoutLineShowMode(int nPort, int nShowmode) {
        return 0 != this.SetPTZoutLineShowMode(nPort, nShowmode);
    }

    public boolean setPTZ2Window(int nPort, int nSubPort, PTZ_PARAM stPTZRefOrigin, PTZ_PARAM stPTZRefWindow, PTZ_PARAM stPTZWindow, MPFloat stPosX, MPFloat stPosY) {
        return 0 != this.SetPTZToWindow(nPort, nSubPort, stPTZRefOrigin, stPTZRefWindow, stPTZWindow, stPosX, stPosY);
    }

    public boolean switchToSoft(int nPort) {
        return 0 != this.SwitchToSoft(nPort);
    }

    public boolean switchToHard(int nPort) {
        return 0 != this.SwitchToHard(nPort);
    }

    public int getPlayTimeOffset(int nPort, int nTime) {
        return this.GetPlayTimeOffset(nPort, nTime);
    }

    public boolean adjustWaveAudio(int nPort, int nValue) {
        return 0 != this.AdjustWave(nPort, nValue);
    }

    public boolean refreshPlay(int nPort) {
        return 0 != this.RefreshPlay(nPort);
    }

    public boolean setIFrameDecInterval(int nPort, int nInterval) {
        return 0 != this.SetIFrameDecInterval(nPort, nInterval);
    }

    public boolean setFish3DRotate(int nPort, int nSubPort, SRTRANS_PARAM srTransParam) {
        return 0 != this.SetFish3DRotate(nPort, nSubPort, srTransParam);
    }

    public boolean setFish3DRotateAbs(int nPort, int nSubPort, SRTRANS_PARAM srTransParam) {
        return 0 != this.SetFish3DRotateAbs(nPort, nSubPort, srTransParam);
    }

    public boolean getFish3DRotateSpecialView(int nPort, int nSubPort, int nSpecialViewType, SRTRANS_PARAM srTransParam) {
        return 0 != this.GetFish3DRotateSpecialView(nPort, nSubPort, nSpecialViewType, srTransParam);
    }

    public boolean getFishCapPicSize(int nPort, int nSubPort, MPInteger nCapPicSize) {
        return 0 != this.GetFishCapPicSize(nPort, nSubPort, nCapPicSize);
    }

    public boolean getFishCapPic(int nPort, int nSubPort, int nType, byte[] pFishPic, int nFishPicSize) {
        return 0 != this.GetFishCapPic(nPort, nSubPort, nType, pFishPic, nFishPicSize);
    }

    public boolean getBmpEx(int nPort, byte[] pBitMap, int nBufferSize, MPInteger nBitMapSize) {
        return 0 != this.GetBmpEx(nPort, pBitMap, nBufferSize, nBitMapSize);
    }

    public boolean playSoundShare(int nPort) {
        return 0 != this.PlaySoundShare(nPort);
    }

    public boolean stopSoundShare(int nPort) {
        return 0 != this.StopSoundShare(nPort);
    }

    public boolean switchToWriteData(int nPort, int bWrite, int nType) {
        return 0 != this.SwitchToWriteData(nPort, bWrite, nType);
    }

    public boolean configureLogStatus(int nPort, int bEnable, int nLogType) {
        return 0 != this.ConfigureLogStatus(nPort, bEnable, nLogType);
    }

    public boolean skipErrorData(int nPort, int nSkip) {
        return 0 != this.SkipErrorData(nPort, nSkip);
    }

    public boolean setEncryptTypeCallBack(int nPort, int nType, PlayerCallBack.PlayerEncryptTypeCB encryptTypeCB) {
        return 0 != this.SetEncryptTypeCallBack(nPort, nType, encryptTypeCB);
    }

    public boolean setAudioDataCallBack(int nPort, PlayerCallBack.PlayerAudioDataCB audioDataCB) {
        return 0 != this.SetAudioDataCallBack(nPort, audioDataCB);
    }

    public boolean setRunTimeInfoCallBack(int nPort, int nModule, PlayerCallBack.PlayerRunTimeInfoCB runTimeInfoCB) {
        return 0 != this.SetRunTimeInfoCallBack(nPort, nModule, runTimeInfoCB);
    }

    public boolean getFish3DRotate(int nPort, int nSubPort, SRTRANS_PARAM stTransParam) {
        return 0 != this.GetFish3DRotate(nPort, nSubPort, stTransParam);
    }

    public boolean setHSParam(int nPort, int nEnable, int nNotch, int nTime) {
        return 0 != this.SetHSParam(nPort, nEnable, nNotch, nTime);
    }

    public boolean setAudioTrackParam(int nPort, int nAudioTrackMode, int nAudioSessionId) {
        return 0 != this.SetAudioTrackParam(nPort, nAudioTrackMode, nAudioSessionId);
    }

    public boolean setAnimation(int nPort, int nSubPort, int nAnimationType, int nCurFrame, int nTotalFrames) {
        return 0 != this.SetAnimation(nPort, nSubPort, nAnimationType, nCurFrame, nTotalFrames);
    }

    public boolean setDecodeERC(int nPort, int nERCLevel) {
        return 0 != this.SetDecodeERC(nPort, nERCLevel);
    }

    public boolean setFECDisplayCB(int nPort, int nFishPort, PlayerCallBack.PlayerFECDisplayCB FECDisplayCB) {
        return 0 != this.SetFECDisplayCallBack(nPort, nFishPort, FECDisplayCB);
    }

    public boolean setAbsTimeFlag(int nPort, int nFlag) {
        return 0 != this.SetAbsTimeFlag(nPort, nFlag);
    }

    public boolean setAGCParam(int nPort, int nEnable, int nAGCLevel) {
        return 0 != this.SetAGCParam(nPort, nEnable, nAGCLevel);
    }

    public boolean setLDCFlag(int nPort, int nFlag) {
        return 0 != this.SetLDCFlag(nPort, nFlag);
    }

    public boolean setDemuxParam(int nPort, int nDemuxType, int nChunSize) {
        return 0 != this.SetDemuxParam(nPort, nDemuxType, nChunSize);
    }

    public boolean setSupplementaryTimeZone(int nPort, int nTimeZone) {
        return 0 != this.SetSupplementaryTimeZone(nPort, nTimeZone);
    }

    public int getSupplementaryTimeZone(int nPort) {
        return this.GetSupplementaryTimeZone(nPort);
    }

    public boolean getHDJPEG(int nPort, byte[] pJpeg, int nBufSize, int nJPEGQuality, int nWidth, int nHeight, MPInteger stSize) {
        return 0 != this.GetHDJPEG(nPort, pJpeg, nBufSize, nJPEGQuality, nWidth, nHeight, stSize);
    }

    public boolean getBMPFixPixelEx(int nPort, byte[] pBMP, int nBufSize, int nWidth, int nHeight, MPInteger stSize) {
        return 0 != this.GetBMPFixPixelEx(nPort, pBMP, nBufSize, nWidth, nHeight, stSize);
    }

    public boolean fecCaptureFixPixel(int nPort, int nSubPort, int nType, byte[] pBMP, int nBufSize, int nWidth, int nHeight) {
        return 0 != this.FecCaptureFixPixel(nPort, nSubPort, nType, pBMP, nBufSize, nWidth, nHeight);
    }

    public boolean fecGetCapPicSizeFixPixel(int nPort, int nSubPort, int nWidth, int nHeight, MPInteger stSize) {
        return 0 != this.FecGetCapPicSizeFixPixel(nPort, nSubPort, nWidth, nHeight, stSize);
    }

    public boolean setExpectedFrameRate(int nPort, float fExpectedFrameRate, int nFlag) {
        return 0 != this.SetExpectedFrameRate(nPort, fExpectedFrameRate, nFlag);
    }

    public boolean setDecodeThreadNumber(int nPort, int nThreadNum) {
        return 0 != this.SetDecodeThreadNumber(nPort, nThreadNum);
    }

    public boolean setPlayIntervalTime(int nPort, int nIntervalTime) {
        return 0 != this.SetPlayIntervalTime(nPort, nIntervalTime);
    }

    public boolean setDisplayRegionDST(int nPort, int nRegionNum, MPRect stHwdRect, SurfaceHolder holder, int bEnable) {
        Surface surface = null;
        if (holder != null) {
            surface = holder.getSurface();
            if (null == surface) {
                return false;
            }
            if (!surface.isValid()) {
                Log.e((String)TAG, (String)"Surface Invalid!");
                return false;
            }
        }
        return 0 != this.SetDisplayRegionDST(nPort, nRegionNum, stHwdRect, surface, bEnable);
    }

    public boolean enableSuperEyeEffect(int nPort, int nRegionNum) {
        return 0 != this.EnableSuperEyeEffect(nPort, nRegionNum);
    }

    public boolean disableSuperEyeEffect(int nPort, int nRegionNum, int nKeepEffect) {
        return 0 != this.DisableSuperEyeEffect(nPort, nRegionNum, nKeepEffect);
    }

    public boolean getCurrentRegionRect(int nPort, int nRegionNum, MPRect stRect) {
        return 0 != this.GetCurrentRegionRect(nPort, nRegionNum, stRect);
    }

    public boolean setANRParam(int nPort, int nEnable, int nANRLevel) {
        return 0 != this.SetANRParam(nPort, nEnable, nANRLevel);
    }

    public boolean setImagePostProcessParameter(int nPort, int nType, float fValue) {
        return 0 != this.SetImagePostProcessParameter(nPort, nType, fValue);
    }

    public Boolean setPosBGRectColor(int nPort, int nAlpha, int nRed, int nGreen, int nBlue) {
        if (0 == this.SetPosBGRectColor(nPort, nAlpha, nRed, nGreen, nBlue)) {
            return false;
        }
        return true;
    }

    public boolean setDecodeErrCB(int nPort, int nErrType, int nHeight, int nWidth, PlayerCallBack.PlayerDecodeErrCB decodeErrCB) {
        return 0 != this.SetDecodeErrCallback(nPort, nErrType, nHeight, nWidth, decodeErrCB);
    }

    public boolean setResetHardDecodeFlag(int nPort, boolean bResetFlag) {
        return 0 != this.SetResetHardDecodeFlag(nPort, bResetFlag);
    }

    public Boolean setPrivateFatio(int nPort, float fRatio) {
        if (0 == this.SetPrivateFatio(nPort, fRatio)) {
            return false;
        }
        return true;
    }

    public Boolean setTargetStreamPID(int nPort, int nPID) {
        if (0 == this.SetTargetStreamPID(nPort, nPID)) {
            return false;
        }
        return true;
    }

    public boolean setHDErrCB(int nPort, PlayerCallBack.PlayerDecodeErrCB hdErrCB) {
        return 0 != this.SetHDErrCallback(nPort, hdErrCB);
    }

    public boolean setMaxHDSize(int nPort, int nWidth, int nHeight) {
        return 0 != this.SetMaxHDSize(nPort, nWidth, nHeight);
    }

    public boolean setRealTimeRenderFrameRateCB(int nPort, PlayerCallBack.RealTimeRenderFrameRateCB realtimeCB) {
        return 0 != this.SetRealTimeRenderFrameRateCB(nPort, realtimeCB);
    }

    public boolean setFlipEffect(int nPort, int nEffect, boolean bFlag) {
        return 0 != this.SetFlipEffect(nPort, nEffect, bFlag);
    }

    public boolean setRotateEffect(int nPort, int nEffect) {
        return 0 != this.SetRotateEffect(nPort, nEffect);
    }

    public boolean setScaleType(int nPort, int nScaleType) {
        return 0 != this.SetScaleType(nPort, nScaleType);
    }

    public boolean setAVCExtendSPSFlag(int nPort, int nAVCExtendSPSFlag) {
        return 0 != this.SetAVCExtendSPSFlag(nPort, nAVCExtendSPSFlag);
    }

    public boolean setVideoFrameCB(int nPort, PlayerCallBack.PlayerVideoFrameCB playerVideoFrameCB) {
        return 0 != this.SetVideoFrameCB(nPort, playerVideoFrameCB);
    }

    public boolean setAudioPriority(int nPort, int nLevel) {
        return 0 != this.SetAudioPriority(nPort, nLevel);
    }

    public boolean stopSoundEx(int nPort) {
        return 0 != this.StopSoundEx(nPort);
    }

    public boolean setLogCallBack(PlayerCallBack.PlayerLogCB PlayerLogCB2) {
        return 0 != this.SetLogCallBack(PlayerLogCB2);
    }

    public boolean skipAudioData(int nPort, int nSkip) {
        return 0 != this.SkipAudioData(nPort, nSkip);
    }

    public boolean setEzvizSSLEffect(int nPort, int nSubPort, boolean bOpen) {
        return 0 != this.SetEzvizSSLEffect(nPort, nSubPort, bOpen);
    }

    public boolean setDemuxModel(int nPort, int nIdemuxType, int bTrue) {
        return 1 == this.SetDemuxModel(nPort, nIdemuxType, bTrue);
    }

    public boolean openDebugLogByCB(int LogLevel, PlayerCallBack.PlayerLogCB PlayerLogCB2) {
        return 0 != this.OpenDebugLogByCB(LogLevel, PlayerLogCB2);
    }

    public boolean openDebugLogByFile(int nFileSaveMode, boolean bSwitch, int LogLevel, String FilePath, int FileSize) {
        return 0 != this.OpenDebugLogByFile(nFileSaveMode, bSwitch, LogLevel, FilePath, FileSize);
    }

    private native int GetPort();

    private native int FreePort(int var1);

    private native int OpenFile(int var1, byte[] var2);

    private native int CloseFile(int var1);

    private native int GetLastError(int var1);

    private native int GetSdkVersion();

    private native int Play(int var1, Surface var2);

    private native int Stop(int var1);

    private native int Pause(int var1, int var2);

    private native int Fast(int var1);

    private native int Slow(int var1);

    private native int PlaySound(int var1);

    private native int StopSound();

    private native int SetStreamOpenMode(int var1, int var2);

    private native int OpenStream(int var1, byte[] var2, int var3, int var4);

    private native int CloseStream(int var1);

    private native int InputData(int var1, byte[] var2, int var3);

    private native long GetFileTime(int var1);

    private native int GetFileTotalFrames(int var1);

    private native float GetPlayPos(int var1);

    private native int SetPlayPos(int var1, float var2);

    private native int GetPlayedTime(int var1);

    private native int GetPlayedTimeEx(int var1);

    private native int SetPlayedTimeEx(int var1, int var2);

    private native int GetPlayedFrames(int var1);

    private native int GetCurrentFrameNum(int var1);

    private native int SetCurrentFrameNum(int var1, int var2);

    private native int SetVideoWindow(int var1, int var2, Surface var3);

    private native int GetCurrentFrameRate(int var1);

    private native int GetPictureSize(int var1, MPInteger var2, MPInteger var3);

    private native int GetSourceBufferRemain(int var1);

    private native int ResetSourceBuffer(int var1);

    private native int ResetSourceBufFlag(int var1);

    private native int GetDisplayBuf(int var1);

    private native int SetDisplayBuf(int var1, int var2);

    private native int SetDisplayRegion(int var1, int var2, MPRect var3, Surface var4, int var5);

    private native int SetDisEffect(int var1, int var2, int var3);

    private native int SetDisParam(int var1, int var2, MPVR_FISH_PARAM var3);

    private native int GetDisParam(int var1, int var2, MPVR_FISH_PARAM var3);

    private native int ResetBuffer(int var1, int var2);

    private native int GetBufferValue(int var1, int var2);

    private native int SetDecodeFrameType(int var1, int var2);

    private native int GetBMP(int var1, byte[] var2, int var3, MPInteger var4);

    private native int GetJPEG(int var1, byte[] var2, int var3, MPInteger var4);

    private native int SetFileEndCallback(int var1, PlayerCallBack.PlayerPlayEndCB var2);

    private native int SetDisplayCallback(int var1, PlayerCallBack.PlayerDisplayCB var2);

    private native int SetDisplayCallbackEx(int var1, PlayerCallBack.PlayerDisplayCBEx var2);

    private native int SetDecodeCallback(int var1, PlayerCallBack.PlayerDecodeCB var2);

    private native int SetDecodeCallbackEx(int var1, PlayerCallBack.PlayerDecodeCBEx var2);

    private native int SetHSDetectCallback(int var1, PlayerCallBack.PlayerHSDetectCB var2);

    private native int SetSecretKey(int var1, int var2, byte[] var3, int var4);

    private native int GetSystemTime(int var1, MPSystemTime var2);

    private native int SetFileRefCallBack(int var1, PlayerCallBack.PlayerFileRefCB var2);

    private native int VerticalFlip(int var1, int var2);

    private native void SetAndroidSDKVersion(int var1);

    private native int SetImageCorrection(int var1, int var2);

    private native int SetHDPriority(int var1, int var2);

    private native int SetPreRecordFlag(int var1, int var2);

    private native int SetPreRecordCallBack(int var1, PlayerCallBack.PlayerPreRecordCB var2);

    private native int SetPreRecordCallBackEx(int var1, PlayerCallBack.PlayerPreRecordCBEx var2);

    private native int SetMaxHDPort(int var1);

    private native int GetDecoderType(int var1);

    private native int SetPTZParam(int var1, int var2, MPVR_FISH_PTZ var3, MPVR_FISH_PTZ var4, MPVR_FISH_PTZ var5, MPFloat var6, MPFloat var7);

    private native int ReversePlay(int var1);

    private native int SetSycGroup(int var1, int var2);

    private native int OpenStreamAdvanced(int var1, int var2, SESSION_INFO var3, byte[] var4, int var5);

    private native int SetEcnTypeChgCB(int var1, PlayerCallBack.PlayerEncTypeChgCB var2);

    private native int SetWindowTransparency(int var1, float var2);

    private native int SetAdditionalCallBack(int var1, int var2, PlayerCallBack.PlayerAdditionalCB var3);

    private native int RenderPrivateData(int var1, int var2, int var3);

    private native int RenderPrivateDataEx(int var1, int var2, int var3, int var4);

    private native int SyncToAudio(int var1, int var2);

    private native int SetIVSDrawFunCallback(int var1, PlayerCallBack.PlayerIVSDrawFunCB var2);

    private native int EnableFEC(int var1);

    private native int DisableFEC(int var1);

    private native int GetPortFEC(int var1, int var2, int var3);

    private native int DelPortFEC(int var1, int var2);

    private native int SetParamFEC(int var1, int var2, FISHEYE_PARAM var3);

    private native int GetParamFEC(int var1, int var2, FISHEYE_PARAM var3);

    private native int SetWnd(int var1, int var2, Surface var3);

    private native int GetCurrentPTZPort(int var1, int var2, float var3, float var4);

    private native int SetCurrentPTZPort(int var1, int var2);

    private native int SetPTZoutLineShowMode(int var1, int var2);

    private native int SetPTZToWindow(int var1, int var2, PTZ_PARAM var3, PTZ_PARAM var4, PTZ_PARAM var5, MPFloat var6, MPFloat var7);

    private native int SetOverlayPriInfoFlag(int var1, int var2, int var3, byte[] var4);

    private native int SwitchToSoft(int var1);

    private native int SwitchToHard(int var1);

    private native int GetPlayTimeOffset(int var1, int var2);

    private native int AdjustWave(int var1, int var2);

    private native int RefreshPlay(int var1);

    private native int SetIFrameDecInterval(int var1, int var2);

    private native int SetFish3DRotate(int var1, int var2, SRTRANS_PARAM var3);

    private native int SetFish3DRotateAbs(int var1, int var2, SRTRANS_PARAM var3);

    private native int GetFish3DRotateSpecialView(int var1, int var2, int var3, SRTRANS_PARAM var4);

    private native int GetFishCapPicSize(int var1, int var2, MPInteger var3);

    private native int GetFishCapPic(int var1, int var2, int var3, byte[] var4, int var5);

    private native int GetBmpEx(int var1, byte[] var2, int var3, MPInteger var4);

    private native int PlaySoundShare(int var1);

    private native int StopSoundShare(int var1);

    private native int SwitchToWriteData(int var1, int var2, int var3);

    private native int ConfigureLogStatus(int var1, int var2, int var3);

    private native int SkipErrorData(int var1, int var2);

    private native int SetEncryptTypeCallBack(int var1, int var2, PlayerCallBack.PlayerEncryptTypeCB var3);

    private native int SetAudioDataCallBack(int var1, PlayerCallBack.PlayerAudioDataCB var2);

    private native int SetRunTimeInfoCallBack(int var1, int var2, PlayerCallBack.PlayerRunTimeInfoCB var3);

    private native int GetFish3DRotate(int var1, int var2, SRTRANS_PARAM var3);

    private native int SetHSParam(int var1, int var2, int var3, int var4);

    private native int SetAnimation(int var1, int var2, int var3, int var4, int var5);

    private native int SetDecodeERC(int var1, int var2);

    private native int SetFECDisplayCallBack(int var1, int var2, PlayerCallBack.PlayerFECDisplayCB var3);

    private native int SetAudioTrackParam(int var1, int var2, int var3);

    private native int SetAbsTimeFlag(int var1, int var2);

    private native int SetAGCParam(int var1, int var2, int var3);

    private native int SetLDCFlag(int var1, int var2);

    private native int SetDemuxParam(int var1, int var2, int var3);

    private native int SetSupplementaryTimeZone(int var1, int var2);

    private native int GetSupplementaryTimeZone(int var1);

    private native int GetHDJPEG(int var1, byte[] var2, int var3, int var4, int var5, int var6, MPInteger var7);

    private native int SetPlayIntervalTime(int var1, int var2);

    private native int SetDisplayRegionDST(int var1, int var2, MPRect var3, Surface var4, int var5);

    private native int GetBMPFixPixelEx(int var1, byte[] var2, int var3, int var4, int var5, MPInteger var6);

    private native int FecCaptureFixPixel(int var1, int var2, int var3, byte[] var4, int var5, int var6, int var7);

    private native int FecGetCapPicSizeFixPixel(int var1, int var2, int var3, int var4, MPInteger var5);

    private native int SetExpectedFrameRate(int var1, float var2, int var3);

    private native int SetDecodeThreadNumber(int var1, int var2);

    private native int EnableSuperEyeEffect(int var1, int var2);

    private native int DisableSuperEyeEffect(int var1, int var2, int var3);

    private native int GetCurrentRegionRect(int var1, int var2, MPRect var3);

    private native int SetANRParam(int var1, int var2, int var3);

    private native int SetImagePostProcessParameter(int var1, int var2, float var3);

    private native int SetPosBGRectColor(int var1, int var2, int var3, int var4, int var5);

    private native int SetDecodeErrCallback(int var1, int var2, int var3, int var4, PlayerCallBack.PlayerDecodeErrCB var5);

    private native int SetResetHardDecodeFlag(int var1, boolean var2);

    private native int SetPrivateFatio(int var1, float var2);

    private native int SetTargetStreamPID(int var1, int var2);

    private native int SetMaxHDSize(int var1, int var2, int var3);

    private native int SetHDErrCallback(int var1, PlayerCallBack.PlayerDecodeErrCB var2);

    private native int SetRealTimeRenderFrameRateCB(int var1, PlayerCallBack.RealTimeRenderFrameRateCB var2);

    private native int SetFlipEffect(int var1, int var2, boolean var3);

    private native int SetRotateEffect(int var1, int var2);

    private native int SetAVCExtendSPSFlag(int var1, int var2);

    private native int SetScaleType(int var1, int var2);

    private native int SetVideoFrameCB(int var1, PlayerCallBack.PlayerVideoFrameCB var2);

    private native int SetAudioPriority(int var1, int var2);

    private native int StopSoundEx(int var1);

    private native int SetLogCallBack(PlayerCallBack.PlayerLogCB var1);

    private native int SkipAudioData(int var1, int var2);

    private native int SetDemuxModel(int var1, int var2, int var3);

    private native int OpenDebugLogByCB(int var1, PlayerCallBack.PlayerLogCB var2);

    private native int OpenDebugLogByFile(int var1, boolean var2, int var3, String var4, int var5);

    private native int SetEzvizSSLEffect(int var1, int var2, boolean var3);

    public static class DEMUX_TYPE {
        public static final int DEMUX_DECODE_MARK_TYPE = 1;
        public static final int DEMUX_BEFORE_I_OUTPUT_TYPE = 2;
        public static final int DEMUX_DECODE_BEFOR_I_OUT_TYPE = 3;
    }

    public static class RENDER_ROTATE_EFFECT {
        public static final int RENDER_ROTATE_CLOCKWISE_ROTATE0 = 0;
        public static final int RENDER_ROTATE_CLOCKWISE_ROTATE90 = 1;
        public static final int RENDER_ROTATE_CLOCKWISE_ROTATE180 = 2;
        public static final int RENDER_ROTATE_CLOCKWISE_ROTATE270 = 3;
    }

    public static class RENDER_FLIP_EFFECT {
        public static final int RENDER_FLIP_VERTICALFLIP = 0;
        public static final int RENDER_FLIP_HORIZONFLIP = 1;
    }

    public static class DECODE_ERC_LEVEL {
        public static final int DECODE_ERC_LEVEL0 = 0;
        public static final int DECODE_ERC_LEVEL1 = 1;
        public static final int DECODE_ERC_LEVEL2 = 2;
        public static final int DECODE_ERC_LEVEL3 = 3;
        public static final int DECODE_ERC_LEVEL4 = 4;
    }

    public static class SRTRANS_PARAM {
        public SRTRANS_ELEMENT srtransElement;
        public int nTransCount;
    }

    public static class SRTRANS_ELEMENT {
        public float fAxisX;
        public float fAxisY;
        public float fAxisZ;
        public float fValue;
    }

    public static class FISHEYE_PARAM {
        public int updateType;
        public int placeAndCorrect;
        public float zoom;
        public float wideScanOffset;
        public PTZ_PARAM ptzParam;
        public CYCLE_PARAM cycleParam;
    }

    public static class CYCLE_PARAM {
        public float radiusLeft;
        public float radiusRight;
        public float radiusTop;
        public float radiusBottom;
    }

    public static class PTZ_PARAM {
        public float ptzPositionX;
        public float ptzPositionY;
    }

    public static class FEC_CORRECTTYPE {
        public static final int FEC_CORRECT_PTZ = 0;
        public static final int FEC_CORRECT_180 = 1;
        public static final int FEC_CORRECT_360 = 2;
        public static final int FEC_CORRECT_LAT = 3;
        public static final int FEC_CORRECT_SEM = 4;
        public static final int FEC_CORRECT_CYC = 5;
        public static final int FEC_CORRECT_PLA = 6;
        public static final int FEC_CORRECT_CYC_SPL = 7;
        public static final int FEC_CORRECT_ARC = 8;
        public static final int FEC_CORRECT_ARC_VERTICAL = 9;
        public static final int FEC_CORRECT_PANOSPHERE = 10;
        public static final int FEC_CORRECT_ORIGINAL = 11;
    }

    public static class FEC_PLACETYPE {
        public static final int FEC_NULL = 0;
        public static final int FEC_PLACE_WALL = 1;
        public static final int FEC_PLACE_FLOOR = 2;
        public static final int FEC_PLACE_CEILING = 3;
    }

    public static class FEC_SHOWMODE {
        public static final int FEC_PTZ_OUTLINE_NULL = 0;
        public static final int FEC_PTZ_OUTLINE_RECT = 1;
        public static final int FEC_PTZ_OUTLINE_RANGE = 2;
    }

    public static class SESSION_INFO {
        public int nInfoType;
        public int nInfoLen;
    }

    public static class TEM_FLAG {
        public static final int TEM_REGION_BOX = 1;
        public static final int TEM_REGION_LINE = 2;
        public static final int TEM_REGION_POINT = 4;
    }

    public static class FIRE_ALARM {
        public static final int FIRE_FRAME_DIS = 1;
        public static final int FIRE_MAX_TEMP = 2;
        public static final int FIRE_MAX_TEMP_POSITION = 4;
        public static final int FIRE_DISTANCE = 8;
    }

    public static class PRIVATE_RENDER {
        public static final int RENDER_ANA_INTEL_DATA = 1;
        public static final int RENDER_MD = 2;
        public static final int RENDER_ADD_POS = 4;
        public static final int RENDER_ADD_PIC = 8;
        public static final int RENDER_FIRE_DETCET = 16;
        public static final int RENDER_TEM = 32;
        public static final int RENDER_BG_FONT = 64;
    }

    public static class MPVR_FISH_PTZ {
        public float PTZX;
        public float PTZY;
    }

    public static class MPVR_FISH_PARAM {
        public float xLeft;
        public float xRight;
        public float yTop;
        public float yBottom;
        public float angle;
        public float zoom;
        public float PTZX;
        public float PTZY;
    }

    public static class MPVR_DISPLAY_EFFECT {
        public static final int VR_ET_NULL = 0;
        public static final int VR_ET_FISH_PTZ_CEILING = 1;
        public static final int VR_ET_FISH_PTZ_FLOOR = 2;
        public static final int VR_ET_FISH_PTZ_WALL = 3;
        public static final int VR_ET_FISH_PANORAMA_CEILING360 = 4;
        public static final int VR_ET_FISH_PANORAMA_CEILING180 = 5;
        public static final int VR_ET_FISH_PANORAMA_FLOOR360 = 6;
        public static final int VR_ET_FISH_PANORAMA_FLOOR180 = 7;
        public static final int VR_ET_FISH_LATITUDE_WALL = 8;
        public static final int VR_ET_REDBLUE_3D = 9;
    }

    public static class MPRect {
        public int left;
        public int right;
        public int top;
        public int bottom;
    }

    public static class MPSystemTime {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int min;
        public int sec;
        public int ms;
    }

    public static class MPFloat {
        public float fValue;
    }

    public static class MPInteger {
        public int value;
    }

    public static class MP_DECODE_TYPE {
        public static int DECODE_ALL = 0;
        public static int DECODE_VIDEO_KEYFRAME = 1;
        public static int DECODE_NONE = 2;
    }
}

