/*
 * Decompiled with CFR 0.152.
 */
package com.hik.TTSClient;

import android.text.TextUtils;
import com.hik.TTSClient.TTSClientCallback;

public class TTSClient {
    public static final int TTS_DATA_NOMAL_CMD = 16640;
    public static final int TTS_DATA_PRESS_CMD = 16896;
    public static final int TTS_DATA_UNPRESS_CMD = 16897;
    public static final int AUDIO_CODE_TYPE_G722_1 = 0;
    public static final int AUDIO_CODE_TYPE_G711_MU = 1;
    public static final int AUDIO_CODE_TYPE_G711_A = 2;
    public static final int AUDIO_CODE_TYPE_G723 = 3;
    public static final int AUDIO_CODE_TYPE_MP1L2 = 4;
    public static final int AUDIO_CODE_TYPE_MP2L2 = 5;
    public static final int AUDIO_CODE_TYPE_G726 = 6;
    public static final int AUDIO_CODE_TYPE_AAC = 7;
    public static final int AUDIO_CODE_TYPE_RAW = 99;
    public static final int TTS_START_BASE_CODE = 1000;
    private static TTSClient mTTSClient = null;
    private static String mLoadLibraryAbsPath = null;

    public static void setLoadLibraryAbsPath(String absPath) {
        mLoadLibraryAbsPath = absPath;
    }

    private TTSClient() {
        if (TextUtils.isEmpty((CharSequence)mLoadLibraryAbsPath)) {
            try {
                System.loadLibrary("gnustl_shared");
                System.loadLibrary("hpr");
                System.loadLibrary("TTSClientSDK");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        } else {
            try {
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libgnustl_shared.so");
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libhpr.so");
                System.load(String.valueOf(mLoadLibraryAbsPath) + "libTTSClientSDK.so");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static TTSClient getInstance() {
        if (mTTSClient == null) {
            mTTSClient = new TTSClient();
        }
        return mTTSClient;
    }

    public native boolean initLib();

    public native boolean initCrashReport();

    public native boolean setLogPrint(boolean var1);

    public native boolean finiLib();

    public native int createTalk(TTSClientCallback var1);

    public native boolean destroyTalk(int var1);

    public native int startTalk(int var1, String var2);

    public native int startTalkEx(int var1, String var2);

    public native boolean stopTalk(int var1);

    public native boolean inputAudioData(int var1, byte[] var2, int var3);

    public native boolean inputAudioDataEx(int var1, byte[] var2, int var3, int var4);
}

