/*
 * Decompiled with CFR 0.152.
 */
package io.github.f4pl0;

import io.github.f4pl0.IEXHttpClient;
import io.github.f4pl0.companydata.CompanyData;
import io.github.f4pl0.config.ConfigInjector;
import io.github.f4pl0.config.IEXCloudConfig;
import io.github.f4pl0.equitiesmarketdata.EquitiesMarketData;
import io.github.f4pl0.historicaldata.HistoricalData;
import io.github.f4pl0.reference.Reference;

public class IEXCloudClient {
    public final EquitiesMarketData equitiesMarketData;
    private final Reference reference;
    private final CompanyData companyData;
    private final HistoricalData historicalData;

    private IEXCloudClient(IEXCloudConfig config) {
        ConfigInjector.injectIEXConfiguration(IEXHttpClient.getInstance(), config);
        this.equitiesMarketData = new EquitiesMarketData();
        this.reference = new Reference();
        this.companyData = new CompanyData();
        this.historicalData = new HistoricalData();
    }

    public Reference fetchReferenceData() {
        return this.reference;
    }

    public CompanyData fetchCompanyData() {
        return this.companyData;
    }

    public HistoricalData fetchHistoricalData() {
        return this.historicalData;
    }

    public static class IEXCloudClientBuilder {
        private String publishableToken;
        private String secretToken;
        private String baseEndpoint = "https://api.iex.cloud/v1";

        public IEXCloudClientBuilder setPublishableToken(String publishableToken) {
            this.publishableToken = publishableToken;
            return this;
        }

        public IEXCloudClientBuilder setSecretToken(String secretToken) {
            this.secretToken = secretToken;
            return this;
        }

        public IEXCloudClientBuilder setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public IEXCloudClient build() {
            if (this.publishableToken == null || this.publishableToken.isEmpty()) {
                throw new IllegalArgumentException("Publishable token must be set");
            }
            IEXCloudConfig config = new IEXCloudConfig();
            config.setPublishableToken(this.publishableToken);
            config.setSecretToken(this.secretToken);
            config.setBaseEndpoint(this.baseEndpoint);
            return new IEXCloudClient(config);
        }
    }
}

