/*
 * Decompiled with CFR 0.152.
 */
package io.github.f4pl0.companydata;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.f4pl0.IEXHttpClient;
import io.github.f4pl0.companydata.data.IEXCompanyCeoCompensation;
import io.github.f4pl0.companydata.data.IEXCompanyData;
import io.github.f4pl0.companydata.data.IEXCompanyLogo;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class CompanyData {
    private final IEXHttpClient httpClient = IEXHttpClient.getInstance();
    private final ObjectMapper mapper = new ObjectMapper();

    public IEXCompanyData companyData(@NonNull String symbol) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/company/" + encodedSymbol);
        List data = (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXCompanyData.class));
        return (IEXCompanyData)data.get(0);
    }

    public List<IEXCompanyData> companyData(@NonNull String[] symbols) throws IOException {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        ArrayList<String> encodedSymbols = new ArrayList<String>(symbols.length);
        for (String symbol : symbols) {
            encodedSymbols.add(URLEncoder.encode(symbol, StandardCharsets.UTF_8));
        }
        String joinedSymbols = String.join((CharSequence)",", encodedSymbols);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/company/" + joinedSymbols);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXCompanyData.class));
    }

    public List<IEXCompanyData> companyDataSnapshots(@NonNull String symbol) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/company_historical/" + encodedSymbol);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXCompanyData.class));
    }

    public List<IEXCompanyData> companyDataSnapshots(@NonNull String symbol, int last) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/company_historical/" + encodedSymbol + "?last=" + last);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXCompanyData.class));
    }

    public List<IEXCompanyData> companyDataSnapshots(@NonNull String[] symbols) throws IOException {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        ArrayList<String> encodedSymbols = new ArrayList<String>(symbols.length);
        for (String symbol : symbols) {
            encodedSymbols.add(URLEncoder.encode(symbol, StandardCharsets.UTF_8));
        }
        String joinedSymbols = String.join((CharSequence)",", encodedSymbols);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/company_historical/" + joinedSymbols);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXCompanyData.class));
    }

    public List<IEXCompanyData> companyDataSnapshots(@NonNull String[] symbols, int last) throws IOException {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        ArrayList<String> encodedSymbols = new ArrayList<String>(symbols.length);
        for (String symbol : symbols) {
            encodedSymbols.add(URLEncoder.encode(symbol, StandardCharsets.UTF_8));
        }
        String joinedSymbols = String.join((CharSequence)",", encodedSymbols);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/company_historical/" + joinedSymbols + "?last=" + last);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXCompanyData.class));
    }

    public IEXCompanyCeoCompensation companyCeoCompensation(@NonNull String symbol) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/stock/" + encodedSymbol + "/ceo-compensation");
        return (IEXCompanyCeoCompensation)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), IEXCompanyCeoCompensation.class);
    }

    public IEXCompanyLogo companyLogo(@NonNull String symbol) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/stock/" + encodedSymbol + "/logo");
        return (IEXCompanyLogo)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), IEXCompanyLogo.class);
    }
}

