/*
 * Decompiled with CFR 0.152.
 */
package io.github.f4pl0.equitiesmarketdata;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.f4pl0.IEXHttpClient;
import io.github.f4pl0.equitiesmarketdata.data.IEXDEEP;
import io.github.f4pl0.equitiesmarketdata.data.IEXIntradayEquityPrice;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class EquitiesMarketData {
    private final IEXHttpClient httpClient = IEXHttpClient.getInstance();
    private final ObjectMapper mapper = new ObjectMapper();

    public IEXDEEP getDEEP(@NonNull String symbol) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/iex_deep/" + encodedSymbol);
        List data = (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXDEEP.class));
        return (IEXDEEP)data.get(0);
    }

    public List<IEXDEEP> getDEEP(@NonNull String[] symbols) throws IOException {
        if (symbols == null) {
            throw new NullPointerException("symbols is marked non-null but is null");
        }
        ArrayList<String> encodedSymbols = new ArrayList<String>(symbols.length);
        for (String symbol : symbols) {
            encodedSymbols.add(URLEncoder.encode(symbol, StandardCharsets.UTF_8));
        }
        String joinedSymbols = String.join((CharSequence)",", encodedSymbols);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/iex_deep/" + joinedSymbols);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXDEEP.class));
    }

    public List<IEXIntradayEquityPrice> getIntradayPrices(@NonNull String symbol) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/intraday-prices/" + encodedSymbol);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXIntradayEquityPrice.class));
    }
}

