/*
 * Decompiled with CFR 0.152.
 */
package io.github.f4pl0.historicaldata;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.f4pl0.IEXHttpClient;
import io.github.f4pl0.historicaldata.data.IEXHistoricalEquityPrice;
import io.github.f4pl0.historicaldata.enums.DateRange;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class HistoricalData {
    private final IEXHttpClient httpClient = IEXHttpClient.getInstance();
    private final ObjectMapper mapper = new ObjectMapper();

    public List<IEXHistoricalEquityPrice> historicalEquityPrices(@NonNull String symbol, @NonNull DateRange range, int limit) throws IOException {
        if (symbol == null) {
            throw new NullPointerException("symbol is marked non-null but is null");
        }
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        String encodedSymbol = URLEncoder.encode(symbol, StandardCharsets.UTF_8);
        String requestUri = "/data/core/historical_prices/" + encodedSymbol;
        requestUri = range == DateRange.YEAR_TO_DATE ? requestUri + "?range=" + range.toString() : (limit < 1 ? requestUri + "?range=1" + range.toString() : requestUri + "?range=" + limit + range.toString());
        CloseableHttpResponse response = this.httpClient.execute(requestUri);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXHistoricalEquityPrice.class));
    }
}

