/*
 * Decompiled with CFR 0.152.
 */
package io.github.f4pl0.reference;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.f4pl0.IEXHttpClient;
import io.github.f4pl0.reference.data.IEXForexReferenceData;
import io.github.f4pl0.reference.data.IEXFuturesContractSymbol;
import io.github.f4pl0.reference.data.IEXInternationalExchange;
import io.github.f4pl0.reference.data.IEXMutualFundSymbol;
import io.github.f4pl0.reference.data.IEXOTCSymbol;
import io.github.f4pl0.reference.data.IEXOption;
import io.github.f4pl0.reference.data.IEXSector;
import io.github.f4pl0.reference.data.IEXSecuritySearchResult;
import io.github.f4pl0.reference.data.IEXSecuritySymbol;
import io.github.f4pl0.reference.data.IEXSecurityTag;
import io.github.f4pl0.reference.data.IEXTradeDate;
import io.github.f4pl0.reference.data.IEXTradingSymbol;
import io.github.f4pl0.reference.data.IEXUSExchange;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class Reference {
    private final IEXHttpClient httpClient = IEXHttpClient.getInstance();
    private final ObjectMapper mapper = new ObjectMapper();

    public List<IEXTradingSymbol> dailyIEXTradingSymbols() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_iex_symbols");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXTradingSymbol.class));
    }

    public IEXForexReferenceData forexReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_fx");
        TypeReference<List<IEXForexReferenceData>> typeReference = new TypeReference<List<IEXForexReferenceData>>(this){};
        List forexData = (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (TypeReference)typeReference);
        return (IEXForexReferenceData)forexData.get(0);
    }

    public List<IEXFuturesContractSymbol> futuresReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_futures");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXFuturesContractSymbol.class));
    }

    public List<IEXFuturesContractSymbol> futuresReferenceData(@NonNull String underlying) throws IOException {
        if (underlying == null) {
            throw new NullPointerException("underlying is marked non-null but is null");
        }
        String encodedUnderlying = URLEncoder.encode(underlying, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_futures/" + encodedUnderlying);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXFuturesContractSymbol.class));
    }

    public List<IEXMutualFundSymbol> mutualFundReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_mutual_funds");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXMutualFundSymbol.class));
    }

    public List<IEXOTCSymbol> otcReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_otc");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXOTCSymbol.class));
    }

    public Map<String, List<Date>> optionsReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_options");
        List data = (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, Map.class));
        HashMap<String, List<Date>> parsedData = new HashMap<String, List<Date>>();
        for (Map.Entry entry : ((Map)data.get(0)).entrySet()) {
            List dates = (List)entry.getValue();
            ArrayList<Date> parsedDates = new ArrayList<Date>(dates.size());
            for (String date : dates) {
                try {
                    parsedDates.add(new SimpleDateFormat("yyyyMMdd").parse(date));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            parsedData.put((String)entry.getKey(), parsedDates);
        }
        return parsedData;
    }

    public List<IEXOption> optionsReferenceData(@NonNull String underlying) throws IOException {
        if (underlying == null) {
            throw new NullPointerException("underlying is marked non-null but is null");
        }
        String encodedUnderlying = URLEncoder.encode(underlying, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_options/" + encodedUnderlying);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXOption.class));
    }

    public List<IEXOption> optionsReferenceData(@NonNull String underlying, @NonNull Date expirationDate) throws IOException {
        if (underlying == null) {
            throw new NullPointerException("underlying is marked non-null but is null");
        }
        if (expirationDate == null) {
            throw new NullPointerException("expirationDate is marked non-null but is null");
        }
        String encodedUnderlying = URLEncoder.encode(underlying, StandardCharsets.UTF_8);
        String formattedExpirationDate = new SimpleDateFormat("yyyy-MM-dd").format(expirationDate);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_options/" + encodedUnderlying + "/" + formattedExpirationDate);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXOption.class));
    }

    public List<IEXOption> optionsReferenceData(@NonNull String[] underlying) throws IOException {
        if (underlying == null) {
            throw new NullPointerException("underlying is marked non-null but is null");
        }
        ArrayList<String> encodedUnderlying = new ArrayList<String>(underlying.length);
        for (String underlyingSymbol : underlying) {
            encodedUnderlying.add(URLEncoder.encode(underlyingSymbol, StandardCharsets.UTF_8));
        }
        String joinedUnderlying = String.join((CharSequence)",", encodedUnderlying);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_options/" + joinedUnderlying);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXOption.class));
    }

    public List<IEXOption> optionsReferenceData(@NonNull String[] underlying, @NonNull Date expirationDate) throws IOException {
        if (underlying == null) {
            throw new NullPointerException("underlying is marked non-null but is null");
        }
        if (expirationDate == null) {
            throw new NullPointerException("expirationDate is marked non-null but is null");
        }
        ArrayList<String> encodedUnderlying = new ArrayList<String>(underlying.length);
        for (String underlyingSymbol : underlying) {
            encodedUnderlying.add(URLEncoder.encode(underlyingSymbol, StandardCharsets.UTF_8));
        }
        String joinedUnderlying = String.join((CharSequence)",", encodedUnderlying);
        String formattedExpirationDate = new SimpleDateFormat("yyyy-MM-dd").format(expirationDate);
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_options/" + joinedUnderlying + "/" + formattedExpirationDate);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXOption.class));
    }

    public List<IEXSector> sectorsReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_sectors");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXSector.class));
    }

    public List<IEXSecuritySymbol> securitySymbolsReferenceData() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXSecuritySymbol.class));
    }

    public List<IEXSecurityTag> securityTags() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_tags");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXSecurityTag.class));
    }

    public List<IEXUSExchange> usExchanges() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_exchanges");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXUSExchange.class));
    }

    public IEXTradeDate usNextTradeDate() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/data/core/ref_data_dates/trade/next");
        List dates = (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXTradeDate.class));
        return (IEXTradeDate)dates.get(0);
    }

    public List<IEXSecuritySearchResult> search(@NonNull String fragment) throws IOException {
        if (fragment == null) {
            throw new NullPointerException("fragment is marked non-null but is null");
        }
        String encodedFragment = URLEncoder.encode(fragment, StandardCharsets.UTF_8);
        CloseableHttpResponse response = this.httpClient.execute("/search/" + encodedFragment);
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXSecuritySearchResult.class));
    }

    public List<IEXInternationalExchange> internationalExchanges() throws IOException {
        CloseableHttpResponse response = this.httpClient.execute("/ref-data/exchanges");
        return (List)this.mapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity()), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, IEXInternationalExchange.class));
    }
}

