/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension;

import java.lang.reflect.Method;
import net.serenitybdd.junit5.extension.SerenityJUnitLifecycleAdapterExtension;
import net.thucydides.core.annotations.Manual;
import net.thucydides.core.annotations.ManualTestMarkedAsError;
import net.thucydides.core.annotations.ManualTestMarkedAsFailure;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.steps.StepEventBus;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityManualExtension
implements InvocationInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SerenityManualExtension.class);

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Method testMethod = extensionContext.getRequiredTestMethod();
        if (testMethod.isAnnotationPresent(Manual.class)) {
            try {
                invocation.proceed();
            }
            catch (Exception e) {
                log.error("Exception during test execution on @Manual test will be ignored.", (Throwable)e);
            }
            this.markAsManual(testMethod.getAnnotation(Manual.class), StepEventBus.getEventBus());
        } else {
            invocation.proceed();
        }
    }

    private void markAsManual(Manual manualAnnotation, StepEventBus eventBus) throws Throwable {
        eventBus.testIsManual();
        eventBus.getBaseStepListener().latestTestOutcome().ifPresent(outcome -> {
            outcome.setResult(manualAnnotation.result());
            if (manualAnnotation.result() == TestResult.FAILURE) {
                outcome.setTestFailureMessage(this.manualReasonDeclaredIn(manualAnnotation));
            }
        });
        switch (manualAnnotation.result()) {
            case SUCCESS: {
                return;
            }
            case FAILURE: {
                ManualTestMarkedAsFailure failure = new ManualTestMarkedAsFailure(this.manualReasonDeclaredIn(manualAnnotation));
                eventBus.testFailed((Throwable)failure);
                throw failure;
            }
            case ERROR: 
            case COMPROMISED: 
            case UNSUCCESSFUL: {
                ManualTestMarkedAsError error = new ManualTestMarkedAsError(this.manualReasonDeclaredIn(manualAnnotation));
                eventBus.testFailed((Throwable)error);
                throw error;
            }
            case IGNORED: {
                eventBus.testIgnored();
                this.throwMarkerExceptionForAnAbortedExecutionInJunit5(manualAnnotation);
            }
            case SKIPPED: {
                eventBus.testSkipped();
                this.throwMarkerExceptionForAnAbortedExecutionInJunit5(manualAnnotation);
            }
        }
        eventBus.testPending();
        this.throwMarkerExceptionForAnAbortedExecutionInJunit5(manualAnnotation);
    }

    private void throwMarkerExceptionForAnAbortedExecutionInJunit5(Manual manualAnnotation) {
        throw new SerenityJUnitLifecycleAdapterExtension.ManualTestAbortedException(manualAnnotation.result());
    }

    private String manualReasonDeclaredIn(Manual manualAnnotation) {
        String reason = manualAnnotation.reason();
        return reason == null ? "Manual test failure" : "Manual test failure: " + reason;
    }
}

