/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension;

import java.lang.reflect.Method;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.opentest4j.TestAbortedException;

public class SerenityStepExtension
implements BeforeEachCallback,
InvocationInterceptor {
    public void beforeEach(ExtensionContext context) {
        StepAnnotations.injector().injectScenarioStepsInto(context.getRequiredTestInstance(), StepFactory.getFactory());
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        block2: {
            try {
                invocation.proceed();
            }
            catch (AssertionError assertionError) {
                if (!this.noStepInTheCurrentTestHasFailed()) break block2;
                throw assertionError;
            }
        }
        this.throwStepFailures(extensionContext);
        this.throwStepAssumptionViolations(extensionContext);
    }

    private boolean noStepInTheCurrentTestHasFailed() {
        return !StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    private void throwStepFailures(ExtensionContext extensionContext) throws Throwable {
        BaseStepListener baseStepListener = this.baseStepListener();
        if (baseStepListener.aStepHasFailed()) {
            throw baseStepListener.getTestFailureCause().toException();
        }
    }

    private void throwStepAssumptionViolations(ExtensionContext extensionContext) {
        StepEventBus eventBus = StepEventBus.getEventBus();
        if (eventBus.assumptionViolated()) {
            throw new TestAbortedException(eventBus.getAssumptionViolatedMessage());
        }
    }

    private BaseStepListener baseStepListener() {
        return StepEventBus.getEventBus().getBaseStepListener();
    }
}

