/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extension.page;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Optional;
import net.thucydides.core.annotations.DriverOptions;
import net.thucydides.core.annotations.WithDriver;

public final class TestMethodAnnotations {
    private final Method method;

    private TestMethodAnnotations(Method method) {
        this.method = method;
    }

    public static TestMethodAnnotations forTest(Method method) {
        return new TestMethodAnnotations(method);
    }

    public boolean isDriverSpecified() {
        return this.method.getAnnotation(WithDriver.class) != null;
    }

    public String specifiedDriver() {
        Preconditions.checkArgument((this.isDriverSpecified() ? 1 : 0) != 0);
        return this.method.getAnnotation(WithDriver.class).value();
    }

    public String driverOptions() {
        Preconditions.checkArgument((this.isDriverSpecified() ? 1 : 0) != 0);
        return Optional.ofNullable(this.method.getAnnotation(DriverOptions.class)).map(DriverOptions::value).orElse("");
    }
}

