/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.builder.FactoryTreeBuilder;
import io.github.factoryfx.factory.builder.Scope;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class BranchSelector<R extends FactoryBase<?, R>> {
    private final R root;
    private final FactoryTreeBuilder<?, R, ?> treeBuilder;

    public BranchSelector(R root, FactoryTreeBuilder<?, R, ?> treeBuilder) {
        this.root = root;
        ((FactoryBase)this.root).internal().finalise();
        this.treeBuilder = treeBuilder;
    }

    public BranchSelector(R root) {
        this.root = root;
        ((FactoryBase)this.root).internal().finalise();
        this.treeBuilder = null;
    }

    public BranchSelector(FactoryTreeBuilder<?, R, ?> treeBuilder) {
        this(treeBuilder.buildTree(), treeBuilder);
    }

    public <LB, B extends FactoryBase<LB, R>> Branch<R, LB, B> select(Class<B> factoryClass, String name) {
        if (this.treeBuilder != null && this.treeBuilder.getScope(factoryClass) != Scope.SINGLETON) {
            throw new IllegalArgumentException("can't select prototype");
        }
        for (FactoryBase child : ((FactoryBase)this.root).internal().collectChildrenDeep()) {
            if (!this.matchFactory(child, factoryClass, name)) continue;
            return new Branch(child);
        }
        return null;
    }

    public <LB, B extends FactoryBase<LB, R>> Branch<R, LB, B> select(Class<B> factoryClass) {
        return this.select(factoryClass, null);
    }

    private <LB, B extends FactoryBase<LB, R>> boolean matchFactory(FactoryBase<?, R> factory, Class<B> factoryClass, String name) {
        if (factory.getClass() != factoryClass) {
            return false;
        }
        String treeBuilderName = factory.internal().getTreeBuilderName();
        return Objects.equals(name, treeBuilderName);
    }

    public <LB, B extends FactoryBase<LB, R>> Set<Branch<R, LB, B>> selectPrototype(Class<B> factoryClass, String name) {
        HashSet<Branch<R, LB, B>> branches = new HashSet<Branch<R, LB, B>>();
        for (FactoryBase child : ((FactoryBase)this.root).internal().collectChildrenDeep()) {
            if (!this.matchFactory(child, factoryClass, name)) continue;
            branches.add(new Branch(child));
        }
        return branches;
    }

    public <LB, B extends FactoryBase<LB, R>> Set<Branch<R, LB, B>> selectPrototype(Class<B> factoryClass) {
        return this.selectPrototype(factoryClass, null);
    }

    public static class Branch<R extends FactoryBase<?, R>, L, B extends FactoryBase<L, R>> {
        private final B branchFactory;

        public Branch(B branchFactory) {
            this.branchFactory = branchFactory;
        }

        public Branch<R, L, B> start() {
            List factoriesInCreateAndStartOrder = ((FactoryBase)this.branchFactory).internal().getFactoriesInCreateAndStartOrder();
            factoriesInCreateAndStartOrder.stream().forEach(factoryBase -> factoryBase.internal().start());
            return this;
        }

        public Branch<R, L, B> stop() {
            List factoriesInDestroyOrder = ((FactoryBase)this.branchFactory).internal().getFactoriesInDestroyOrder();
            factoriesInDestroyOrder.stream().forEach(factoryBase -> factoryBase.internal().destroyRemoved());
            return this;
        }

        public L instance() {
            return ((FactoryBase)this.branchFactory).internal().instance();
        }

        public Branch<R, L, B> mock(Function<B, L> mockCreator) {
            ((FactoryBase)this.branchFactory).utility().mock(mockCreator);
            return this;
        }

        public Branch<R, L, B> mock(L mock) {
            ((FactoryBase)this.branchFactory).utility().mock((F f) -> mock);
            return this;
        }

        public B factory() {
            return this.branchFactory;
        }
    }
}

