/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import io.github.factoryfx.factory.AttributeVisitor;
import io.github.factoryfx.factory.DataObjectIdResolver;
import io.github.factoryfx.factory.FactoryEnclosingAttributeVisitor;
import io.github.factoryfx.factory.FactoryTreeBuilderBasedAttributeSetup;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.AttributeChangeListener;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeGroup;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.AttributeMerger;
import io.github.factoryfx.factory.builder.FactoryTreeBuilder;
import io.github.factoryfx.factory.merge.AttributeDiffInfo;
import io.github.factoryfx.factory.merge.MergeResult;
import io.github.factoryfx.factory.metadata.FactoryMetadata;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadata;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import io.github.factoryfx.factory.validation.AttributeValidation;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationError;
import io.github.factoryfx.server.Microservice;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", resolver=DataObjectIdResolver.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FactoryBase<L, R extends FactoryBase<?, R>> {
    @JsonProperty
    UUID id;
    private static final Random r = new Random();
    private static final Logger logger = LoggerFactory.getLogger(FactoryBase.class);
    @JsonIgnore
    private L createdLiveObject;
    @JsonIgnore
    private boolean started = false;
    @JsonIgnore
    boolean needRecreation = false;
    @JsonIgnore
    private L previousLiveObject;
    @JsonProperty
    private String treeBuilderName;
    private FactoryMetadata<R, L, FactoryBase<L, R>> metadata;
    List<FactoryBase<?, R>> collectedTo;
    private Supplier<String> displayTextProvider;
    private List<AttributeValidation<?>> dataValidations;
    FactoryBase<L, R> copy;
    int treeChildrenCounter;
    long backReferencesIterationRun = 0L;
    boolean needReFinalisation = true;
    long rootDeepIterationRun = 0L;
    private Set<FactoryBase<?, ?>> parents;
    private FactoryBase<?, ?> parent;
    R root;
    private Function<List<Attribute<?, ?>>, List<AttributeGroup>> attributeListGroupedSupplier;
    private Function<String, Boolean> matchSearchTextFunction;
    private List<Attribute<?, ?>> displayTextDependencies;
    private Object storeDisplayTextObservable;
    FactoryTreeBuilderBasedAttributeSetup<R, ?> factoryTreeBuilderBasedAttributeSetup;
    private long loopDetectorIterationRun;
    private List<FactoryBase<?, R>> addedToGetFactoriesInDestroyOrder;
    private List<FactoryBase<?, R>> addedToGetFactoriesInCreateAndStartOrder;
    @JsonIgnore
    List<FactoryBase<?, R>> finalisedChildrenFlat;
    List<FactoryBase<?, R>> addedTo;
    Microservice<?, R, ?> microservice;
    FactoryTreeBuilder<?, R, ?> factoryTreeBuilder;
    @JsonIgnore
    private boolean createLog;
    @JsonIgnore
    private boolean recreateLog;
    @JsonIgnore
    private boolean updateLog;
    @JsonIgnore
    private boolean startLog;
    @JsonIgnore
    private boolean destroyLog;
    private Long logId;
    private static final long PRINTED_COUNTER_LIMIT = 500L;
    Supplier<L> creator = null;
    Function<FactoryBase<L, R>, L> creatorMock = null;
    Consumer<L> updater = null;
    Function<L, L> reCreatorWithPreviousLiveObject = null;
    Consumer<L> starterWithNewLiveObject = null;
    Consumer<L> destroyerWithPreviousLiveObject = null;

    public UUID getId() {
        if (this.id == null) {
            this.id = new UUID(r.nextLong(), r.nextLong());
        }
        return this.id;
    }

    public boolean idEquals(FactoryBase<?, ?> factory) {
        return this.getId().equals(factory.getId());
    }

    private FactoryMetadata<R, L, FactoryBase<L, R>> getFactoryMetadata() {
        if (this.metadata == null) {
            this.metadata = FactoryMetadataManager.getMetadata(this.getClass());
        }
        return this.metadata;
    }

    private void visitAttributesFlat(AttributeVisitor consumer) {
        this.getFactoryMetadata().visitAttributesFlat(this, consumer);
    }

    private void visitFactoryEnclosingAttributesFlat(FactoryEnclosingAttributeVisitor<R> consumer) {
        this.getFactoryMetadata().visitFactoryEnclosingAttributesFlat(this, consumer);
    }

    private <V> void visitAttributesForCopy(FactoryBase<?, R> data, BiCopyAttributeVisitor<V> consumer) {
        this.getFactoryMetadata().visitAttributesForCopy(this, data, consumer);
    }

    private <V> void visitAttributesForMatch(FactoryBase<?, R> data, AttributeMatchVisitor<V> consumer) {
        this.getFactoryMetadata().visitAttributesForMatch(this, data, consumer);
    }

    private <V> void visitAttributesTripleFlat(FactoryBase<L, R> other1, FactoryBase<L, R> other2, TriAttributeVisitor<V> consumer) {
        this.getFactoryMetadata().visitAttributesTripleFlat(this, other1, other2, consumer);
    }

    private Map<UUID, FactoryBase<?, R>> collectChildDataMap() {
        this.ensureTreeIsFinalised();
        LinkedHashMap result = this.treeChildrenCounter > 0 ? Maps.newLinkedHashMapWithExpectedSize((int)this.treeChildrenCounter) : new LinkedHashMap();
        for (FactoryBase<?, R> child : this.collectChildrenDeep()) {
            result.put(child.getId(), child);
        }
        return result;
    }

    private List<FactoryBase<?, R>> collectChildrenDeep() {
        this.ensureTreeIsFinalised();
        ArrayList result = new ArrayList();
        ArrayDeque stack = new ArrayDeque();
        stack.push(this);
        while (!stack.isEmpty()) {
            FactoryBase factory = (FactoryBase)stack.pop();
            result.add(factory);
            factory.collectedTo = result;
            for (FactoryBase<?, R> child : factory.finalisedChildrenFlat) {
                if (child.collectedTo == result) continue;
                stack.push(child);
            }
        }
        for (FactoryBase factoryBase : result) {
            factoryBase.collectedTo = null;
        }
        return result;
    }

    private Set<FactoryBase<?, R>> collectionChildrenDeepFromNonFinalizedTree() {
        HashSet result = new HashSet();
        ArrayDeque<FactoryBase> stack = new ArrayDeque<FactoryBase>();
        stack.push(this);
        while (!stack.isEmpty()) {
            FactoryBase factory = (FactoryBase)stack.pop();
            if (!result.add(factory)) continue;
            factory.collectionChildrenDeepFromNonFinalizedTreeGenericWorkaround(stack::push);
        }
        return result;
    }

    private void collectionChildrenDeepFromNonFinalizedTreeGenericWorkaround(Consumer<FactoryBase<?, R>> consumer) {
        this.getFactoryMetadata().visitChildFactoriesAndViewsFlat(this, consumer, false);
    }

    private FactoryBase<L, R> newCopyInstance(FactoryBase<L, R> data) {
        return this.getFactoryMetadata().newCopyInstance(data);
    }

    private void fixDuplicateObjects() {
        boolean needIdFixing = false;
        List<FactoryBase<?, R>> childrenDeep = this.collectChildrenDeep();
        HashMap idToDataMap = Maps.newHashMapWithExpectedSize((int)childrenDeep.size());
        for (FactoryBase<?, R> child : childrenDeep) {
            if (idToDataMap.put(child.id, child) == null) continue;
            needIdFixing = true;
            break;
        }
        if (needIdFixing) {
            for (FactoryBase<?, R> child : childrenDeep) {
                FactoryBase factory = (FactoryBase)idToDataMap.get(child.getId());
                if (factory != null) {
                    if (child.createdLiveObject == null) continue;
                    idToDataMap.put(child.getId(), child);
                    continue;
                }
                idToDataMap.put(child.getId(), child);
            }
            for (FactoryBase factory : idToDataMap.values()) {
                factory.visitFactoryEnclosingAttributesFlat((attributeVariableName, attribute) -> attribute.internal_fixDuplicateObjects(idToDataMap));
            }
            this.needReFinalisation();
        }
    }

    @JsonIgnore
    private String getDisplayText() {
        if (this.displayTextProvider == null) {
            return this.getClass().getSimpleName();
        }
        return this.displayTextProvider.get();
    }

    private void setDisplayTextProvider(Supplier<String> displayTextProvider) {
        this.displayTextProvider = displayTextProvider;
    }

    private List<ValidationError> validateFlat() {
        ArrayList<ValidationError> result = new ArrayList<ValidationError>();
        Map<Attribute<?, ?>, List<ValidationError>> attributeListMap = this.validateFlatMapped();
        for (Map.Entry<Attribute<?, ?>, List<ValidationError>> entry : attributeListMap.entrySet()) {
            result.addAll((Collection<ValidationError>)entry.getValue());
        }
        return result;
    }

    private Map<Attribute<?, ?>, List<ValidationError>> validateFlatMapped() {
        HashMap result = new HashMap();
        this.visitAttributesFlat((attributeVariableName, attribute) -> {
            ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
            result.put(attribute, validationErrors);
            validationErrors.addAll(attribute.internal_validate(this, attributeVariableName));
        });
        if (this.dataValidations != null) {
            for (AttributeValidation<?> validation : this.dataValidations) {
                Map<Attribute<?, ?>, List<ValidationError>> validateResult = validation.validate(this);
                for (Map.Entry<Attribute<?, ?>, List<ValidationError>> entry : validateResult.entrySet()) {
                    ((List)result.get(entry.getKey())).addAll((Collection)entry.getValue());
                }
            }
        }
        return result;
    }

    private <T> void addValidation(Validation<T> validation, Attribute<?, ?> ... dependencies) {
        if (this.dataValidations == null) {
            this.dataValidations = new ArrayList();
        }
        for (Attribute<?, ?> dependency : dependencies) {
            this.dataValidations.add(new AttributeValidation<T>(validation, dependency));
        }
    }

    private void merge(FactoryBase<L, R> originalValue, FactoryBase<L, R> newValue, MergeResult<R> mergeResult, Function<String, Boolean> permissionChecker) {
        this.visitAttributesTripleFlat(originalValue, newValue, (attributeName, currentMerger, originalMerger, newMerger) -> {
            boolean currentMergerMatchNewMerger;
            boolean currentMergerMatchOriginalMerger;
            boolean newMergerMatchOriginalMerger = newMerger.internal_mergeMatch(originalMerger);
            if (this.attributeHasMergeConflict(newMergerMatchOriginalMerger, currentMergerMatchOriginalMerger = currentMerger.internal_mergeMatch(originalMerger), currentMergerMatchNewMerger = currentMerger.internal_mergeMatch(newMerger))) {
                mergeResult.addConflictInfo(new AttributeDiffInfo(attributeName, this.getId()));
            } else if (this.attributeIsMergeable(currentMergerMatchOriginalMerger, currentMergerMatchNewMerger)) {
                AttributeDiffInfo attributeDiffInfo = new AttributeDiffInfo(attributeName, this.getId());
                if (currentMerger.internal_hasWritePermission(permissionChecker)) {
                    mergeResult.addMergeInfo(attributeDiffInfo);
                    mergeResult.addMergeExecutions(() -> currentMerger.internal_merge(newMerger.get()), this);
                } else {
                    mergeResult.addPermissionViolationInfo(attributeDiffInfo);
                }
            }
        });
    }

    private boolean attributeHasMergeConflict(boolean newMergerMatchOriginalMerger, boolean currentMergerMatchOriginalMerger, boolean currentMergerMatchNewMerger) {
        return !newMergerMatchOriginalMerger && !currentMergerMatchOriginalMerger && !currentMergerMatchNewMerger;
    }

    private boolean attributeIsMergeable(boolean currentMergerMatchOriginalMerger, boolean currentMergerMatchNewMerger) {
        return currentMergerMatchOriginalMerger && !currentMergerMatchNewMerger;
    }

    private <F extends FactoryBase<L, R>> F semanticCopy() {
        FactoryBase<L, R> result = this.newCopyInstance(this);
        this.visitAttributesForCopy(result, (original, copy) -> {
            original.internal_semanticCopyTo(copy);
            return true;
        });
        return (F)result;
    }

    private <T extends FactoryBase<?, ?>> T copyOneLevelDeep() {
        return this.copy(1);
    }

    private <T extends FactoryBase<?, ?>> T copyZeroLevelDeep() {
        return this.copy(0);
    }

    private <T extends FactoryBase<?, ?>> T copy() {
        return this.copy(Integer.MAX_VALUE);
    }

    private <T extends FactoryBase<?, ?>> T copy(int level) {
        ArrayList<FactoryBase<Object, Object>> oldDataList = this.treeChildrenCounter > 0 ? new ArrayList(this.treeChildrenCounter) : new ArrayList();
        Object copy = this.copyDeep(0, level, oldDataList, null, this);
        ((FactoryBase)copy).treeChildrenCounter = oldDataList.size();
        for (FactoryBase<?, ?> oldData : oldDataList) {
            oldData.copy = null;
        }
        ((FactoryBase)copy).needReFinalisation = true;
        return (T)copy;
    }

    private <F extends FactoryBase<? extends L, R>> F copyDeep(int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, R> parent, R root) {
        if (level > maxLevel) {
            return null;
        }
        if (this.copy == null) {
            this.copy = this.newCopyInstance(this);
            if (this.id == null) {
                this.getId();
            }
            this.copy.id = this.id;
            this.visitAttributesForCopy(this.copy, (thisAttribute, copyAttribute) -> {
                thisAttribute.internal_copyTo(copyAttribute, level + 1, maxLevel, oldData, this, (FactoryBase<?, ?>)root);
                copyAttribute.internal_addBackReferences(root.copy, this.copy);
                return true;
            });
            oldData.add(this);
            this.copy.root = ((FactoryBase)root).copy;
            this.copy.creatorMock = this.creatorMock;
        }
        return (F)this.copy;
    }

    private void endEditingDeepFromRoot() {
        for (FactoryBase<?, R> data : this.collectChildrenDeep()) {
            data.visitAttributesFlat((attributeVariableName, attribute) -> attribute.internal_endUsage());
        }
    }

    private void endEditingFlat() {
        this.visitAttributesFlat((attributeVariableName, attribute) -> attribute.internal_endUsage());
    }

    private void ensureTreeIsFinalised() {
        if (this.root != null) {
            ((FactoryBase)this.root).finalise();
        }
    }

    private void finalise() {
        FactoryBase root = this;
        if (!this.needReFinalisation) {
            return;
        }
        ArrayDeque stack = new ArrayDeque();
        stack.push(root);
        long backReferencesIterationRun = root.backReferencesIterationRun + 1L;
        while (!stack.isEmpty()) {
            FactoryBase factory = (FactoryBase)stack.pop();
            factory.backReferencesIterationRun = backReferencesIterationRun;
            factory.root = root;
            ++((FactoryBase)factory.root).treeChildrenCounter;
            factory.getFactoryMetadata().addBackReferencesAndReferenceClassToAttributesUnsafe(factory, root);
            factory.finalizeChildren();
            for (FactoryBase<?, R> child : factory.finalisedChildrenFlat) {
                if (child.backReferencesIterationRun != backReferencesIterationRun) {
                    child.resetParents();
                    stack.push(child);
                }
                child.addParent(factory);
            }
        }
        this.needReFinalisation = false;
    }

    private void needReFinalisation() {
        ((FactoryBase)this.root).needReFinalisation = true;
    }

    private void setRootDeep(R root) {
        ArrayDeque stack = new ArrayDeque();
        stack.push(this);
        long rootDeepIterationRun = ((FactoryBase)root).rootDeepIterationRun + 1L;
        while (!stack.isEmpty()) {
            FactoryBase factory = (FactoryBase)stack.pop();
            factory.rootDeepIterationRun = rootDeepIterationRun;
            factory.root = root;
            factory.getFactoryMetadata().addBackReferencesAndReferenceClassToAttributesUnsafe(factory, root);
            factory.finalizeChildren();
            for (FactoryBase<?, R> child : factory.finalisedChildrenFlat) {
                if (child.rootDeepIterationRun == rootDeepIterationRun) continue;
                stack.push(child);
            }
        }
    }

    private void addParent(FactoryBase<?, ?> parent) {
        if (this.parent == null || this.parent == parent) {
            this.parent = parent;
        } else if (this.parents == null) {
            this.parents = new HashSet();
            this.parents.add(this.parent);
            this.parents.add(parent);
        } else {
            this.parents.add(parent);
        }
    }

    private void resetParents() {
        this.parents = null;
        this.parent = null;
    }

    @JsonIgnore
    private Set<FactoryBase<?, ?>> getParents() {
        this.ensureTreeIsFinalised();
        if (this.parents == null) {
            if (this.parent == null) {
                return Collections.emptySet();
            }
            return Set.of(this.parent);
        }
        return this.parents;
    }

    private R getRoot() {
        return this.root;
    }

    private void setAttributeListGroupedSupplier(Function<List<Attribute<?, ?>>, List<AttributeGroup>> attributeListGroupedSupplier) {
        this.attributeListGroupedSupplier = attributeListGroupedSupplier;
    }

    private List<AttributeGroup> attributeListGrouped() {
        if (this.attributeListGroupedSupplier == null) {
            return Collections.singletonList(new AttributeGroup("Data", this.attributeList()));
        }
        return this.attributeListGroupedSupplier.apply(this.attributeList());
    }

    private List<Attribute<?, ?>> attributeList() {
        ArrayList result = new ArrayList();
        this.visitAttributesFlat((attributeVariableName, attribute) -> result.add(attribute));
        return result;
    }

    private void setMatchSearchTextFunction(Function<String, Boolean> matchSearchTextFunction) {
        this.matchSearchTextFunction = matchSearchTextFunction;
    }

    private boolean matchSearchText(String text) {
        if (this.matchSearchTextFunction == null) {
            return Strings.isNullOrEmpty((String)text) || Strings.nullToEmpty((String)this.getDisplayText()).toLowerCase().contains(text.toLowerCase());
        }
        return this.matchSearchTextFunction.apply(text);
    }

    private void setDisplayTextDependencies(List<Attribute<?, ?>> displayTextDependencies) {
        this.displayTextDependencies = displayTextDependencies;
    }

    private void addDisplayTextListeners(AttributeChangeListener attributeChangeListener) {
        if (this.displayTextDependencies != null) {
            for (Attribute<?, ?> attribute : this.displayTextDependencies) {
                attribute.internal_addListener(attributeChangeListener);
            }
        }
    }

    private void storeDisplayTextObservable(Object simpleStringProperty) {
        this.storeDisplayTextObservable = simpleStringProperty;
    }

    protected DataConfiguration config() {
        return new DataConfiguration(this);
    }

    public Internal<L, R> internal() {
        return new Internal(this);
    }

    private void serFactoryTreeBuilderBasedAttributeSetupForRoot(FactoryTreeBuilderBasedAttributeSetup<R, ?> factoryTreeBuilderBasedAttributeSetup) {
        this.factoryTreeBuilderBasedAttributeSetup = factoryTreeBuilderBasedAttributeSetup;
    }

    private DataStorageMetadataDictionary createDataStorageMetadataDictionaryFromRoot() {
        HashMap dataClassesToCount = new HashMap();
        for (FactoryBase<?, R> data : this.collectChildrenDeep()) {
            Long counter = (Long)dataClassesToCount.get(data.getClass());
            if (counter == null) {
                counter = 0L;
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
            dataClassesToCount.put(data.getClass(), counter);
        }
        ArrayList<DataStorageMetadata> dataStorageMetadataList = new ArrayList<DataStorageMetadata>();
        ArrayList sortedClasses = new ArrayList(dataClassesToCount.keySet());
        sortedClasses.sort(Comparator.comparing(Class::getName));
        for (Class clazz : sortedClasses) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            dataStorageMetadataList.add(FactoryMetadataManager.getMetadata(clazz).createDataStorageMetadata((Long)dataClassesToCount.get(clazz)));
        }
        sortedClasses.sort(Comparator.comparing(Class::getName));
        return new DataStorageMetadataDictionary(dataStorageMetadataList, this.getClass().getName());
    }

    private List<FactoryBase<?, ?>> getPathFromRoot() {
        ArrayList result = new ArrayList();
        FactoryBase<?, ?> current = this;
        while (!current.getParents().isEmpty()) {
            FactoryBase<?, ?> parent = current.getParents().iterator().next();
            result.add(parent);
            current = parent;
        }
        Collections.reverse(result);
        return result;
    }

    private void assertRoot() {
        if (this.root != this) {
            throw new IllegalStateException("can only be called from root this.root=" + this.root);
        }
    }

    private L instance() {
        if (this.needRecreation) {
            this.previousLiveObject = this.createdLiveObject;
            this.createdLiveObject = this.reCreate(this.previousLiveObject);
            this.needRecreation = false;
            if (this.needsCreatePropagation()) {
                this.started = false;
            }
        } else if (this.createdLiveObject == null) {
            this.createdLiveObject = this.create();
        }
        return this.createdLiveObject;
    }

    L createTemplateMethod() {
        if (this.creator == null) {
            throw new IllegalStateException("no creator defined: " + this.getClass());
        }
        return this.creator.get();
    }

    private L create() {
        if (this.creatorMock != null) {
            return this.creatorMock.apply(this);
        }
        this.logCreate();
        return this.createTemplateMethod();
    }

    private L reCreate(L previousLiveObject) {
        if (this.updater != null) {
            this.updater.accept(previousLiveObject);
            this.logUpdate();
            return previousLiveObject;
        }
        if (this.reCreatorWithPreviousLiveObject != null) {
            this.logRecreate();
            return this.reCreatorWithPreviousLiveObject.apply(previousLiveObject);
        }
        this.logRecreate();
        return this.createTemplateMethod();
    }

    private void start() {
        if (!this.started) {
            this.logStart();
            if (this.starterWithNewLiveObject != null && this.createdLiveObject != null) {
                this.starterWithNewLiveObject.accept(this.createdLiveObject);
            }
            this.started = true;
        }
    }

    private void destroyUpdated() {
        if (this.previousLiveObject != null && this.destroyerWithPreviousLiveObject != null && this.needsCreatePropagation()) {
            this.destroyerWithPreviousLiveObject.accept(this.previousLiveObject);
            this.logDestroy();
        }
        this.previousLiveObject = null;
    }

    private void destroyRemoved() {
        if (this.createdLiveObject != null && this.destroyerWithPreviousLiveObject != null) {
            this.destroyerWithPreviousLiveObject.accept(this.createdLiveObject);
            this.logDestroy();
        }
        this.createdLiveObject = null;
    }

    private void determineRecreationNeed(Set<FactoryBase<?, R>> changedFactories) {
        for (FactoryBase<?, R> factory : changedFactories) {
            factory.needRecreation = true;
            if (!factory.needsCreatePropagation()) continue;
            Set<FactoryBase<?, ?>> parents = factory.internal().getParents();
            while (!parents.isEmpty()) {
                HashSet grandParents = new HashSet();
                for (FactoryBase<?, ?> parent : parents) {
                    parent.needRecreation = true;
                    if (!parent.needsCreatePropagation()) continue;
                    grandParents.addAll(parent.internal().getParents());
                }
                parents = grandParents;
            }
        }
    }

    private boolean needsCreatePropagation() {
        return this.updater == null;
    }

    private void loopDetector() {
        this.ensureTreeIsFinalised();
        long iterationRun = this.loopDetectorIterationRun + 1L;
        try {
            this.loopDetector(iterationRun);
        }
        finally {
            this.loopDetectorIterationRun = iterationRun;
        }
    }

    private void loopDetector(long iterationRun) {
        if (iterationRun == this.loopDetectorIterationRun) {
            throw new IllegalStateException("Factories contains a cycle, circular dependencies are not supported cause it indicates a design flaw.");
        }
        this.loopDetectorIterationRun = iterationRun;
        for (FactoryBase<?, R> child : this.finalisedChildrenFlat) {
            child.loopDetector(iterationRun);
        }
        this.loopDetectorIterationRun = -1L;
    }

    private List<FactoryBase<?, R>> getFactoriesInDestroyOrder() {
        this.ensureTreeIsFinalised();
        ArrayList result = this.treeChildrenCounter > 0 ? new ArrayList(this.treeChildrenCounter) : new ArrayList();
        result.add(this);
        this.getFactoriesInDestroyOrder(this, result);
        for (FactoryBase factoryBase : result) {
            factoryBase.addedToGetFactoriesInDestroyOrder = null;
        }
        return result;
    }

    private void getFactoriesInDestroyOrder(FactoryBase<?, R> factory, List<FactoryBase<?, R>> result) {
        int size = result.size();
        for (FactoryBase<?, R> child : factory.finalisedChildrenFlat) {
            if (child.addedToGetFactoriesInDestroyOrder == result) continue;
            result.add(child);
            child.addedToGetFactoriesInDestroyOrder = result;
        }
        for (int i = size; i < result.size(); ++i) {
            this.getFactoriesInDestroyOrder(result.get(i), result);
        }
    }

    private List<FactoryBase<?, R>> getFactoriesInCreateAndStartOrder() {
        this.ensureTreeIsFinalised();
        ArrayList result = this.treeChildrenCounter > 0 ? new ArrayList(this.treeChildrenCounter) : new ArrayList();
        this.getFactoriesInCreateAndStartOrder(this, result);
        for (FactoryBase factoryBase : result) {
            factoryBase.addedToGetFactoriesInCreateAndStartOrder = null;
        }
        return result;
    }

    private void getFactoriesInCreateAndStartOrder(FactoryBase<?, R> factory, List<FactoryBase<?, R>> result) {
        for (FactoryBase<?, R> child : factory.finalisedChildrenFlat) {
            if (child.addedToGetFactoriesInCreateAndStartOrder == result) continue;
            child.addedToGetFactoriesInCreateAndStartOrder = result;
            this.getFactoriesInCreateAndStartOrder(child, result);
        }
        result.add(factory);
    }

    void finalizeChildren() {
        this.finalisedChildrenFlat = new ArrayList();
        this.getFactoryMetadata().visitChildFactoriesAndViewsFlat(this, child -> {
            if (child != null && child.addedTo != this.finalisedChildrenFlat) {
                this.finalisedChildrenFlat.add((FactoryBase<?, R>)child);
                child.addedTo = this.finalisedChildrenFlat;
            }
        }, true);
        for (FactoryBase<?, R> child2 : this.finalisedChildrenFlat) {
            child2.addedTo = null;
        }
    }

    private String debugInfo() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ID:\n  ");
            stringBuilder.append(this.getId());
            stringBuilder.append("\nAttributes:\n");
            this.internal().visitAttributesFlat((attributeVariableName, attribute) -> stringBuilder.append("  ").append(attribute.internal_getPreferredLabelText(Locale.ENGLISH)).append(": ").append(attribute.getDisplayText()).append("\n"));
            return stringBuilder.toString().trim();
        }
        catch (Exception e) {
            return "can't create debuginfo text cause:\n" + Throwables.getStackTraceAsString((Throwable)e);
        }
    }

    private void setMicroservice(Microservice<?, R, ?> microservice) {
        this.microservice = microservice;
    }

    private Microservice<?, R, ?> getMicroservice() {
        return ((FactoryBase)this.getRoot()).microservice;
    }

    private void setFactoryTreeBuilder(FactoryTreeBuilder<?, R, ?> factoryTreeBuilder) {
        this.factoryTreeBuilder = factoryTreeBuilder;
    }

    private FactoryTreeBuilder<?, R, ?> getFactoryTreeBuilder() {
        return ((FactoryBase)this.getRoot()).factoryTreeBuilder;
    }

    private void logCreate() {
        this.createLog = true;
    }

    private void logRecreate() {
        this.recreateLog = true;
    }

    private void logUpdate() {
        this.updateLog = true;
    }

    private void logStart() {
        this.startLog = true;
    }

    private void logDestroy() {
        this.destroyLog = true;
    }

    private void resetLog() {
        this.createLog = false;
        this.recreateLog = false;
        this.startLog = false;
        this.destroyLog = false;
        this.updateLog = false;
        this.logId = null;
    }

    private void logDisplayText(StringBuilder stringBuilder) {
        this.ensureTreeIsFinalised();
        PrintedCounter printedCounter = new PrintedCounter();
        stringBuilder.append("CREATE:+ REUSE:= RECREATE:<> START:^ DESTROY:- UPDATE:~\n");
        this.logDisplayTextDeep(stringBuilder, 0L, "", true, printedCounter);
        if (printedCounter.limitReached()) {
            stringBuilder.append("... (aborted log after 500 factories)");
        }
    }

    private void logDisplayTextDeep(StringBuilder stringBuilder, long deep, String prefix, boolean isTail, PrintedCounter printedCounter) {
        if (printedCounter.limitReached()) {
            return;
        }
        if (deep > 0L) {
            stringBuilder.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        }
        printedCounter.inc();
        if (this.logId == null) {
            this.logId = printedCounter.printedCounter;
        }
        stringBuilder.append(this.getFactoryDescription());
        stringBuilder.append(" lifecycle: ");
        stringBuilder.append(this.eventsDisplayText());
        stringBuilder.append("\n");
        int counter = 0;
        for (FactoryBase<?, R> child : this.finalisedChildrenFlat) {
            child.logDisplayTextDeep(stringBuilder, deep + 1L, prefix + (isTail ? "    " : "\u2502   "), counter == this.finalisedChildrenFlat.size() - 1, printedCounter);
            ++counter;
        }
    }

    private String logStartDisplayTextDeep() {
        StringBuilder stringBuilder = new StringBuilder("\n");
        stringBuilder.append("Application started:\n");
        this.logDisplayText(stringBuilder);
        return stringBuilder.toString();
    }

    private String logUpdateDisplayTextDeep() {
        StringBuilder stringBuilder = new StringBuilder("\n");
        stringBuilder.append("Application updated:\n");
        this.logDisplayText(stringBuilder);
        return stringBuilder.toString();
    }

    @JsonIgnore
    private String getFactoryDescription() {
        Object displayText = "";
        if (this.displayTextProvider != null) {
            displayText = this.getDisplayText() + ", ";
        }
        return this.getClass().getSimpleName() + "(" + (String)displayText + "logId:" + this.logId + ")";
    }

    private String eventsDisplayText() {
        StringJoiner sj = new StringJoiner(",");
        if (this.createLog) {
            sj.add("+");
        }
        if (!(this.recreateLog || this.updateLog || this.startLog)) {
            sj.add("=");
        }
        if (this.recreateLog) {
            sj.add("<>");
        }
        if (this.startLog) {
            sj.add("^");
        }
        if (this.destroyLog) {
            sj.add("-");
        }
        if (this.updateLog) {
            sj.add("~");
        }
        return sj.toString();
    }

    void setCreator(Supplier<L> creator) {
        this.creator = creator;
    }

    private void setReCreator(Function<L, L> reCreatorWithPreviousLiveObject) {
        this.reCreatorWithPreviousLiveObject = reCreatorWithPreviousLiveObject;
    }

    private void setUpdater(Consumer<L> updater) {
        this.updater = updater;
    }

    private void setStarter(Consumer<L> starterWithNewLiveObject) {
        this.starterWithNewLiveObject = starterWithNewLiveObject;
    }

    private void setDestroyer(Consumer<L> destroyerWithPreviousLiveObject) {
        this.destroyerWithPreviousLiveObject = destroyerWithPreviousLiveObject;
    }

    private void mock(Function<FactoryBase<L, R>, L> creatorMock) {
        this.creatorMock = creatorMock;
    }

    private Attribute<?, ?> getAttribute(final String attributeVariableNameParam) {
        final Attribute[] result = new Attribute[1];
        this.visitAttributesFlat(new AttributeVisitor(){

            @Override
            public void accept(String attributeVariableName, Attribute<?, ?> attribute) {
                if (attributeVariableName.equals(attributeVariableNameParam)) {
                    result[0] = attribute;
                }
            }
        });
        return result[0];
    }

    protected LifeCycleConfig<L, R> configLifeCycle() {
        return new LifeCycleConfig(this);
    }

    public UtilityFactory<L, R> utility() {
        return new UtilityFactory(this);
    }

    public static class UtilityFactory<L, R extends FactoryBase<?, R>> {
        private final FactoryBase<L, R> factory;

        public UtilityFactory(FactoryBase<L, R> factory) {
            this.factory = factory;
        }

        public Microservice<?, R, ?> getMicroservice() {
            return this.factory.getMicroservice();
        }

        public FactoryTreeBuilder<?, R, ?> getFactoryTreeBuilder() {
            return this.factory.getFactoryTreeBuilder();
        }

        public R getRoot() {
            return this.factory.getRoot();
        }

        public <F extends FactoryBase<L, R>> F semanticCopy() {
            return this.factory.semanticCopy();
        }

        public <T extends FactoryBase<?, ?>> T copy() {
            return this.factory.copy();
        }

        public <F extends FactoryBase<L, R>> void mock(Function<F, L> creatorMock) {
            this.factory.mock((FactoryBase<L, R> factory) -> creatorMock.apply(factory));
        }
    }

    public static class LifeCycleConfig<L, R extends FactoryBase<?, R>> {
        private final FactoryBase<L, R> factory;

        public LifeCycleConfig(FactoryBase<L, R> factory) {
            this.factory = factory;
        }

        public void setCreator(Supplier<L> creator) {
            this.factory.setCreator(creator);
        }

        public void setReCreator(Function<L, L> reCreatorWithPreviousLiveObject) {
            this.factory.setReCreator(reCreatorWithPreviousLiveObject);
        }

        public void setUpdater(Consumer<L> updater) {
            this.factory.setUpdater(updater);
        }

        public void setStarter(Consumer<L> starterWithNewLiveObject) {
            this.factory.setStarter(starterWithNewLiveObject);
        }

        public void setDestroyer(Consumer<L> destroyerWithPreviousLiveObject) {
            this.factory.setDestroyer(destroyerWithPreviousLiveObject);
        }
    }

    private static class PrintedCounter {
        private long printedCounter;

        private PrintedCounter() {
        }

        public void inc() {
            ++this.printedCounter;
        }

        public boolean limitReached() {
            return this.printedCounter >= 500L;
        }
    }

    public static class Internal<L, R extends FactoryBase<?, R>> {
        private final FactoryBase<L, R> factory;

        public Internal(FactoryBase<L, R> factory) {
            this.factory = factory;
        }

        public boolean matchSearchText(String newValue) {
            return this.factory.matchSearchText(newValue);
        }

        public <V> void visitAttributesForMatch(FactoryBase<?, R> modelBase, AttributeMatchVisitor<V> consumer) {
            this.factory.visitAttributesForMatch(modelBase, consumer);
        }

        public void visitAttributesFlat(AttributeVisitor consumer) {
            this.factory.visitAttributesFlat(consumer);
        }

        public List<AttributeGroup> attributeListGrouped() {
            return this.factory.attributeListGrouped();
        }

        public Map<UUID, FactoryBase<?, R>> collectChildFactoryMap() {
            this.factory.assertRoot();
            return this.factory.collectChildDataMap();
        }

        public List<FactoryBase<?, R>> collectChildrenDeep() {
            return this.factory.collectChildrenDeep();
        }

        public Set<FactoryBase<?, R>> collectionChildrenDeepFromNonFinalizedTree() {
            return this.factory.collectionChildrenDeepFromNonFinalizedTree();
        }

        public void fixDuplicateFactories() {
            this.factory.assertRoot();
            this.factory.fixDuplicateObjects();
        }

        public String getDisplayText() {
            return this.factory.getDisplayText();
        }

        public void storeDisplayTextObservable(Object simpleStringProperty) {
            this.factory.storeDisplayTextObservable(simpleStringProperty);
        }

        public Object getDisplayTextObservable() {
            return this.factory.storeDisplayTextObservable;
        }

        public List<ValidationError> validateFlat() {
            return this.factory.validateFlat();
        }

        public <F extends FactoryBase<L, R>> void merge(F originalValue, F newValue, MergeResult<R> mergeResult, Function<String, Boolean> permissionChecker) {
            this.factory.merge(originalValue, newValue, mergeResult, permissionChecker);
        }

        public List<FactoryBase<?, ?>> getPathFromRoot() {
            return this.factory.getPathFromRoot();
        }

        public <T extends FactoryBase<?, ?>> T copy() {
            return this.factory.copy();
        }

        public <T extends FactoryBase<L, R>> T copyOneLevelDeep() {
            return this.factory.copyOneLevelDeep();
        }

        public <T extends FactoryBase<?, ?>> T copyZeroLevelDeep() {
            return this.factory.copyZeroLevelDeep();
        }

        public <F extends FactoryBase<L, R>> F copyDeep(int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
            return this.factory.copyDeep(level, maxLevel, oldData, parent, root);
        }

        public <T extends FactoryBase<L, R>> T finalise() {
            this.factory.finalise();
            return (T)this.factory;
        }

        public void serFactoryTreeBuilderBasedAttributeSetupForRoot(FactoryTreeBuilderBasedAttributeSetup<R, ?> setup) {
            this.factory.serFactoryTreeBuilderBasedAttributeSetupForRoot(setup);
        }

        public void endEditingDeepFromRoot() {
            this.factory.endEditingDeepFromRoot();
        }

        public void endEditingFlat() {
            this.factory.endEditingFlat();
        }

        @Deprecated
        public FactoryBase<?, ?> getParent() {
            if (this.factory.getParents().isEmpty()) {
                return null;
            }
            return this.factory.getParents().iterator().next();
        }

        public Set<FactoryBase<?, ?>> getParents() {
            return this.factory.getParents();
        }

        public void addDisplayTextListeners(AttributeChangeListener attributeChangeListener) {
            this.factory.addDisplayTextListeners(attributeChangeListener);
        }

        public void assertRoot() {
            this.factory.assertRoot();
        }

        public DataStorageMetadataDictionary createDataStorageMetadataDictionaryFromRoot() {
            this.assertRoot();
            return this.factory.createDataStorageMetadataDictionaryFromRoot();
        }

        public R getRoot() {
            return this.factory.getRoot();
        }

        public FactoryTreeBuilderBasedAttributeSetup getFactoryTreeBuilderBasedAttributeSetup() {
            return this.factory.factoryTreeBuilderBasedAttributeSetup;
        }

        public void determineRecreationNeedFromRoot(Set<FactoryBase<?, R>> changedFactories) {
            this.factory.determineRecreationNeed(changedFactories);
        }

        public void resetLog() {
            this.factory.resetLog();
        }

        public void start() {
            this.factory.start();
        }

        public void destroyRemoved() {
            this.factory.destroyRemoved();
        }

        public void destroyUpdated() {
            this.factory.destroyUpdated();
        }

        public void cleanUpAfterCrash() {
            try {
                this.destroyRemoved();
            }
            catch (Exception e) {
                logger.info("exception trying to cleanup after crash", (Throwable)e);
            }
            try {
                this.destroyUpdated();
            }
            catch (Exception e) {
                logger.info("exception trying to cleanup after crash", (Throwable)e);
            }
        }

        public L instance() {
            return this.factory.instance();
        }

        public void loopDetector() {
            this.factory.loopDetector();
        }

        public List<FactoryBase<?, R>> getFactoriesInDestroyOrder() {
            return this.factory.getFactoriesInDestroyOrder();
        }

        public List<FactoryBase<?, R>> getFactoriesInCreateAndStartOrder() {
            return this.factory.getFactoriesInCreateAndStartOrder();
        }

        public String debugInfo() {
            return this.factory.debugInfo();
        }

        public void setMicroservice(Microservice<?, R, ?> microservice) {
            this.factory.setMicroservice(microservice);
        }

        public void setFactoryTreeBuilder(FactoryTreeBuilder<?, R, ?> factoryTreeBuilder) {
            this.factory.setFactoryTreeBuilder(factoryTreeBuilder);
        }

        public L getLiveObject() {
            return this.factory.createdLiveObject;
        }

        public String logStartDisplayTextDeep() {
            return this.factory.logStartDisplayTextDeep();
        }

        public String logUpdateDisplayTextDeep() {
            return this.factory.logUpdateDisplayTextDeep();
        }

        public String getFactoryDisplayText() {
            return this.factory.getFactoryDescription();
        }

        public void setTreeBuilderName(String treeBuilderName) {
            this.factory.treeBuilderName = treeBuilderName;
        }

        public String getTreeBuilderName() {
            return this.factory.treeBuilderName;
        }

        public void setRootDeep(R root) {
            this.factory.setRootDeep(root);
        }

        public void needRecalculationForBackReferences() {
            this.factory.needReFinalisation();
        }

        public Attribute<?, ?> getAttribute(String attributeVariableName) {
            return this.factory.getAttribute(attributeVariableName);
        }
    }

    public static class DataConfiguration {
        private final FactoryBase<?, ?> factory;

        public DataConfiguration(FactoryBase<?, ?> factory) {
            this.factory = factory;
        }

        public void setDisplayTextProvider(Supplier<String> displayTextProvider) {
            this.factory.setDisplayTextProvider(displayTextProvider);
        }

        public void setDisplayTextProvider(Supplier<String> displayTextProvider, Attribute<?, ?> ... dependencies) {
            this.factory.setDisplayTextProvider(displayTextProvider);
            this.factory.setDisplayTextDependencies(Arrays.asList(dependencies));
        }

        public void setDisplayTextDependencies(List<Attribute<?, ?>> attributes) {
            this.factory.setDisplayTextDependencies(attributes);
        }

        public void setDisplayTextDependencies(Attribute<?, ?> ... attributes) {
            this.factory.setDisplayTextDependencies(Arrays.asList(attributes));
        }

        public void setAttributeListGroupedSupplier(Function<List<Attribute<?, ?>>, List<AttributeGroup>> attributeListGroupedSupplier) {
            this.factory.setAttributeListGroupedSupplier(attributeListGroupedSupplier);
        }

        public void setMatchSearchTextFunction(Function<String, Boolean> matchSearchTextFunction) {
            this.factory.setMatchSearchTextFunction(matchSearchTextFunction);
        }

        public <T> void addValidation(Validation<T> validation, Attribute<?, ?> ... dependencies) {
            this.factory.addValidation(validation, dependencies);
        }
    }

    @FunctionalInterface
    public static interface AttributeMatchVisitor<V> {
        public boolean accept(String var1, AttributeMatch<V> var2, AttributeMatch<V> var3);
    }

    @FunctionalInterface
    public static interface BiCopyAttributeVisitor<V> {
        public boolean accept(AttributeCopy<V> var1, AttributeCopy<V> var2);
    }

    @FunctionalInterface
    public static interface TriAttributeVisitor<V> {
        public void accept(String var1, AttributeMerger<V> var2, AttributeMerger<V> var3, AttributeMerger<V> var4);
    }
}

