/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory;

import com.google.common.base.Throwables;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.RootFactoryWrapper;
import io.github.factoryfx.factory.exception.AllOrNothingFactoryExceptionHandler;
import io.github.factoryfx.factory.exception.ExceptionResponseAction;
import io.github.factoryfx.factory.exception.FactoryExceptionHandler;
import io.github.factoryfx.factory.log.FactoryUpdateLog;
import io.github.factoryfx.factory.merge.DataMerger;
import io.github.factoryfx.factory.merge.MergeDiffInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryManager<L, R extends FactoryBase<L, R>> {
    private static final Logger logger = LoggerFactory.getLogger(FactoryManager.class);
    private RootFactoryWrapper<R> currentFactoryRoot;
    private final FactoryExceptionHandler factoryExceptionHandler;

    public FactoryManager(FactoryExceptionHandler factoryExceptionHandler) {
        this.factoryExceptionHandler = factoryExceptionHandler;
        if (factoryExceptionHandler instanceof AllOrNothingFactoryExceptionHandler) {
            logger.warn("only AllOrNothingFactoryExceptionHandler is set therefore no exception will be logged. Usually this setup is wrong and the handler should be wrapped with LoggingFactoryExceptionHandler");
        }
    }

    public FactoryUpdateLog<R> update(R commonVersion, R newVersion, Function<String, Boolean> permissionChecker) {
        if (this.currentFactoryRoot == null) {
            throw new IllegalStateException("update on a not started manager");
        }
        List<FactoryBase<?, R>> previousFactories = this.currentFactoryRoot.getFactoriesInDestroyOrder();
        previousFactories.forEach(f -> f.internal().resetLog());
        R previousFactoryCopyRoot = this.currentFactoryRoot.copy();
        FactoryBase factoryBaseInFocus = null;
        RootFactoryWrapper.MergeResult<R> mergeDiff = this.currentFactoryRoot.merge(commonVersion, newVersion, permissionChecker);
        long totalUpdateDuration = 0L;
        ArrayList<FactoryBase<?, ?>> removed = new ArrayList();
        if (mergeDiff.mergeDiffInfo.successfullyMerged()) {
            try {
                FactoryBase factory;
                List<FactoryBase<?, R>> currentFactoriesAfterMerge = this.currentFactoryRoot.collectChildFactories();
                removed = this.getRemovedFactories(previousFactories, new HashSet(currentFactoriesAfterMerge));
                long start = System.nanoTime();
                this.currentFactoryRoot.determineRecreationNeedFromRoot(mergeDiff.mergedFactories);
                List<FactoryBase<?, R>> factoriesInCreateAndStartOrder = this.currentFactoryRoot.getFactoriesInCreateAndStartOrder();
                Iterator iterator = factoriesInCreateAndStartOrder.iterator();
                while (iterator.hasNext()) {
                    factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                    factory.internal().instance();
                }
                iterator = currentFactoriesAfterMerge.iterator();
                while (iterator.hasNext()) {
                    factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                    factory.internal().destroyUpdated();
                }
                iterator = removed.iterator();
                while (iterator.hasNext()) {
                    factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                    factory.internal().destroyRemoved();
                }
                iterator = factoriesInCreateAndStartOrder.iterator();
                while (iterator.hasNext()) {
                    factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                    factory.internal().start();
                }
                totalUpdateDuration = System.nanoTime() - start;
                String log = this.currentFactoryRoot.logUpdateDisplayTextDeep();
                logger.info(log);
                return new FactoryUpdateLog(log, mergeDiff.mergeDiffInfo, totalUpdateDuration, null);
            }
            catch (Exception e) {
                this.factoryExceptionHandler.updateException(e, factoryBaseInFocus, new ExceptionResponseAction(this, new RootFactoryWrapper<R>(previousFactoryCopyRoot), this.currentFactoryRoot, removed));
                return new FactoryUpdateLog(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
        return new FactoryUpdateLog("", mergeDiff.mergeDiffInfo, totalUpdateDuration, null);
    }

    List<FactoryBase<?, R>> getRemovedFactories(Collection<FactoryBase<?, R>> previousFactories, Set<FactoryBase<?, R>> newFactories) {
        ArrayList result = new ArrayList(previousFactories);
        result.removeAll(newFactories);
        return result;
    }

    public MergeDiffInfo<R> simulateUpdate(R commonVersion, R newVersion, Function<String, Boolean> permissionChecker) {
        ((FactoryBase)newVersion).internal().finalise();
        ((FactoryBase)newVersion).internal().loopDetector();
        DataMerger<R> dataMerger = new DataMerger<R>(this.currentFactoryRoot.copy(), commonVersion, newVersion);
        return dataMerger.createMergeResult(permissionChecker).executeMerge();
    }

    public R getCurrentFactory() {
        if (this.currentFactoryRoot == null) {
            return null;
        }
        return this.currentFactoryRoot.getRoot();
    }

    public L start(RootFactoryWrapper<R> newFactory) {
        FactoryBase factoryBaseInFocus = null;
        try {
            FactoryBase factory;
            this.currentFactoryRoot = newFactory;
            List<FactoryBase<?, R>> factoriesInCreateAndStartOrder = newFactory.getFactoriesInCreateAndStartOrder();
            Iterator iterator = factoriesInCreateAndStartOrder.iterator();
            while (iterator.hasNext()) {
                factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                factory.internal().instance();
            }
            iterator = factoriesInCreateAndStartOrder.iterator();
            while (iterator.hasNext()) {
                factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                factory.internal().start();
            }
            logger.info(this.currentFactoryRoot.logStartDisplayTextDeep());
            return ((FactoryBase)this.currentFactoryRoot.getRoot()).internal().getLiveObject();
        }
        catch (Exception e) {
            this.factoryExceptionHandler.startException(e, factoryBaseInFocus, new ExceptionResponseAction(this, null, this.currentFactoryRoot, new ArrayList()));
            return null;
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            throw new IllegalStateException("server is not started");
        }
        List<FactoryBase<?, R>> factories = this.currentFactoryRoot.getFactoriesInDestroyOrder();
        FactoryBase factoryBaseInFocus = null;
        try {
            Iterator iterator = factories.iterator();
            while (iterator.hasNext()) {
                FactoryBase factory;
                factoryBaseInFocus = factory = (FactoryBase)iterator.next();
                factory.internal().destroyRemoved();
            }
        }
        catch (Exception e) {
            this.factoryExceptionHandler.destroyException(e, factoryBaseInFocus, new ExceptionResponseAction(this, null, null, new ArrayList()));
        }
        this.currentFactoryRoot = null;
    }

    public void resetAfterCrash() {
        for (FactoryBase<?, R> factory : this.currentFactoryRoot.getFactoriesInDestroyOrder()) {
            factory.internal().cleanUpAfterCrash();
        }
        this.currentFactoryRoot = null;
    }

    public boolean isStarted() {
        return this.currentFactoryRoot != null;
    }
}

