/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryAttribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryListAttribute;
import io.github.factoryfx.factory.builder.FactoryTreeBuilder;
import io.github.factoryfx.factory.builder.Scope;
import io.github.factoryfx.factory.metadata.FactoryMetadata;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import java.util.ArrayList;
import java.util.List;

public class FactoryTreeBuilderBasedAttributeSetup<R extends FactoryBase<?, R>, S> {
    private final FactoryTreeBuilder<?, R, S> factoryTreeBuilder;

    public FactoryTreeBuilderBasedAttributeSetup(FactoryTreeBuilder<?, R, S> factoryTreeBuilder) {
        this.factoryTreeBuilder = factoryTreeBuilder;
    }

    public <LO, FO extends FactoryBase<LO, R>> List<FO> createNewFactory(Class<FO> clazz) {
        List<FO> newFactories = this.factoryTreeBuilder.buildSubTrees(clazz);
        ArrayList<FO> result = new ArrayList<FO>(newFactories);
        if (result.isEmpty()) {
            FactoryMetadata factoryMetadata = FactoryMetadataManager.getMetadata(clazz);
            FO instance = factoryMetadata.newInstance();
            factoryMetadata.setAttributeReferenceClasses(instance);
            result.add(instance);
        }
        return result;
    }

    private void setupReferenceAttribute(FactoryAttribute<?, ?, ?> referenceAttribute) {
        Class referenceClass = referenceAttribute.internal_getReferenceClass();
        Scope scope = this.factoryTreeBuilder.getScope(referenceClass);
        if (scope == Scope.SINGLETON) {
            referenceAttribute.userNotSelectable();
        }
    }

    private void setupReferenceListAttribute(FactoryListAttribute<?, ?, ?> referenceAttribute) {
        Class referenceClass = referenceAttribute.internal_getReferenceClass();
        Scope scope = this.factoryTreeBuilder.getScope(referenceClass);
        if (scope == Scope.SINGLETON) {
            referenceAttribute.userNotSelectable();
        }
    }

    private void applyToAttribute(Attribute<?, ?> attribute) {
        if (attribute instanceof FactoryAttribute) {
            this.setupReferenceAttribute((FactoryAttribute)attribute);
        }
        if (attribute instanceof FactoryListAttribute) {
            this.setupReferenceListAttribute((FactoryListAttribute)attribute);
        }
    }

    public void applyToRootFactoryDeep(R root) {
        ((FactoryBase)root).internal().serFactoryTreeBuilderBasedAttributeSetupForRoot(this);
        this.factoryTreeBuilder.fillFromExistingFactoryTree(root);
        ((FactoryBase)root).internal().collectChildrenDeep().forEach(data -> data.internal().visitAttributesFlat((attributeVariableName, attribute) -> this.applyToAttribute(attribute)));
    }
}

