/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.merge.DataMerger;
import io.github.factoryfx.factory.merge.MergeDiffInfo;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class RootFactoryWrapper<R extends FactoryBase<?, R>> {
    private final R rootFactory;
    private List<FactoryBase<?, R>> factoriesInCreateAndStartOrder;
    private List<FactoryBase<?, R>> factoriesInDestroyOrder;

    public RootFactoryWrapper(R rootFactory) {
        this.rootFactory = rootFactory;
        ((FactoryBase)this.rootFactory).internal().finalise();
        ((FactoryBase)this.rootFactory).internal().loopDetector();
        this.updateCachedChildren();
    }

    public void updateCachedChildren() {
        this.factoriesInCreateAndStartOrder = ((FactoryBase)this.rootFactory).internal().getFactoriesInCreateAndStartOrder();
        this.factoriesInDestroyOrder = ((FactoryBase)this.rootFactory).internal().getFactoriesInDestroyOrder();
    }

    public List<FactoryBase<?, R>> collectChildFactories() {
        return this.factoriesInCreateAndStartOrder;
    }

    public List<FactoryBase<?, R>> getFactoriesInCreateAndStartOrder() {
        return this.factoriesInCreateAndStartOrder;
    }

    public List<FactoryBase<?, R>> getFactoriesInDestroyOrder() {
        return this.factoriesInDestroyOrder;
    }

    public void determineRecreationNeedFromRoot(Set<FactoryBase<?, R>> changedData) {
        ((FactoryBase)this.rootFactory).internal().determineRecreationNeedFromRoot(changedData);
    }

    public MergeResult<R> merge(R commonVersion, R newVersion, Function<String, Boolean> permissionChecker) {
        DataMerger<R> dataMerger = new DataMerger<R>(this.rootFactory, commonVersion, newVersion);
        io.github.factoryfx.factory.merge.MergeResult<R> mergeResult = dataMerger.createMergeResult(permissionChecker);
        MergeDiffInfo<R> result = mergeResult.executeMerge();
        ((FactoryBase)this.rootFactory).internal().loopDetector();
        this.updateCachedChildren();
        return new MergeResult<R>(result, mergeResult.getMergedFactories());
    }

    public R copy() {
        return (R)((FactoryBase)this.rootFactory).internal().copy();
    }

    public String logStartDisplayTextDeep() {
        return ((FactoryBase)this.rootFactory).internal().logStartDisplayTextDeep();
    }

    public String logUpdateDisplayTextDeep() {
        return ((FactoryBase)this.rootFactory).internal().logUpdateDisplayTextDeep();
    }

    public R getRoot() {
        return this.rootFactory;
    }

    public static class MergeResult<R extends FactoryBase<?, R>> {
        public final MergeDiffInfo<R> mergeDiffInfo;
        public final Set<FactoryBase<?, R>> mergedFactories;

        private MergeResult(MergeDiffInfo<R> mergeDiffInfo, Set<FactoryBase<?, R>> mergedFactories) {
            this.mergeDiffInfo = mergeDiffInfo;
            this.mergedFactories = mergedFactories;
        }
    }
}

