/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.AttributeChangeListener;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMerger;
import io.github.factoryfx.factory.storage.migration.metadata.AttributeStorageMetadata;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationError;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Attribute<T, A extends Attribute<T, A>>
implements AttributeMerger<T>,
AttributeCopy<T> {
    @JsonIgnore
    private Set<Validation<T>> validations;
    private AttributeChangeListener<T, A> listener;
    private List<AttributeChangeListener<T, A>> listeners;
    private static final Locale PORTUGUESE = new Locale("pt", "PT");
    private static final Locale SPANISH = new Locale("es", "ES");
    @JsonIgnore
    private String permission;
    @JsonIgnore
    private String addonText;
    @JsonIgnore
    String en;
    @JsonIgnore
    String de;
    @JsonIgnore
    String es;
    @JsonIgnore
    String fr;
    @JsonIgnore
    String it;
    @JsonIgnore
    String pt;
    Locale customLocale;
    String customLocaleText;
    @JsonIgnore
    String tooltipEn;
    @JsonIgnore
    String tooltipDe;
    private boolean userReadOnly = false;
    private Supplier<Boolean> readyOnlySupplier;

    @Override
    public void internal_merge(T newValue) {
        this.set(newValue);
    }

    public List<ValidationError> internal_validate(FactoryBase<?, ?> parent, String attributeVariableName) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.validations == null) {
            return validationErrors;
        }
        for (Validation validation : this.validations) {
            ValidationResult validationResult = validation.validate(this.get());
            if (!validationResult.validationFailed()) continue;
            validationErrors.add(validationResult.createValidationError(this, parent, attributeVariableName));
        }
        return validationErrors;
    }

    public boolean internal_required() {
        return false;
    }

    public void internal_endUsage() {
    }

    protected void updateListeners(T value) {
        if (this.listenersEmpty()) {
            return;
        }
        if (this.listener != null) {
            this.listener.changed(this, value);
        } else {
            for (AttributeChangeListener<T, A> listener : this.listeners) {
                listener.changed(this, value);
            }
        }
    }

    protected boolean listenersEmpty() {
        return this.listener == null && (this.listeners == null || this.listeners.isEmpty());
    }

    public List<AttributeChangeListener<T, A>> internal_getListeners() {
        if (this.listener != null) {
            return List.of(this.listener);
        }
        if (this.listeners != null) {
            return this.listeners;
        }
        return Collections.emptyList();
    }

    public void internal_addListener(AttributeChangeListener<T, A> newListener) {
        if (this.listener == null && this.listeners == null) {
            this.listener = newListener;
        } else if (this.listeners == null) {
            this.listeners = new ArrayList<AttributeChangeListener<T, A>>();
            this.listeners.add(this.listener);
            this.listener = null;
            this.listeners.add(newListener);
        } else {
            this.listeners.add(newListener);
        }
    }

    public void internal_removeAllListener() {
        this.listeners = null;
        this.listener = null;
    }

    public void internal_removeListener(AttributeChangeListener<T, A> removeListener) {
        if (this.listeners == null && this.listener == null) {
            return;
        }
        if (this.listener != null && (this.listener.unwrap() == removeListener || this.listener.unwrap() == null)) {
            this.listener = null;
            return;
        }
        if (this.listeners != null) {
            for (AttributeChangeListener<T, A> listenerItem : new ArrayList<AttributeChangeListener<T, A>>(this.listeners)) {
                if (listenerItem.unwrap() != removeListener && listenerItem.unwrap() != null) continue;
                this.listeners.remove(listenerItem);
            }
        }
    }

    @JsonIgnore
    public abstract String getDisplayText();

    public A validation(Validation<T> validation) {
        if (this.validations == null) {
            this.validations = new HashSet<Validation<T>>();
        }
        this.validations.add(validation);
        return (A)this;
    }

    public String internal_getPreferredLabelText(Locale locale) {
        if (locale.equals(this.customLocale)) {
            return this.customLocaleText;
        }
        if (this.en != null && locale.equals(Locale.ENGLISH)) {
            return this.en;
        }
        if (this.de != null && locale.equals(Locale.GERMAN)) {
            return this.de;
        }
        if (this.es != null && locale.equals(SPANISH)) {
            return this.es;
        }
        if (this.fr != null && locale.equals(Locale.FRANCE)) {
            return this.fr;
        }
        if (this.it != null && locale.equals(Locale.ITALIAN)) {
            return this.it;
        }
        if (this.pt != null && locale.equals(PORTUGUESE)) {
            return this.pt;
        }
        if (this.en != null) {
            return this.en;
        }
        if (this.de != null) {
            return this.de;
        }
        if (this.es != null) {
            return this.es;
        }
        if (this.fr != null) {
            return this.fr;
        }
        if (this.it != null) {
            return this.it;
        }
        if (this.pt != null) {
            return this.pt;
        }
        return "";
    }

    public String internal_getAddonText() {
        return this.addonText;
    }

    @Override
    public boolean internal_hasWritePermission(Function<String, Boolean> permissionChecker) {
        return this.permission == null || permissionChecker.apply(this.permission) != false;
    }

    public A permission(String permission) {
        this.permission = permission;
        return (A)this;
    }

    public A addonText(String addonText) {
        this.addonText = addonText;
        return (A)this;
    }

    public A labelText(String text) {
        this.en = text;
        return (A)this;
    }

    public A labelText(String labelText, Locale locale) {
        this.customLocale = locale;
        this.customLocaleText = labelText;
        return (A)this;
    }

    public A en(String text) {
        this.en = text;
        return (A)this;
    }

    public A de(String text) {
        this.de = text;
        return (A)this;
    }

    public A es(String text) {
        this.es = text;
        return (A)this;
    }

    public A fr(String text) {
        this.fr = text;
        return (A)this;
    }

    public A it(String text) {
        this.it = text;
        return (A)this;
    }

    public A pt(String text) {
        this.pt = text;
        return (A)this;
    }

    public A tooltipEn(String tooltip) {
        this.tooltipEn = tooltip;
        return (A)this;
    }

    public A tooltipDe(String tooltip) {
        this.tooltipDe = tooltip;
        return (A)this;
    }

    public String internal_getPreferredTooltipText(Locale locale) {
        if (this.tooltipEn != null && locale.equals(Locale.ENGLISH)) {
            return this.tooltipEn;
        }
        if (this.tooltipDe != null && locale.equals(Locale.GERMAN)) {
            return this.tooltipDe;
        }
        if (this.tooltipEn != null) {
            return this.tooltipEn;
        }
        if (this.tooltipDe != null) {
            return this.tooltipDe;
        }
        return "";
    }

    public boolean internal_isUserReadOnly() {
        if (this.userReadOnly) {
            return true;
        }
        if (this.readyOnlySupplier != null) {
            return this.readyOnlySupplier.get();
        }
        return false;
    }

    public A userReadOnly() {
        this.userReadOnly = true;
        return (A)this;
    }

    public A userReadOnly(Supplier<Boolean> readyOnlySupplier) {
        this.readyOnlySupplier = readyOnlySupplier;
        return (A)this;
    }

    public AttributeStorageMetadata createAttributeStorageMetadata(String variableName) {
        return new AttributeStorageMetadata(variableName, this.getClass().getName(), false, null);
    }

    public abstract void internal_reset();
}

