/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.util.LanguageText;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationError;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class ImmutableValueAttribute<T, A extends Attribute<T, A>>
extends Attribute<T, A> {
    @JsonProperty(value="v")
    protected T value;
    private static final Validation requiredValidation = value -> {
        boolean error;
        boolean bl = error = value == null;
        if (value instanceof String && ((String)value).isEmpty()) {
            error = true;
        }
        return new ValidationResult(error, new LanguageText().en("required parameter").de("Pflichtparameter"));
    };
    @JsonIgnore
    private boolean nullable;

    @Override
    public boolean internal_mergeMatch(AttributeMatch<T> value) {
        return Objects.equals(this.value, value.get());
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        this.value = value;
        this.updateListeners(value);
    }

    @Override
    public void internal_copyTo(AttributeCopy<T> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
        copyAttribute.set(this.get());
    }

    @Override
    public void internal_semanticCopyTo(AttributeCopy<T> copyAttribute) {
        copyAttribute.set(this.get());
    }

    @Override
    @JsonIgnore
    public String getDisplayText() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "<empty>";
    }

    @JsonGetter
    protected T getValue() {
        return this.get();
    }

    @JsonSetter
    protected void setValue(T value) {
        this.set(value);
    }

    @Override
    public boolean internal_required() {
        return !this.nullable;
    }

    public A nullable() {
        this.nullable = true;
        return (A)this;
    }

    @Override
    public List<ValidationError> internal_validate(FactoryBase<?, ?> parent, String attributeVariableName) {
        if (!this.nullable) {
            this.validation(requiredValidation);
        }
        return super.internal_validate(parent, attributeVariableName);
    }

    public A defaultValue(T defaultValue) {
        this.set(defaultValue);
        return (A)this;
    }

    @Override
    public void internal_reset() {
        this.internal_removeAllListener();
    }

    @Override
    public void internal_addBackReferences(FactoryBase<?, ?> root, FactoryBase<?, ?> parent) {
    }

    public Optional<T> getNullable() {
        return Optional.ofNullable(this.get());
    }
}

