/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.CollectionAttributeUtil;
import io.github.factoryfx.factory.attribute.ImmutableValueAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ValueListAttribute<T, A extends Attribute<List<T>, A>>
extends ImmutableValueAttribute<List<T>, A>
implements List<T> {
    private final Class<T> itemType;

    public ValueListAttribute(Class<T> itemType) {
        this.itemType = itemType;
        this.value = new ArrayList();
    }

    public Class<T> internal_getItemType() {
        return this.itemType;
    }

    private void afterModify() {
        this.updateListeners(this);
    }

    @JsonCreator
    protected ValueListAttribute() {
        this(null);
    }

    @Override
    @JsonIgnore
    public String getDisplayText() {
        return new CollectionAttributeUtil<Object>((Collection)this.value, Object::toString).getDisplayText();
    }

    @Override
    public List<T> get() {
        return this;
    }

    @Override
    public void set(List<T> value) {
        if (value == null) {
            ((List)this.value).clear();
        } else {
            ((List)this.value).clear();
            ((List)this.value).addAll(value);
        }
    }

    public List<T> filtered(Predicate<T> predicate) {
        return ((List)this.value).stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return ((List)this.value).size();
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.value).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((List)this.value).contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return ((List)this.value).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((List)this.value).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return ((List)this.value).toArray(a);
    }

    @Override
    public boolean add(T t) {
        boolean add = ((List)this.value).add(t);
        this.afterModify();
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = ((List)this.value).remove(o);
        this.afterModify();
        return remove;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((List)this.value).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean b = ((List)this.value).addAll(c);
        this.afterModify();
        return b;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean b = ((List)this.value).addAll(index, c);
        this.afterModify();
        return b;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = ((List)this.value).removeAll(c);
        this.afterModify();
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((List)this.value).retainAll(c);
    }

    @Override
    public void clear() {
        ((List)this.value).clear();
        this.afterModify();
    }

    @Override
    public T get(int index) {
        return (T)((List)this.value).get(index);
    }

    @Override
    public T set(int index, T element) {
        T result = ((List)this.value).set(index, element);
        this.afterModify();
        return result;
    }

    @Override
    public void add(int index, T element) {
        ((List)this.value).add(index, element);
        this.afterModify();
    }

    @Override
    public T remove(int index) {
        Object remove = ((List)this.value).remove(index);
        this.afterModify();
        return (T)remove;
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.value).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.value).lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return ((List)this.value).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return ((List)this.value).listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return ((List)this.value).subList(fromIndex, toIndex);
    }
}

