/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.attribute.CollectionAttributeUtil;
import io.github.factoryfx.factory.attribute.ImmutableValueAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ValueMapAttribute<K, V, A extends ValueMapAttribute<K, V, A>>
extends ImmutableValueAttribute<Map<K, V>, A>
implements Map<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;

    public ValueMapAttribute(Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.value = new HashMap();
    }

    @JsonCreator
    protected ValueMapAttribute() {
        this(null, null);
    }

    @Override
    @JsonIgnore
    public String getDisplayText() {
        return new CollectionAttributeUtil<Map.Entry>(((Map)this.value).entrySet(), item -> item.getKey() + ":" + item.getValue()).getDisplayText();
    }

    private void afterModify() {
        this.updateListeners(this);
    }

    @Override
    public int size() {
        return ((Map)this.value).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.value).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((Map)this.value).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Map)this.value).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return ((Map)this.value).get(key);
    }

    @Override
    public V put(K key, V value) {
        V put = ((Map)this.value).put(key, value);
        this.afterModify();
        return put;
    }

    @Override
    public V remove(Object key) {
        Object remove = ((Map)this.value).remove(key);
        this.afterModify();
        return remove;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ((Map)this.value).putAll(m);
        this.afterModify();
    }

    @Override
    public void clear() {
        ((Map)this.value).clear();
        this.afterModify();
    }

    @Override
    public Set<K> keySet() {
        return ((Map)this.value).keySet();
    }

    @Override
    public Collection<V> values() {
        return ((Map)this.value).values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ((Map)this.value).entrySet();
    }
}

