/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.CollectionAttributeUtil;
import io.github.factoryfx.factory.attribute.ImmutableValueAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ValueSetAttribute<T, A extends Attribute<Set<T>, A>>
extends ImmutableValueAttribute<Set<T>, A>
implements Set<T> {
    private final Class<T> itemType;

    public ValueSetAttribute(Class<T> itemType) {
        this.itemType = itemType;
        this.value = new HashSet();
    }

    @JsonCreator
    protected ValueSetAttribute() {
        this(null);
    }

    @Override
    public String getDisplayText() {
        return new CollectionAttributeUtil<Object>((Collection)this.value, Object::toString).getDisplayText();
    }

    @Override
    public void set(Set<T> value) {
        ((Set)this.value).clear();
        ((Set)this.value).addAll(value);
    }

    private void afterModify() {
        this.updateListeners(this);
    }

    @Override
    public int size() {
        return ((Set)this.value).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Set)this.value).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((Set)this.value).contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return ((Set)this.value).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((Set)this.value).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return ((Set)this.value).toArray(a);
    }

    @Override
    public boolean add(T t) {
        boolean add = ((Set)this.value).add(t);
        this.afterModify();
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = ((Set)this.value).remove(o);
        this.afterModify();
        return remove;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Set)this.value).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean b = ((Set)this.value).addAll(c);
        this.afterModify();
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((Set)this.value).retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = ((Set)this.value).removeAll(c);
        this.afterModify();
        return b;
    }

    @Override
    public void clear() {
        ((Set)this.value).clear();
        this.afterModify();
    }
}

