/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.dependency;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.OptBoolean;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.CopySemantic;
import io.github.factoryfx.factory.attribute.dependency.ReferenceBaseAttribute;
import io.github.factoryfx.factory.util.LanguageText;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationError;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;

public class FactoryBaseAttribute<R extends FactoryBase<?, R>, L, F extends FactoryBase<? extends L, R>, A extends ReferenceBaseAttribute<R, F, F, A>>
extends ReferenceBaseAttribute<R, F, F, A> {
    @JsonProperty(value="v")
    private F value;
    private static final Validation requiredValidation = value -> {
        boolean error = value == null;
        return new ValidationResult(error, new LanguageText().en("required parameter").de("Pflichtparameter"));
    };
    private boolean nullable;

    @Override
    public boolean internal_mergeMatch(AttributeMatch<F> value) {
        return this.internal_referenceEquals((FactoryBase<?, ?>)this.value, (FactoryBase)value.get());
    }

    @Override
    public <RL extends FactoryBase<?, RL>> void internal_fixDuplicateObjects(Map<UUID, FactoryBase<?, RL>> idToDataMap) {
        Object currentReferenceContent = this.get();
        if (currentReferenceContent != null) {
            FactoryBase<?, RL> value = idToDataMap.get(((FactoryBase)currentReferenceContent).getId());
            if (this.get() != value) {
                this.set((F)value);
            }
        }
    }

    @Override
    public F get() {
        return this.value;
    }

    @JsonIgnore
    public Optional<F> getOptional() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public void set(F factory) {
        this.value = factory;
        if (this.root != null) {
            this.root.internal().needRecalculationForBackReferences();
            if (factory != null) {
                ((FactoryBase)factory).internal().setRootDeep(this.root);
            }
        }
        this.updateListeners(factory);
    }

    @Override
    public void internal_copyTo(AttributeCopy<F> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
        Object factory = this.get();
        if (factory != null) {
            Object copy = ((FactoryBase)factory).internal().copyDeep(level, maxLevel, oldData, parent, root);
            copyAttribute.set(copy);
        }
    }

    @Override
    public void internal_semanticCopyTo(AttributeCopy<F> copyAttribute) {
        if (this.get() != null) {
            if (this.internal_getCopySemantic() == CopySemantic.SELF) {
                copyAttribute.set(this.get());
            } else {
                copyAttribute.set(((FactoryBase)this.get()).utility().semanticCopy());
            }
        }
    }

    @JsonGetter
    @JsonMerge(value=OptBoolean.FALSE)
    protected F getValue() {
        return this.value;
    }

    @JsonSetter
    protected void setValue(F value) {
        this.value = value;
    }

    @Override
    @JsonIgnore
    public String getDisplayText() {
        String referenceDisplayText = "empty";
        if (this.value != null) {
            referenceDisplayText = ((FactoryBase)this.value).internal().getDisplayText();
        }
        return referenceDisplayText;
    }

    public void internal_deleteFactory() {
        Object removedFactory = this.get();
        this.set((F)null);
        if (this.additionalDeleteAction != null) {
            this.additionalDeleteAction.accept(removedFactory, this.root);
        }
    }

    @Override
    public void internal_merge(F newValue) {
        this.value = newValue;
    }

    public L instance() {
        if (this.get() == null) {
            return null;
        }
        return ((FactoryBase)this.get()).internal().instance();
    }

    @Override
    public boolean internal_required() {
        return !this.nullable;
    }

    public A nullable() {
        this.nullable = true;
        return (A)this;
    }

    @Override
    public List<ValidationError> internal_validate(FactoryBase<?, ?> parent, String attributeVariableName) {
        if (!this.nullable) {
            this.validation(requiredValidation);
        }
        return super.internal_validate(parent, attributeVariableName);
    }

    @Override
    public void internal_visitChildren(Consumer<FactoryBase<?, R>> consumer, boolean includeViews) {
        if (this.value != null) {
            consumer.accept((FactoryBase<?, R>)this.value);
        }
    }
}

