/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.dependency;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.CollectionAttributeUtil;
import io.github.factoryfx.factory.attribute.CopySemantic;
import io.github.factoryfx.factory.attribute.dependency.ReferenceBaseAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FactoryListBaseAttribute<R extends FactoryBase<?, R>, L, F extends FactoryBase<? extends L, R>, A extends FactoryListBaseAttribute<R, L, F, A>>
extends ReferenceBaseAttribute<R, F, List<F>, A>
implements List<F> {
    final List<F> list = new ArrayList<F>();
    @JsonIgnore
    private boolean defaultExpanded = false;

    public List<L> instances() {
        ArrayList result = new ArrayList(this.size());
        for (FactoryBase item : this) {
            result.add(item.internal().instance());
        }
        return result;
    }

    public L instances(Predicate<F> filter) {
        Optional any = this.get().stream().filter(filter).findAny();
        return any.map(t -> t.internal().instance()).orElse(null);
    }

    @Override
    public boolean internal_mergeMatch(AttributeMatch<List<F>> value) {
        return this.internal_referenceListEquals(this.list, (List)value.get());
    }

    @Override
    public void internal_merge(List<F> newList) {
        this.internal_mergeFactoryList(this.list, newList);
    }

    @Override
    public <RL extends FactoryBase<?, RL>> void internal_fixDuplicateObjects(Map<UUID, FactoryBase<?, RL>> idToDataMap) {
        ArrayList fixedList = new ArrayList(this.list.size());
        for (FactoryBase entity : this.list) {
            fixedList.add(idToDataMap.get(entity.getId()));
        }
        this.list.clear();
        this.list.addAll(fixedList);
    }

    @Override
    public List<F> get() {
        return this;
    }

    @Override
    public void set(List<F> value) {
        if (value == null) {
            if (!this.list.isEmpty()) {
                this.list.clear();
                this.afterModify();
            }
        } else {
            this.list.clear();
            this.list.addAll(value);
            this.afterAdd((Collection<? extends F>)value);
            this.afterModify();
        }
    }

    @Override
    public void internal_copyTo(AttributeCopy<List<F>> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
        if (!this.isEmpty()) {
            ArrayList copy = new ArrayList(this.size());
            Iterator iterator = this.get().iterator();
            while (iterator.hasNext()) {
                Object itemCopy;
                FactoryBase item = (FactoryBase)iterator.next();
                if (item == null || (itemCopy = item.internal().copyDeep(level, maxLevel, oldData, parent, root)) == null) continue;
                copy.add(itemCopy);
            }
            copyAttribute.set(copy);
        }
    }

    @Override
    public void internal_semanticCopyTo(AttributeCopy<List<F>> copyAttribute) {
        if (this.internal_getCopySemantic() == CopySemantic.SELF) {
            copyAttribute.set((List<F>)this.get());
        } else {
            ArrayList result = new ArrayList();
            Iterator iterator = this.get().iterator();
            while (iterator.hasNext()) {
                FactoryBase item = (FactoryBase)iterator.next();
                Object itemCopy = item.utility().semanticCopy();
                if (itemCopy == null) continue;
                result.add(itemCopy);
            }
            copyAttribute.set(result);
        }
    }

    public List<F> filtered(Predicate<F> predicate) {
        return this.get().stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public String getDisplayText() {
        return new CollectionAttributeUtil<FactoryBase>((Collection<FactoryBase>)this.get(), t -> t.internal().getDisplayText()).getDisplayText();
    }

    public void internal_deleteFactory(F factory) {
        this.remove(factory);
        if (this.additionalDeleteAction != null) {
            this.additionalDeleteAction.accept(factory, this.root);
        }
    }

    private void afterAdd(F added) {
        if (added == null) {
            throw new IllegalStateException("cant't add null to list");
        }
        if (this.root != null) {
            ((FactoryBase)added).internal().setRootDeep(this.root);
        }
    }

    private void afterAdd(Collection<? extends F> added) {
        for (FactoryBase add : added) {
            this.afterAdd(add);
        }
    }

    private void afterModify() {
        if (this.root != null) {
            this.root.internal().needRecalculationForBackReferences();
        }
        this.updateListeners(this.list);
    }

    @Override
    public void sort(Comparator<? super F> c) {
        this.list.sort(c);
        this.afterModify();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<F> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.list.toArray(a);
    }

    @Override
    public Stream<F> stream() {
        return this.list.stream();
    }

    @Override
    public Stream<F> parallelStream() {
        return this.list.parallelStream();
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = this.list.remove(o);
        this.afterModify();
        return remove;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends F> c) {
        boolean result = this.list.addAll(c);
        this.afterAdd(c);
        this.afterModify();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends F> c) {
        boolean result = this.list.addAll(index, c);
        this.afterAdd(c);
        this.afterModify();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.list.removeAll(c);
        this.afterModify();
        return result;
    }

    @Override
    public boolean removeIf(Predicate<? super F> filter) {
        boolean result = this.list.removeIf(filter);
        this.afterModify();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
        this.afterModify();
    }

    @Override
    public F get(int index) {
        return (F)((FactoryBase)this.list.get(index));
    }

    @Override
    public F set(int index, F element) {
        FactoryBase set = (FactoryBase)this.list.set(index, element);
        this.afterAdd(element);
        this.afterModify();
        return (F)set;
    }

    @Override
    public void add(int index, F element) {
        this.list.add(index, element);
        this.afterAdd(element);
        this.afterModify();
    }

    @Override
    public F remove(int index) {
        FactoryBase remove = (FactoryBase)this.list.remove(index);
        this.afterModify();
        return (F)remove;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<F> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<F> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<F> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Spliterator<F> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public void forEach(Consumer<? super F> action) {
        this.list.forEach(action);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean add(F value) {
        this.list.add(value);
        this.afterAdd(value);
        this.afterModify();
        return false;
    }

    @JsonIgnore
    public A defaultExpanded() {
        this.defaultExpanded = true;
        return (A)this;
    }

    @JsonIgnore
    public boolean internal_isDefaultExpanded() {
        return this.defaultExpanded;
    }

    @Override
    public void internal_visitChildren(Consumer<FactoryBase<?, R>> consumer, boolean includeViews) {
        for (FactoryBase factory : this.list) {
            consumer.accept(factory);
        }
    }

    public void batchModify(Consumer<List<F>> batchAction) {
        batchAction.accept(this.list);
        this.afterAdd((Collection<? extends F>)this.list);
        this.afterModify();
    }
}

