/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.dependency;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.AttributeChangeListener;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.RunLaterAble;
import io.github.factoryfx.factory.attribute.dependency.FactoryChildrenEnclosingAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

@JsonIgnoreType
public class FactoryViewAttribute<R extends FactoryBase<?, R>, L, F extends FactoryBase<L, R>>
extends Attribute<F, FactoryViewAttribute<R, L, F>>
implements RunLaterAble,
FactoryChildrenEnclosingAttribute<R, Attribute<F, FactoryViewAttribute<R, L, F>>> {
    R root;
    protected final Function<R, F> view;
    Consumer<Runnable> runlaterExecutor;
    DirtyTrackingThread dirtyTracking;
    List<AttributeChangeListener<F, FactoryViewAttribute<R, L, F>>> listeners;

    public FactoryViewAttribute(Function<R, F> view) {
        this.view = view;
    }

    public L instance() {
        if (this.get() == null) {
            return null;
        }
        return ((FactoryBase)this.get()).internal().instance();
    }

    @Override
    public void internal_merge(F newFactory) {
    }

    @Override
    public boolean internal_mergeMatch(AttributeMatch<F> value) {
        Object thisValue = this.get();
        return this.internal_referenceEquals((FactoryBase<?, ?>)thisValue, (FactoryBase)value.get());
    }

    @Override
    public <RL extends FactoryBase<?, RL>> void internal_fixDuplicateObjects(Map<UUID, FactoryBase<?, RL>> idToDataMap) {
    }

    @Override
    public F get() {
        return (F)((FactoryBase)this.view.apply(this.root));
    }

    @Override
    public void set(F value) {
    }

    @Override
    public void internal_addBackReferences(FactoryBase<?, ?> root, FactoryBase<?, ?> parent) {
        this.root = root;
    }

    @Override
    public void internal_setReferenceClass(Class<?> clazz) {
    }

    @Override
    public void internal_copyTo(AttributeCopy<F> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
    }

    @Override
    public void internal_semanticCopyTo(AttributeCopy<F> copyAttribute) {
    }

    @Override
    public void setRunlaterExecutor(Consumer<Runnable> runlaterExecutor) {
        this.runlaterExecutor = runlaterExecutor;
    }

    public void runLater(Runnable runnable) {
        if (this.runlaterExecutor != null) {
            this.runlaterExecutor.accept(runnable);
        }
    }

    @Override
    public void internal_addListener(AttributeChangeListener<F, FactoryViewAttribute<R, L, F>> listener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
        if (this.dirtyTracking == null) {
            this.dirtyTracking = new DirtyTrackingThread();
            this.dirtyTracking.setDaemon(true);
            this.dirtyTracking.start();
        }
    }

    @Override
    public void internal_removeListener(AttributeChangeListener<F, FactoryViewAttribute<R, L, F>> listener) {
        if (this.listeners != null) {
            for (AttributeChangeListener<F, FactoryViewAttribute<R, L, F>> listenerItem : new ArrayList<AttributeChangeListener<F, FactoryViewAttribute<R, L, F>>>(this.listeners)) {
                if (listenerItem.unwrap() != listener) continue;
                this.listeners.remove(listenerItem);
            }
            if (this.listeners.isEmpty() && this.dirtyTracking != null) {
                this.dirtyTracking.stopTracking();
                this.dirtyTracking = null;
            }
        }
    }

    @JsonIgnore
    public Optional<F> getOptional() {
        return Optional.ofNullable(this.get());
    }

    @Override
    public String getDisplayText() {
        String referenceDisplayText = "empty";
        Object value = this.get();
        if (value != null) {
            referenceDisplayText = ((FactoryBase)value).internal().getDisplayText();
        }
        return referenceDisplayText;
    }

    @Override
    public void internal_reset() {
    }

    @Override
    public void internal_endUsage() {
        if (this.dirtyTracking != null) {
            this.dirtyTracking.stopTracking();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    @Override
    public void internal_visitChildren(Consumer<FactoryBase<?, R>> consumer, boolean includeViews) {
        Object factory;
        if (includeViews && (factory = this.get()) != null) {
            consumer.accept((FactoryBase<?, R>)factory);
        }
    }

    class DirtyTrackingThread
    extends Thread {
        volatile boolean tracking = true;
        F previousValue;

        DirtyTrackingThread() {
        }

        @Override
        public void run() {
            super.run();
            while (this.tracking) {
                Object currentValue = FactoryViewAttribute.this.get();
                if (this.previousValue == null && currentValue != null || this.previousValue != null && currentValue == null || this.previousValue != null && currentValue != null && !((FactoryBase)this.previousValue).idEquals((FactoryBase<?, ?>)currentValue)) {
                    for (AttributeChangeListener listener : new ArrayList(FactoryViewAttribute.this.listeners)) {
                        FactoryViewAttribute.this.runLater(() -> this.lambda$run$0(listener, (FactoryBase)currentValue));
                    }
                }
                this.previousValue = currentValue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void stopTracking() {
            this.tracking = false;
        }

        private /* synthetic */ void lambda$run$0(AttributeChangeListener listener, FactoryBase currentValue) {
            listener.changed(FactoryViewAttribute.this, currentValue);
        }
    }
}

