/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.dependency;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.AttributeChangeListener;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.CollectionAttributeUtil;
import io.github.factoryfx.factory.attribute.RunLaterAble;
import io.github.factoryfx.factory.attribute.dependency.FactoryChildrenEnclosingAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

@JsonIgnoreType
public class FactoryViewListAttribute<R extends FactoryBase<?, R>, L, F extends FactoryBase<L, R>>
extends Attribute<List<F>, FactoryViewListAttribute<R, L, F>>
implements RunLaterAble,
FactoryChildrenEnclosingAttribute<R, FactoryViewListAttribute<R, L, F>> {
    private R root;
    protected final Function<R, List<F>> view;
    Consumer<Runnable> runlaterExecutor;
    DirtyTrackingThread dirtyTracking;
    List<AttributeChangeListener<List<F>, FactoryViewListAttribute<R, L, F>>> listeners;

    public FactoryViewListAttribute(Function<R, List<F>> view) {
        this.view = view;
    }

    public List<L> instances() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.get().iterator();
        while (iterator.hasNext()) {
            FactoryBase item = (FactoryBase)iterator.next();
            result.add(item.internal().instance());
        }
        return result;
    }

    public boolean add(F data) {
        return this.get().add(data);
    }

    public L instance(Predicate<F> filter) {
        Optional any = this.get().stream().filter(filter).findAny();
        return any.map(t -> t.internal().instance()).orElse(null);
    }

    @Override
    public void internal_merge(List<F> newList) {
    }

    @Override
    public boolean internal_mergeMatch(AttributeMatch<List<F>> value) {
        return this.internal_referenceListEquals((List<? extends FactoryBase<?, ?>>)this.get(), (List)value.get());
    }

    @Override
    public <RL extends FactoryBase<?, RL>> void internal_fixDuplicateObjects(Map<UUID, FactoryBase<?, RL>> idToDataMap) {
    }

    @Override
    public List<F> get() {
        List<F> result = this.view.apply(this.root);
        if (result == null) {
            return new ArrayList();
        }
        return result;
    }

    @Override
    public void set(List<F> value) {
    }

    @Override
    public void internal_semanticCopyTo(AttributeCopy<List<F>> copyAttribute) {
    }

    @Override
    public void setRunlaterExecutor(Consumer<Runnable> runlaterExecutor) {
        this.runlaterExecutor = runlaterExecutor;
    }

    private void runLater(Runnable runnable) {
        if (this.runlaterExecutor != null) {
            this.runlaterExecutor.accept(runnable);
        }
    }

    @Override
    public void internal_addListener(AttributeChangeListener<List<F>, FactoryViewListAttribute<R, L, F>> listener) {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
        if (this.dirtyTracking == null) {
            this.dirtyTracking = new DirtyTrackingThread();
            this.dirtyTracking.setDaemon(true);
            this.dirtyTracking.start();
        }
    }

    @Override
    public void internal_removeListener(AttributeChangeListener<List<F>, FactoryViewListAttribute<R, L, F>> listener) {
        if (this.listeners != null) {
            for (AttributeChangeListener<List<F>, FactoryViewListAttribute<R, L, F>> listenerItem : new ArrayList<AttributeChangeListener<List<F>, FactoryViewListAttribute<R, L, F>>>(this.listeners)) {
                if (listenerItem.unwrap() != listener) continue;
                this.listeners.remove(listenerItem);
            }
            if (this.listeners.isEmpty() && this.dirtyTracking != null) {
                this.dirtyTracking.stopTracking();
                this.dirtyTracking = null;
            }
        }
    }

    @Override
    public String getDisplayText() {
        return new CollectionAttributeUtil<FactoryBase>((Collection<FactoryBase>)this.get(), t -> t.internal().getDisplayText()).getDisplayText();
    }

    @Override
    public void internal_reset() {
    }

    @Override
    public void internal_addBackReferences(FactoryBase<?, ?> root, FactoryBase<?, ?> parent) {
        this.root = root;
    }

    @Override
    public void internal_setReferenceClass(Class<?> clazz) {
    }

    @Override
    public void internal_copyTo(AttributeCopy<List<F>> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
    }

    @Override
    public void internal_endUsage() {
        if (this.dirtyTracking != null) {
            this.dirtyTracking.stopTracking();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public Stream<F> stream() {
        return this.get().stream();
    }

    @Override
    public void internal_visitChildren(Consumer<FactoryBase<?, R>> consumer, boolean includeViews) {
        if (includeViews) {
            Object children = this.get();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                FactoryBase factory = (FactoryBase)iterator.next();
                consumer.accept(factory);
            }
        }
    }

    class DirtyTrackingThread
    extends Thread {
        volatile boolean tracking = true;
        List<F> previousList;

        DirtyTrackingThread() {
        }

        @Override
        public void run() {
            super.run();
            while (this.tracking) {
                Object currentList = FactoryViewListAttribute.this.get();
                if (this.isEmpty(this.previousList) && !this.isEmpty((List)currentList) || !this.isEmpty(this.previousList) && this.isEmpty((List)currentList)) {
                    for (AttributeChangeListener listener : new ArrayList(FactoryViewListAttribute.this.listeners)) {
                        FactoryViewListAttribute.this.runLater(() -> this.lambda$run$0(listener, (List)currentList));
                    }
                }
                if (!this.isEmpty(this.previousList) && !this.isEmpty((List)currentList)) {
                    HashSet idList = new HashSet();
                    this.previousList.stream().map(FactoryBase::getId).forEach(idList::add);
                    boolean changed = false;
                    Iterator<Object> iterator = currentList.iterator();
                    while (iterator.hasNext()) {
                        FactoryBase factoryBase = (FactoryBase)iterator.next();
                        if (idList.contains(factoryBase.getId())) continue;
                        changed = true;
                        break;
                    }
                    if (changed) {
                        for (AttributeChangeListener attributeChangeListener : new ArrayList(FactoryViewListAttribute.this.listeners)) {
                            FactoryViewListAttribute.this.runLater(() -> this.lambda$run$1(attributeChangeListener, (List)currentList));
                        }
                    }
                }
                this.previousList = currentList;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private boolean isEmpty(List<F> list) {
            return list == null || list.isEmpty();
        }

        public void stopTracking() {
            this.tracking = false;
        }

        private /* synthetic */ void lambda$run$1(AttributeChangeListener listener, List currentList) {
            listener.changed(FactoryViewListAttribute.this, currentList);
        }

        private /* synthetic */ void lambda$run$0(AttributeChangeListener listener, List currentList) {
            listener.changed(FactoryViewListAttribute.this, currentList);
        }
    }
}

