/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedString
implements Comparable<EncryptedString> {
    private final String encryptedString;

    @JsonCreator
    protected EncryptedString(@JsonProperty(value="encryptedString") String encryptedString) {
        this.encryptedString = encryptedString;
    }

    public EncryptedString(String value, String key) {
        try {
            byte[] decodedKey = Base64.getDecoder().decode(key);
            SecretKeySpec secKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
            Cipher AesCipher = Cipher.getInstance("AES");
            AesCipher.init(1, secKey);
            this.encryptedString = Base64.getEncoder().encodeToString(AesCipher.doFinal(value.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public String decrypt(String key) {
        try {
            byte[] decodedKey = Base64.getDecoder().decode(key);
            SecretKeySpec secKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
            Cipher AesCipher = Cipher.getInstance("AES");
            AesCipher.init(2, secKey);
            return new String(AesCipher.doFinal(Base64.getDecoder().decode(this.encryptedString.getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEncryptedString() {
        return this.encryptedString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptedString that = (EncryptedString)o;
        return this.encryptedString != null ? this.encryptedString.equals(that.encryptedString) : that.encryptedString == null;
    }

    public int hashCode() {
        return this.encryptedString != null ? this.encryptedString.hashCode() : 0;
    }

    @Override
    public int compareTo(EncryptedString other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int cmp = this.getClass().getName().compareTo(other.getClass().getName());
        if (cmp != 0) {
            return cmp;
        }
        if (this.encryptedString == null) {
            if (other.encryptedString == null) {
                return 0;
            }
            return -1;
        }
        if (other.encryptedString == null) {
            return 1;
        }
        return this.encryptedString.compareTo(other.encryptedString);
    }
}

