/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.attribute.ImmutableValueAttribute;
import io.github.factoryfx.factory.attribute.types.EncryptedString;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedStringAttribute
extends ImmutableValueAttribute<EncryptedString, EncryptedStringAttribute> {
    @JsonIgnore
    private boolean longText = false;

    @JsonIgnore
    public EncryptedStringAttribute longText() {
        this.longText = true;
        return this;
    }

    @JsonIgnore
    public boolean isLongText() {
        return this.longText;
    }

    public static String createKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            return Base64.getEncoder().encodeToString(keyGen.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public EncryptedStringAttribute encrypt(String value, String key) {
        this.set(new EncryptedString(value, key));
        return this;
    }

    public EncryptedStringAttribute set(String value, String key) {
        return this.encrypt(value, key);
    }

    public String decrypt(String key) {
        return ((EncryptedString)this.get()).decrypt(key);
    }

    public boolean internal_isValidKey(String key) {
        return new KeyValidator().validate(key);
    }

    public static class KeyValidator {
        public boolean validate(String key) {
            try {
                byte[] decodedKey = Base64.getDecoder().decode(key);
                SecretKeySpec secKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
                Cipher AesCipher = Cipher.getInstance("AES");
                AesCipher.init(1, secKey);
                Base64.getEncoder().encodeToString(AesCipher.doFinal("test".getBytes(StandardCharsets.UTF_8)));
            }
            catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                return false;
            }
            return true;
        }
    }
}

