/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.attribute.ImmutableValueAttribute;
import io.github.factoryfx.factory.attribute.types.EnumTranslations;
import io.github.factoryfx.factory.util.LanguageText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class EnumAttribute<E extends Enum<E>>
extends ImmutableValueAttribute<E, EnumAttribute<E>> {
    private final Class<E> clazz;
    @JsonIgnore
    private EnumTranslations<E> enumTranslations;

    public EnumAttribute(Class<E> clazz) {
        this.clazz = clazz;
    }

    public List<E> internal_possibleEnumValues() {
        return new ArrayList<Enum>(Arrays.asList((Enum[])this.clazz.getEnumConstants()));
    }

    public Class<E> internal_getEnumClass() {
        return this.clazz;
    }

    public EnumAttribute<E> deEnum(E value, String text) {
        if (this.enumTranslations == null) {
            this.enumTranslations = new EnumTranslations();
        }
        this.enumTranslations.deEnum(value, text);
        return this;
    }

    public EnumAttribute<E> enEnum(E value, String text) {
        if (this.enumTranslations == null) {
            this.enumTranslations = new EnumTranslations();
        }
        this.enumTranslations.enEnum(value, text);
        return this;
    }

    public String internal_enumDisplayText(Enum<?> enumValue, Function<LanguageText, String> uniformDesign) {
        if (enumValue == null) {
            return "-";
        }
        if (this.enumTranslations != null) {
            return this.enumTranslations.getDisplayText(enumValue, uniformDesign);
        }
        return enumValue.name();
    }
}

