/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.attribute.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.factoryfx.factory.util.LanguageText;
import java.util.HashMap;
import java.util.function.Function;

public class EnumTranslations<E extends Enum<E>> {
    @JsonIgnore
    public HashMap<E, LanguageText> enumTranslations;

    public void deEnum(E value, String text) {
        if (this.enumTranslations == null) {
            this.enumTranslations = new HashMap();
        }
        LanguageText languageText = this.enumTranslations.computeIfAbsent(value, k -> new LanguageText());
        languageText.de(text);
    }

    public void enEnum(E value, String text) {
        if (this.enumTranslations == null) {
            this.enumTranslations = new HashMap();
        }
        LanguageText languageText = this.enumTranslations.computeIfAbsent(value, k -> new LanguageText());
        languageText.en(text);
    }

    public String getDisplayText(Enum<?> enumValue, Function<LanguageText, String> uniformDesign) {
        LanguageText languageText;
        if (enumValue == null) {
            return "-";
        }
        if (this.enumTranslations != null && (languageText = this.enumTranslations.get(enumValue)) != null) {
            return uniformDesign.apply(languageText);
        }
        return enumValue.name();
    }
}

