/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.builder;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.dependency.FactoryAttribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryBaseAttribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryListAttribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryPolymorphicAttribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryPolymorphicListAttribute;
import io.github.factoryfx.factory.builder.FactoryContext;
import io.github.factoryfx.factory.metadata.FactoryMetadata;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import io.github.factoryfx.factory.parametrized.ParametrizedObjectCreatorAttribute;
import java.util.function.Function;

public class DefaultCreator<L, F extends FactoryBase<L, R>, R extends FactoryBase<?, R>>
implements Function<FactoryContext<R>, F> {
    private final Class<F> clazz;

    public DefaultCreator(Class<F> clazz) {
        this.clazz = clazz;
    }

    @Override
    public F apply(FactoryContext<R> context) {
        FactoryMetadata factoryMetadata = FactoryMetadataManager.getMetadata(this.clazz);
        F result = factoryMetadata.newInstance();
        factoryMetadata.setAttributeReferenceClasses(result);
        ((FactoryBase)result).internal().visitAttributesFlat((attributeVariableName, attribute) -> {
            Class clazz;
            if (attribute instanceof FactoryAttribute || attribute instanceof ParametrizedObjectCreatorAttribute) {
                FactoryBaseAttribute factoryBaseAttribute = (FactoryBaseAttribute)attribute;
                clazz = factoryBaseAttribute.internal_getReferenceClass();
                this.validateAttributeClass(attributeVariableName, clazz);
                if (factoryBaseAttribute.internal_required()) {
                    context.check(this.clazz, attributeVariableName, clazz);
                }
                Object factoryBase = context.getUnchecked(clazz);
                factoryBaseAttribute.set(factoryBase);
            }
            if (attribute instanceof FactoryListAttribute) {
                FactoryListAttribute factoryListAttribute = (FactoryListAttribute)attribute;
                clazz = factoryListAttribute.internal_getReferenceClass();
                this.validateAttributeClass(attributeVariableName, clazz);
                factoryListAttribute.set(context.getList(clazz));
            }
            if (attribute instanceof FactoryPolymorphicAttribute) {
                FactoryPolymorphicAttribute factoryPolymorphicAttribute = (FactoryPolymorphicAttribute)attribute;
                for (Class<?> possibleClazz : factoryPolymorphicAttribute.internal_possibleFactoriesClasses()) {
                    if (!context.anyMatch(possibleClazz)) continue;
                    factoryPolymorphicAttribute.set(context.get(possibleClazz));
                    break;
                }
            }
            if (attribute instanceof FactoryPolymorphicListAttribute) {
                FactoryPolymorphicListAttribute factoryPolymorphicListAttribute = (FactoryPolymorphicListAttribute)attribute;
                for (Class<?> possibleClazz : factoryPolymorphicListAttribute.internal_possibleFactoriesClasses()) {
                    if (!context.anyMatch(possibleClazz)) continue;
                    factoryPolymorphicListAttribute.add(context.get(possibleClazz));
                    break;
                }
            }
        });
        return result;
    }

    protected void validateAttributeClass(String attributeVariableName, Class<? extends FactoryBase> clazz) {
        if (clazz == null) {
            throw new IllegalStateException("cant build Factory " + this.clazz + ". Attribute: '" + attributeVariableName + "' missing factory clazz info");
        }
    }
}

