/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.builder;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.builder.FactoryCreator;
import io.github.factoryfx.factory.builder.FactoryCreatorIdentifier;
import io.github.factoryfx.factory.builder.Scope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public class FactoryContext<R extends FactoryBase<?, R>> {
    private final List<FactoryCreator<?, R>> factoryCreators = new ArrayList();

    public <L, F extends FactoryBase<?, R>> F get(Predicate<FactoryCreator<?, R>> filter) {
        return (F)((FactoryBase)this.factoryCreators.stream().filter(filter).findAny().map(rFactoryCreator -> rFactoryCreator.create(this)).orElse(null));
    }

    void check(Class<? extends FactoryBase> fromClazz, String attributeVariableName, Class<? extends FactoryBase> refClazz) {
        Object result = this.get((FactoryCreator<?, R> fc) -> fc.match(refClazz));
        if (result == null) {
            throw new IllegalStateException("\nbuilder missing Factory: " + refClazz.getName() + "\nrequired in: " + fromClazz + "\nfrom attribute: " + attributeVariableName);
        }
    }

    <F extends FactoryBase<?, R>> F getUnchecked(Class<F> clazz) {
        return this.get((FactoryCreator<?, R> fc) -> fc.match(clazz, null));
    }

    public <F extends FactoryBase<?, R>> F get(Class<F> clazz) {
        F result = this.get((FactoryCreator<?, R> fc) -> fc.match(clazz, null));
        if (result == null) {
            throw new IllegalStateException("builder missing Factory: " + clazz);
        }
        return result;
    }

    public <F extends FactoryBase<?, R>> F getUnsafe(Class<?> clazz) {
        F result = this.get((FactoryCreator<?, R> fc) -> fc.match(clazz, null));
        if (result == null) {
            throw new IllegalStateException("builder missing Factory: " + clazz);
        }
        return result;
    }

    public <F extends FactoryBase<?, R>> F get(Class<F> clazz, String name) {
        F result = this.get((FactoryCreator<?, R> fc) -> fc.match(clazz, name));
        if (result == null) {
            throw new IllegalStateException("builder missing Factory: " + clazz + "and name: " + name);
        }
        return result;
    }

    void addFactoryCreator(FactoryCreator<?, R> factoryCreator) {
        for (FactoryCreator<?, R> creator : this.factoryCreators) {
            if (!factoryCreator.isDuplicate(creator)) continue;
            throw new IllegalArgumentException("duplicate factory registration: " + factoryCreator);
        }
        this.factoryCreators.add(factoryCreator);
    }

    <L, F extends FactoryBase<L, R>> List<F> getList(Class<F> clazz) {
        ArrayList result = new ArrayList();
        this.factoryCreators.stream().filter(fc -> fc.match(clazz)).forEach(vFactoryCreator -> result.add(vFactoryCreator.create(this)));
        return result;
    }

    public <L, F extends FactoryBase<L, R>> boolean anyMatch(Class<F> clazz) {
        return this.factoryCreators.stream().anyMatch((? super T fc) -> fc.match(clazz));
    }

    public Scope getScope(Class<?> factoryClazz) {
        return this.factoryCreators.stream().filter(fc -> fc.match(factoryClazz)).findAny().map(FactoryCreator::getScope).orElse(null);
    }

    boolean isEmpty() {
        return this.factoryCreators.stream().allMatch(FactoryCreator::isEmpty);
    }

    public void fillFromExistingFactoryTree(R root) {
        List factories = ((FactoryBase)root).internal().collectChildrenDeep();
        HashMap classToFactory = new HashMap();
        for (FactoryBase factoryBase : factories) {
            classToFactory.put(new FactoryCreatorIdentifier(factoryBase.getClass(), factoryBase.internal().getTreeBuilderName()), factoryBase);
        }
        for (FactoryCreator factoryCreator : this.factoryCreators) {
            factoryCreator.fillFromExistingFactoryTree(classToFactory);
        }
    }

    <F extends FactoryBase<?, R>> F getNew(Class<F> clazz) {
        FactoryBase result = this.factoryCreators.stream().filter(fc -> fc.match(clazz)).findAny().map(rFactoryCreator -> rFactoryCreator.createNew(this)).orElse(null);
        if (result == null) {
            throw new IllegalStateException("builder missing Factory: " + clazz);
        }
        return (F)result;
    }
}

