/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.builder;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.builder.FactoryContext;
import io.github.factoryfx.factory.builder.FactoryCreatorIdentifier;
import io.github.factoryfx.factory.builder.Scope;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class FactoryCreator<F extends FactoryBase<?, R>, R extends FactoryBase<?, R>> {
    private final Class<F> clazz;
    private final Scope scope;
    private final Function<FactoryContext<R>, F> creator;
    private final String name;
    F factory;

    public FactoryCreator(Class<F> clazz, String name, Scope scope, Function<FactoryContext<R>, F> creator) {
        this.clazz = clazz;
        this.scope = scope;
        this.creator = creator;
        this.name = name;
    }

    public String toString() {
        return "FactoryCreator{clazz=" + this.clazz + ", name='" + this.name + "'}";
    }

    public boolean match(Class<?> clazzMatch, String name) {
        return this.clazz == clazzMatch && Objects.equals(this.name, name);
    }

    public boolean match(Class<?> clazzMatch) {
        return this.clazz == clazzMatch;
    }

    public boolean isDuplicate(FactoryCreator factoryCreator) {
        if (this.name == null && factoryCreator.name == null) {
            return this.clazz == factoryCreator.clazz;
        }
        if (this.name == null) {
            return false;
        }
        return this.clazz == factoryCreator.clazz && this.name.equals(factoryCreator.name);
    }

    public F create(FactoryContext<R> context) {
        if (this.scope == Scope.PROTOTYPE) {
            return (F)((FactoryBase)this.creator.apply(context));
        }
        if (this.factory == null) {
            this.factory = (FactoryBase)this.creator.apply(context);
            ((FactoryBase)this.factory).internal().setTreeBuilderName(this.name);
        }
        return this.factory;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isEmpty() {
        return this.factory == null;
    }

    public void fillFromExistingFactoryTree(Map<FactoryCreatorIdentifier, FactoryBase<?, ?>> classToFactory) {
        if (this.scope == Scope.SINGLETON) {
            this.factory = classToFactory.get(new FactoryCreatorIdentifier(this.clazz, this.name));
        }
    }

    public F createNew(FactoryContext<R> context) {
        this.factory = (FactoryBase)this.creator.apply(context);
        ((FactoryBase)this.factory).internal().setTreeBuilderName(this.name);
        return this.factory;
    }
}

