/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.builder;

import io.github.factoryfx.factory.BranchSelector;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.builder.DefaultCreator;
import io.github.factoryfx.factory.builder.FactoryContext;
import io.github.factoryfx.factory.builder.FactoryCreator;
import io.github.factoryfx.factory.builder.MicroserviceBuilder;
import io.github.factoryfx.factory.builder.Scope;
import io.github.factoryfx.factory.jackson.ObjectMapperBuilder;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.validation.ValidationError;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FactoryTreeBuilder<L, R extends FactoryBase<L, R>, S> {
    private final FactoryContext<R> factoryContext = new FactoryContext();
    private final Class<R> rootClass;
    private R rootFactory;

    public FactoryTreeBuilder(Class<R> rootClass) {
        this(rootClass, new DefaultCreator(rootClass));
    }

    public FactoryTreeBuilder(Class<R> rootClass, Function<FactoryContext<R>, R> creator) {
        if (rootClass == null) {
            throw new IllegalArgumentException("rootClass is mandatory");
        }
        this.rootClass = rootClass;
        this.addFactory(rootClass, Scope.SINGLETON, creator);
    }

    public <F extends FactoryBase<?, R>> void addFactory(Class<F> clazz, Scope scope, Function<FactoryContext<R>, F> creator) {
        this.addFactory(clazz, null, scope, creator);
    }

    public <F extends FactoryBase<?, R>> void addFactory(Class<F> clazz, String name, Scope scope, Function<FactoryContext<R>, F> creator) {
        this.factoryContext.addFactoryCreator(new FactoryCreator<F, R>(clazz, name, scope, creator));
    }

    public <LO, F extends FactoryBase<LO, R>> void addFactory(Class<F> clazz, Scope scope) {
        this.addFactory(clazz, scope, new DefaultCreator(clazz));
    }

    public R buildTree() {
        R root = this.buildTreeUnvalidated();
        this.validate(root);
        return root;
    }

    private void validate(R root) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (FactoryBase data : ((FactoryBase)root).internal().collectChildrenDeep()) {
            validationErrors.addAll(data.internal().validateFlat());
        }
        if (!validationErrors.isEmpty()) {
            throw new IllegalStateException("\n    Factory tree contains validation errors:\n        --------------------------------\n" + validationErrors.stream().map(ValidationError::getSimpleErrorDescription).collect(Collectors.joining("\n        --------------------------------\n")) + "\n        --------------------------------");
        }
    }

    public R buildTreeUnvalidated() {
        if (this.rootFactory != null) {
            return this.rootFactory;
        }
        this.rootFactory = this.factoryContext.get(this.rootClass);
        if (this.rootFactory == null) {
            throw new IllegalStateException("FactoryCreator missing for root class " + this.rootClass.getSimpleName() + "\nprobably missing call: factoryBuilder.addFactory(" + this.rootClass.getSimpleName() + ".class,...\n");
        }
        ((FactoryBase)this.rootFactory).internal().finalise();
        return this.rootFactory;
    }

    public <LO, FO extends FactoryBase<LO, R>> FO buildNewSubTree(Class<FO> factoryClazz) {
        return this.factoryContext.getNew(factoryClazz);
    }

    public <LO, FO extends FactoryBase<LO, R>> List<FO> buildSubTrees(Class<FO> factoryClazz) {
        return this.factoryContext.getList(factoryClazz);
    }

    public BranchSelector<R> branch() {
        return new BranchSelector(this);
    }

    public Scope getScope(Class<?> factoryClazz) {
        return this.factoryContext.getScope(factoryClazz);
    }

    public void fillFromExistingFactoryTree(R root) {
        this.factoryContext.fillFromExistingFactoryTree(root);
    }

    public MicroserviceBuilder<L, R, S> microservice() {
        return new MicroserviceBuilder(this.rootClass, this.buildTree(), this, ObjectMapperBuilder.build());
    }

    public MicroserviceBuilder<L, R, S> microservice(SimpleObjectMapper simpleObjectMapper) {
        return new MicroserviceBuilder(this.rootClass, this.buildTree(), this, simpleObjectMapper);
    }

    public MicroserviceBuilder<L, R, S> microservice(Consumer<R> mocker) {
        R root = this.buildTree();
        mocker.accept(root);
        return new MicroserviceBuilder(this.rootClass, root, this, ObjectMapperBuilder.build());
    }
}

