/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.builder;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.builder.FactoryTreeBuilder;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import io.github.factoryfx.factory.storage.migration.datamigration.AttributeFiller;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;

public class FactoryTreeBuilderAttributeFiller<L, R extends FactoryBase<L, R>, S>
implements AttributeFiller<R> {
    private final FactoryTreeBuilder<L, R, S> factoryTreeBuilder;

    public FactoryTreeBuilderAttributeFiller(FactoryTreeBuilder<L, R, S> factoryTreeBuilder) {
        this.factoryTreeBuilder = factoryTreeBuilder;
    }

    @Override
    public void fillNewAttributes(R root, DataStorageMetadataDictionary oldDataStorageMetadataDictionary) {
        this.factoryTreeBuilder.fillFromExistingFactoryTree(root);
        for (FactoryBase factory : ((FactoryBase)root).internal().collectChildrenDeep()) {
            boolean[] containsNewAttributes = new boolean[1];
            factory.internal().visitAttributesFlat((attributeVariableName, attribute) -> {
                if (this.isNewAttribute(factory, oldDataStorageMetadataDictionary, attributeVariableName)) {
                    containsNewAttributes[0] = true;
                    oldDataStorageMetadataDictionary.containsAttribute(factory.getClass().getName(), attributeVariableName);
                }
            });
            if (!containsNewAttributes[0]) continue;
            Class<?> aClass = factory.getClass();
            Object newBuild = this.factoryTreeBuilder.buildNewSubTree(aClass);
            FactoryMetadataManager.getMetadata(newBuild.getClass()).addBackReferencesAndReferenceClassToAttributes(newBuild, root);
            this.fillNewAttributes((FactoryBase)factory, (FactoryBase)newBuild, oldDataStorageMetadataDictionary);
        }
    }

    private <FO extends FactoryBase<?, R>> void fillNewAttributes(FO factory, FO newBuild, DataStorageMetadataDictionary oldDataStorageMetadataDictionary) {
        factory.internal().visitAttributesForMatch(newBuild, (attributeVariableName, newAttribute, newlyBuildAttribute) -> {
            if (this.isNewAttribute(factory, oldDataStorageMetadataDictionary, attributeVariableName) && newAttribute.get() == null) {
                newAttribute.set(newlyBuildAttribute.get());
            }
            return true;
        });
    }

    private <FO extends FactoryBase<?, R>> boolean isNewAttribute(FO currentFactoryRoot, DataStorageMetadataDictionary oldDataStorageMetadataDictionary, String attributeVariableName) {
        return !oldDataStorageMetadataDictionary.containsAttribute(currentFactoryRoot.getClass().getName(), attributeVariableName);
    }
}

