/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.exception;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.exception.ExceptionResponseAction;
import io.github.factoryfx.factory.exception.FactoryExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFactoryExceptionHandler<L, R extends FactoryBase<L, R>>
implements FactoryExceptionHandler<L, R> {
    private final FactoryExceptionHandler<L, R> delegate;
    private static final Logger logger = LoggerFactory.getLogger(LoggingFactoryExceptionHandler.class);

    public LoggingFactoryExceptionHandler(FactoryExceptionHandler<L, R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void updateException(Exception e, FactoryBase<?, ?> factory, ExceptionResponseAction<L, R> exceptionResponse) {
        this.log(e, factory, "createOrRecreate");
        this.delegate.updateException(e, factory, exceptionResponse);
    }

    @Override
    public void startException(Exception e, FactoryBase<?, ?> factory, ExceptionResponseAction<L, R> exceptionResponse) {
        this.log(e, factory, "start");
        this.delegate.startException(e, factory, exceptionResponse);
    }

    @Override
    public void destroyException(Exception e, FactoryBase<?, ?> factory, ExceptionResponseAction<L, R> exceptionResponse) {
        this.log(e, factory, "destroy");
        this.delegate.destroyException(e, factory, exceptionResponse);
    }

    private void log(Exception e, FactoryBase<?, ?> factory, String text) {
        logger.error("\nException during " + text + " for factory " + factory.getClass() + ":\n" + factory.internal().debugInfo(), (Throwable)e);
    }
}

