/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.fastfactory;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.AttributeCopy;
import io.github.factoryfx.factory.attribute.AttributeMatch;
import io.github.factoryfx.factory.attribute.CopySemantic;
import io.github.factoryfx.factory.attribute.dependency.FactoryListAttribute;
import io.github.factoryfx.factory.attribute.dependency.ReferenceBaseAttribute;
import io.github.factoryfx.factory.fastfactory.FastFactoryAttributeUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FastFactoryListAttribute<R extends FactoryBase<?, R>, F extends FactoryBase<?, R>, L, V extends FactoryBase<L, R>>
extends FastFactoryAttributeUtility<R, F, List<V>, FactoryListAttribute<R, L, V>> {
    private final Class<V> referenceClass;

    public FastFactoryListAttribute(Supplier<FactoryListAttribute<R, L, V>> attributeCreator, Function<F, List<V>> valueGetter, BiConsumer<F, List<V>> valueSetter, Class<V> referenceClass, String attributeName) {
        super(attributeCreator, valueGetter, valueSetter, attributeName);
        this.referenceClass = referenceClass;
    }

    @Override
    protected FactoryListAttribute<R, L, V> getAttribute() {
        FactoryListAttribute attribute = (FactoryListAttribute)super.getAttribute();
        attribute.internal_setReferenceClass(this.referenceClass);
        return attribute;
    }

    @Override
    public void visitChildFactory(Consumer<FactoryBase<?, R>> consumer) {
        List valueFactories = (List)this.valueGetter.apply(this.boundFactory);
        for (FactoryBase valueFactory : valueFactories) {
            if (valueFactory == null) continue;
            consumer.accept(valueFactory);
        }
    }

    @Override
    public void internal_copyTo(AttributeCopy<List<V>> copyAttribute, int level, int maxLevel, List<FactoryBase<?, ?>> oldData, FactoryBase<?, ?> parent, FactoryBase<?, ?> root) {
        List valueFactories = (List)this.valueGetter.apply(this.boundFactory);
        ArrayList result = new ArrayList();
        for (FactoryBase valueFactory : valueFactories) {
            Object copy = valueFactory.internal().copyDeep(level, maxLevel, oldData, parent, root);
            result.add(copy);
        }
        copyAttribute.set(result);
    }

    @Override
    public void internal_semanticCopyTo(AttributeCopy<List<V>> copyAttribute) {
        List valueFactories = (List)this.valueGetter.apply(this.boundFactory);
        if (((ReferenceBaseAttribute)this.getAttribute()).internal_getCopySemantic() == CopySemantic.SELF) {
            copyAttribute.set(valueFactories);
        } else {
            ArrayList result = new ArrayList();
            for (FactoryBase item : valueFactories) {
                Object itemCopy = item.utility().semanticCopy();
                if (itemCopy == null) continue;
                result.add(itemCopy);
            }
            copyAttribute.set(result);
        }
    }

    @Override
    public boolean internal_mergeMatch(AttributeMatch<List<V>> value) {
        List list = (List)this.valueGetter.apply(this.boundFactory);
        return this.internal_referenceListEquals(list, (List)value.get());
    }

    @Override
    public void internal_merge(List<V> newList) {
        ArrayList<V> oldList = (ArrayList<V>)this.valueGetter.apply(this.boundFactory);
        if (oldList == null) {
            oldList = new ArrayList<V>(newList);
        }
        this.internal_mergeFactoryList(oldList, newList);
    }
}

