/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.fastfactory;

import io.github.factoryfx.factory.AttributeVisitor;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.fastfactory.FastFactoryAttributeUtility;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FastFactoryUtility<R extends FactoryBase<?, R>, F extends FactoryBase<?, R>> {
    Supplier<List<? extends FastFactoryAttributeUtility<R, F, ?, ?>>> attributesCreator;
    private final List<? extends FastFactoryAttributeUtility<R, F, ?, ?>> attributeListForCopy1;
    private final List<? extends FastFactoryAttributeUtility<R, F, ?, ?>> attributeListForCopy2;
    private final List<? extends FastFactoryAttributeUtility<R, F, ?, ?>> attributeListForMatch1;
    private final List<? extends FastFactoryAttributeUtility<R, F, ?, ?>> attributeListForMatch2;

    public static <L, R extends FactoryBase<?, R>, F extends FactoryBase<L, R>> void setup(Class<F> clazz, FastFactoryUtility<R, F> fastFactoryUtility) {
        FactoryMetadataManager.getMetadata(clazz).setUseTemporaryAttributes();
        FactoryMetadataManager.getMetadata(clazz).setFastFactoryUtility(fastFactoryUtility);
    }

    public FastFactoryUtility(Supplier<List<? extends FastFactoryAttributeUtility<R, F, ?, ?>>> attributesCreator) {
        this.attributesCreator = attributesCreator;
        this.attributeListForCopy1 = attributesCreator.get();
        this.attributeListForCopy2 = attributesCreator.get();
        this.attributeListForMatch1 = attributesCreator.get();
        this.attributeListForMatch2 = attributesCreator.get();
    }

    public void visitAttributesFlat(F factory, AttributeVisitor attributeVisitor) {
        List<FastFactoryAttributeUtility<R, F, ?, ?>> attributeList1 = this.attributesCreator.get();
        for (FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility : attributeList1) {
            attributeUtility.setAttribute(factory);
        }
        for (FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility : attributeList1) {
            attributeUtility.accept(attributeVisitor);
        }
    }

    public static <L, R extends FactoryBase<?, R>> L instance(FactoryBase<L, R> childFactory) {
        L instance = null;
        if (childFactory != null) {
            instance = childFactory.internal().instance();
        }
        return instance;
    }

    public static <L, R extends FactoryBase<?, R>, F extends FactoryBase<L, R>> List<L> instances(List<F> childFactories) {
        return childFactories.stream().map(f -> f.internal().instance()).collect(Collectors.toList());
    }

    public synchronized void visitAttributesForCopy(F factory, F other, FactoryBase.BiCopyAttributeVisitor<?> consumer) {
        for (int i = 0; i < this.attributeListForCopy1.size(); ++i) {
            FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility1 = this.attributeListForCopy1.get(i);
            FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility2 = this.attributeListForCopy2.get(i);
            attributeUtility1.bindFactory(factory);
            attributeUtility2.bindFactory(other);
            this.visitAttributeForCopy(attributeUtility1, attributeUtility2, consumer);
        }
    }

    private <V> void visitAttributeForCopy(FastFactoryAttributeUtility<R, F, ?, ?> factory, FastFactoryAttributeUtility<R, F, ?, ?> other, FactoryBase.BiCopyAttributeVisitor<V> consumer) {
        consumer.accept(factory, other);
    }

    public synchronized <V> void visitAttributesForMatch(F factory, F other, FactoryBase.AttributeMatchVisitor<V> consumer) {
        for (FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility : this.attributeListForMatch1) {
            attributeUtility.bindFactory(factory);
        }
        for (FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility : this.attributeListForMatch2) {
            attributeUtility.bindFactory(other);
        }
        for (int i = 0; i < this.attributeListForMatch1.size(); ++i) {
            this.visitAttributeForMatch(this.attributeListForMatch1.get(i), this.attributeListForMatch2.get(i), consumer);
        }
    }

    private <V> void visitAttributeForMatch(FastFactoryAttributeUtility<R, F, ?, ?> factory, FastFactoryAttributeUtility<R, F, ?, ?> other, FactoryBase.AttributeMatchVisitor<V> consumer) {
        factory.accept(other, consumer);
    }

    public void visitChildFactoriesAndViewsFlat(F factory, Consumer<FactoryBase<?, R>> consumer) {
        List<FastFactoryAttributeUtility<R, F, ?, ?>> attributeList = this.attributesCreator.get();
        for (FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility : attributeList) {
            attributeUtility.bindFactory(factory);
            attributeUtility.visitChildFactory(consumer);
        }
    }

    public void visitAttributesTripleFlat(F factory, F other1, F other2, FactoryBase.TriAttributeVisitor<?> consumer) {
        List<FastFactoryAttributeUtility<R, F, ?, ?>> attributeList1 = this.attributesCreator.get();
        List<FastFactoryAttributeUtility<R, F, ?, ?>> attributeList2 = this.attributesCreator.get();
        List<FastFactoryAttributeUtility<R, F, ?, ?>> attributeList3 = this.attributesCreator.get();
        for (int i = 0; i < attributeList1.size(); ++i) {
            FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility1 = attributeList1.get(i);
            FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility2 = attributeList2.get(i);
            FastFactoryAttributeUtility<R, F, ?, ?> attributeUtility3 = attributeList3.get(i);
            attributeUtility1.bindFactory(factory);
            attributeUtility2.bindFactory(other1);
            attributeUtility3.bindFactory(other2);
            this.visitAttributeTripleFlat(attributeUtility1, attributeUtility2, attributeUtility3, consumer);
        }
    }

    private <V> void visitAttributeTripleFlat(FastFactoryAttributeUtility<R, F, ?, ?> factory, FastFactoryAttributeUtility<R, F, ?, ?> other1, FastFactoryAttributeUtility<R, F, ?, ?> other2, FactoryBase.TriAttributeVisitor<V> consumer) {
        factory.accept(other1, other2, consumer);
    }
}

