/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.factoryfx.factory.FactoryBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public class SimpleObjectMapper {
    private final ObjectMapper objectMapper;

    public SimpleObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T copy(T value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeValue(value, out);
        return (T)this.readValue(new ByteArrayInputStream(out.toByteArray()), value.getClass());
    }

    private <T> T readInternal(ReaderFunction<T> function) {
        try {
            T value = function.read();
            if (value instanceof FactoryBase) {
                return ((FactoryBase)value).internal().finalise();
            }
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T readValue(String content, Class<T> valueType) {
        return (T)this.readInternal(() -> this.objectMapper.readValue(content, valueType));
    }

    public <T> T readValue(File file, Class<T> valueType) {
        return (T)this.readInternal(() -> this.objectMapper.readValue(file, valueType));
    }

    public <T> T readValue(InputStream inputStream, Class<T> valueType) {
        return (T)this.readInternal(() -> this.objectMapper.readValue(inputStream, valueType));
    }

    public void writeValue(Object object, OutputStream out) {
        try {
            this.objectMapper.writeValue(out, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeValue(File file, Object s) {
        try {
            this.objectMapper.writeValue(file, s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String writeValueAsString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode readTree(String content) {
        try {
            return this.objectMapper.readTree(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode readTree(Path path) {
        try {
            return this.objectMapper.readTree(path.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String writeTree(JsonNode node) {
        try {
            Object value = this.objectMapper.treeToValue((TreeNode)node, Object.class);
            return this.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode writeValueAsTree(Object object) {
        return this.objectMapper.valueToTree(object);
    }

    public <T> T treeToValue(JsonNode jsonNode, Class<T> rootClass) {
        try {
            return (T)this.objectMapper.treeToValue((TreeNode)jsonNode, rootClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface ReaderFunction<T> {
        public T read() throws IOException;
    }
}

