/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.log.FactoryLogEntryEvent;
import io.github.factoryfx.factory.log.FactoryLogEntryEventType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
public class FactoryLogEntry {
    public final Class<? extends FactoryBase<?, ?>> factoryClass;
    public final String factoryDescription;
    public final long id;
    @JsonProperty
    long createDurationNs;
    @JsonProperty
    long recreateDurationNs;
    @JsonProperty
    long startDurationNs;
    @JsonProperty
    long destroyDurationNs;
    @JsonProperty
    long updateDurationNs;

    @JsonCreator
    public FactoryLogEntry(@JsonProperty(value="factoryClass") Class<? extends FactoryBase<?, ?>> factoryClass, @JsonProperty(value="displayText") String factoryDescription, @JsonProperty(value="id") long id) {
        this.factoryClass = factoryClass;
        this.factoryDescription = factoryDescription;
        this.id = id;
    }

    public FactoryLogEntry(FactoryBase<?, ?> factoryBase) {
        this(factoryBase.getClass(), factoryBase.internal().getFactoryDisplayText(), ThreadLocalRandom.current().nextLong(Long.MAX_VALUE));
    }

    public void logCreate(long createDurationNs) {
        this.createDurationNs = createDurationNs;
    }

    public void logRecreate(long recreateDurationNs) {
        this.recreateDurationNs = recreateDurationNs;
    }

    public void logStart(long startDurationNs) {
        this.startDurationNs = startDurationNs;
    }

    public void logDestroy(long destroyDurationNs) {
        this.destroyDurationNs = destroyDurationNs;
    }

    public void logUpdate(long updateDurationNs) {
        this.updateDurationNs = updateDurationNs;
    }

    @JsonIgnore
    public List<FactoryLogEntryEvent> getEvents() {
        ArrayList<FactoryLogEntryEvent> events = new ArrayList<FactoryLogEntryEvent>();
        if (this.createDurationNs != 0L) {
            events.add(new FactoryLogEntryEvent(FactoryLogEntryEventType.CREATE, this.createDurationNs));
        }
        if (this.recreateDurationNs != 0L) {
            events.add(new FactoryLogEntryEvent(FactoryLogEntryEventType.RECREATE, this.recreateDurationNs));
        }
        if (this.startDurationNs != 0L) {
            events.add(new FactoryLogEntryEvent(FactoryLogEntryEventType.START, this.startDurationNs));
        }
        if (this.destroyDurationNs != 0L) {
            events.add(new FactoryLogEntryEvent(FactoryLogEntryEventType.DESTROY, this.destroyDurationNs));
        }
        if (this.updateDurationNs != 0L) {
            events.add(new FactoryLogEntryEvent(FactoryLogEntryEventType.UPDATE, this.updateDurationNs));
        }
        return events;
    }

    public String getFactoryDescription() {
        return this.factoryDescription;
    }
}

