/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.merge;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import java.util.UUID;

public class AttributeDiffInfo {
    @JsonProperty
    public final String attributeName;
    @JsonProperty
    public final UUID dataId;

    @JsonCreator
    public AttributeDiffInfo(@JsonProperty(value="attributeName") String attributeName, @JsonProperty(value="parentId") UUID dataId) {
        this.attributeName = attributeName;
        this.dataId = dataId;
    }

    @JsonIgnore
    public String getAttributeDisplayText(FactoryBase<?, ?> root) {
        Attribute<?, ?> attribute = this.getAttribute(root);
        if (attribute != null) {
            return attribute.getDisplayText();
        }
        return "empty";
    }

    @JsonIgnore
    public Attribute<?, ?> getAttribute(FactoryBase<?, ?> root) {
        FactoryBase<?, ?> data = root.internal().collectChildFactoryMap().get(this.dataId);
        if (data != null) {
            Attribute[] result = new Attribute[1];
            data.internal().visitAttributesFlat((attributeVariableName, attribute) -> {
                if (attributeVariableName.equals(this.attributeName)) {
                    result[0] = attribute;
                }
            });
            return result[0];
        }
        return null;
    }

    @JsonIgnore
    public boolean isFromFactory(UUID factoryId) {
        return this.dataId.equals(factoryId);
    }

    @JsonIgnore
    public String parentDisplayText(FactoryBase<?, ?> root) {
        FactoryBase<?, ?> data = root.internal().collectChildFactoryMap().get(this.dataId);
        if (data != null) {
            return data.internal().getDisplayText();
        }
        return "";
    }
}

